/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms;

import java.util.List;
import java.util.Optional;
import org.hesperides.core.infrastructure.mongo.platforms.documents.PlatformDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.PlatformKeyDocument;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.repository.ExistsQuery;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.stereotype.Repository;

@Profile(value={"mongo", "fake_mongo"})
@Repository
public interface MongoPlatformRepository
extends MongoRepository<PlatformDocument, String> {
    @Query(value="{ 'key' : ?0 }", fields="{ '_id' : 1 }")
    public Optional<PlatformDocument> findOptionalIdByKey(PlatformKeyDocument var1);

    public boolean existsByKey(PlatformKeyDocument var1);

    public Optional<PlatformDocument> findOptionalByKey(PlatformKeyDocument var1);

    public List<PlatformDocument> findAllByKeyApplicationName(String var1);

    public List<PlatformDocument> findAllByDeployedModulesNameAndDeployedModulesVersionAndDeployedModulesIsWorkingCopy(String var1, String var2, boolean var3);

    public List<PlatformDocument> findAllByKeyApplicationNameLike(String var1);

    public List<PlatformDocument> findAllByKeyApplicationNameLikeAndKeyPlatformNameLike(String var1, String var2);

    @Query(value="{'key': ?0}", fields="{ 'deployedModules' : { $elemMatch : { 'propertiesPath' : ?1}}}")
    public PlatformDocument findByKeyAndFilterDeployedModulesByPropertiesPath(PlatformKeyDocument var1, String var2);

    @ExistsQuery(value="{'key': ?0, 'deployedModules.name': ?1, 'deployedModules.version': ?2, 'deployedModules.isWorkingCopy': ?3, 'deployedModules.path': ?4}")
    public boolean existsByPlatformKeyAndModuleKeyAndPath(PlatformKeyDocument var1, String var2, String var3, boolean var4, String var5);

    @ExistsQuery(value="{'key': ?0, 'deployedModules.name': ?1, 'deployedModules.version': ?2, 'deployedModules.isWorkingCopy': ?3, 'deployedModules.path': ?4, 'deployedModules.instances.name': ?5}")
    public boolean existsByPlatformKeyAndModuleKeyAndPathAndInstanceName(PlatformKeyDocument var1, String var2, String var3, boolean var4, String var5, String var6);
}

