/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.queryhandling.QueryHandler;
import org.hesperides.core.domain.modules.entities.Module;
import org.hesperides.core.domain.platforms.DeployedModuleExistsQuery;
import org.hesperides.core.domain.platforms.GetApplicationByNameQuery;
import org.hesperides.core.domain.platforms.GetDeployedModulesPropertiesQuery;
import org.hesperides.core.domain.platforms.GetGlobalPropertiesQuery;
import org.hesperides.core.domain.platforms.GetInstanceModelQuery;
import org.hesperides.core.domain.platforms.GetPlatformByIdQuery;
import org.hesperides.core.domain.platforms.GetPlatformByKeyQuery;
import org.hesperides.core.domain.platforms.GetPlatformIdFromKeyQuery;
import org.hesperides.core.domain.platforms.GetPlatformsUsingModuleQuery;
import org.hesperides.core.domain.platforms.InstanceExistsQuery;
import org.hesperides.core.domain.platforms.PlatformCopiedEvent;
import org.hesperides.core.domain.platforms.PlatformCreatedEvent;
import org.hesperides.core.domain.platforms.PlatformDeletedEvent;
import org.hesperides.core.domain.platforms.PlatformExistsByKeyQuery;
import org.hesperides.core.domain.platforms.PlatformModulePropertiesUpdatedEvent;
import org.hesperides.core.domain.platforms.PlatformProjectionRepository;
import org.hesperides.core.domain.platforms.PlatformPropertiesUpdatedEvent;
import org.hesperides.core.domain.platforms.PlatformUpdatedEvent;
import org.hesperides.core.domain.platforms.SearchApplicationsQuery;
import org.hesperides.core.domain.platforms.SearchPlatformsQuery;
import org.hesperides.core.domain.platforms.queries.views.ApplicationView;
import org.hesperides.core.domain.platforms.queries.views.InstancePropertyView;
import org.hesperides.core.domain.platforms.queries.views.ModulePlatformView;
import org.hesperides.core.domain.platforms.queries.views.PlatformView;
import org.hesperides.core.domain.platforms.queries.views.SearchApplicationResultView;
import org.hesperides.core.domain.platforms.queries.views.SearchPlatformResultView;
import org.hesperides.core.domain.platforms.queries.views.properties.AbstractValuedPropertyView;
import org.hesperides.core.domain.platforms.queries.views.properties.ValuedPropertyView;
import org.hesperides.core.infrastructure.mongo.platforms.MongoPlatformRepository;
import org.hesperides.core.infrastructure.mongo.platforms.documents.AbstractValuedPropertyDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.InstancePropertyDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.PlatformDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.PlatformKeyDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.ValuedPropertyDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Profile(value={"mongo", "fake_mongo"})
@Repository
public class MongoPlatformProjectionRepository
implements PlatformProjectionRepository {
    private final MongoPlatformRepository platformRepository;

    @Autowired
    public MongoPlatformProjectionRepository(MongoPlatformRepository platformRepository) {
        this.platformRepository = platformRepository;
    }

    @EventHandler
    public void onPlatformCreatedEvent(PlatformCreatedEvent event) {
        PlatformDocument platformDocument = new PlatformDocument(event.getPlatformId(), event.getPlatform());
        platformDocument.extractInstancePropertiesAndSave(this.platformRepository);
    }

    @EventHandler
    public void onPlatformCopiedEvent(PlatformCopiedEvent event) {
        PlatformDocument existingPlatform = (PlatformDocument)this.platformRepository.findById(event.getExistingPlatformId()).get();
        PlatformDocument newPlatform = new PlatformDocument(event.getNewPlatformId(), event.getNewPlatform());
        newPlatform.setDeployedModules(existingPlatform.getDeployedModules());
        newPlatform.setValuedProperties(existingPlatform.getValuedProperties());
        this.platformRepository.save(newPlatform);
    }

    @EventHandler
    public void onPlatformDeletedEvent(PlatformDeletedEvent event) {
        this.platformRepository.deleteById(event.getPlatformId());
    }

    @EventHandler
    public void onPlatformUpdatedEvent(PlatformUpdatedEvent event) {
        PlatformDocument platformDocument = new PlatformDocument(event.getPlatformId(), event.getPlatform());
        platformDocument.extractInstancePropertiesAndSave(this.platformRepository);
    }

    @EventHandler
    public void onPlatformModulePropertiesUpdatedEvent(PlatformModulePropertiesUpdatedEvent event) {
        List<AbstractValuedPropertyDocument> abstractValuedPropertyDocuments = AbstractValuedPropertyDocument.fromAbstractDomainInstances(event.getValuedProperties());
        PlatformDocument platformDocument = (PlatformDocument)this.platformRepository.findById(event.getPlatformId()).get();
        platformDocument.setVersionId(event.getPlatformVersionId());
        platformDocument.getDeployedModules().stream().filter(moduleDocument -> moduleDocument.getPropertiesPath().equals(event.getModulePath())).findAny().ifPresent(module -> {
            module.setValuedProperties(abstractValuedPropertyDocuments);
            platformDocument.extractInstancePropertiesAndSave(this.platformRepository);
        });
    }

    @EventHandler
    public void onPlatformPropertiesUpdatedEvent(PlatformPropertiesUpdatedEvent event) {
        List<ValuedPropertyDocument> valuedProperties = event.getValuedProperties().stream().map(ValuedPropertyDocument::new).collect(Collectors.toList());
        PlatformDocument platformDocument = (PlatformDocument)this.platformRepository.findById(event.getPlatformId()).get();
        platformDocument.setVersionId(event.getPlatformVersionId());
        platformDocument.setValuedProperties(valuedProperties);
        platformDocument.extractInstancePropertiesAndSave(this.platformRepository);
    }

    @QueryHandler
    public Optional<String> onGetPlatformIdFromKeyQuery(GetPlatformIdFromKeyQuery query) {
        PlatformKeyDocument keyDocument = new PlatformKeyDocument(query.getPlatformKey());
        return this.platformRepository.findOptionalIdByKey(keyDocument).map(PlatformDocument::getId);
    }

    @QueryHandler
    public Optional<PlatformView> onGetPlatformByIdQuery(GetPlatformByIdQuery query) {
        return this.platformRepository.findById(query.getPlatformId()).map(PlatformDocument::toPlatformView);
    }

    @QueryHandler
    public Optional<PlatformView> onGetPlatformByKeyQuery(GetPlatformByKeyQuery query) {
        PlatformKeyDocument platformKeyDocument = new PlatformKeyDocument(query.getPlatformKey());
        return this.platformRepository.findOptionalByKey(platformKeyDocument).map(PlatformDocument::toPlatformView);
    }

    @QueryHandler
    public Boolean onPlatformExistsByKeyQuery(PlatformExistsByKeyQuery query) {
        PlatformKeyDocument platformKeyDocument = new PlatformKeyDocument(query.getPlatformKey());
        return this.platformRepository.existsByKey(platformKeyDocument);
    }

    @QueryHandler
    public Optional<ApplicationView> onGetApplicationByNameQuery(GetApplicationByNameQuery query) {
        List<PlatformDocument> platformDocuments = this.platformRepository.findAllByKeyApplicationName(query.getApplicationName());
        return Optional.ofNullable(CollectionUtils.isEmpty(platformDocuments) ? null : PlatformDocument.toApplicationView(query.getApplicationName(), platformDocuments));
    }

    @QueryHandler
    public List<InstancePropertyView> onGetInstanceModelQuery(GetInstanceModelQuery query) {
        PlatformKeyDocument platformKeyDocument = new PlatformKeyDocument(query.getPlatformKey());
        PlatformDocument platformDocument = this.platformRepository.findByKeyAndFilterDeployedModulesByPropertiesPath(platformKeyDocument, query.getPath());
        return Optional.ofNullable(platformDocument.getDeployedModules()).orElse(Collections.emptyList()).stream().flatMap(deployedModule -> deployedModule.getInstanceProperties().stream().map(InstancePropertyDocument::toInstancePropertyView)).collect(Collectors.toList());
    }

    @QueryHandler
    public List<ModulePlatformView> onGetPlatformUsingModuleQuery(GetPlatformsUsingModuleQuery query) {
        Module.Key moduleKey = query.getModuleKey();
        List<PlatformDocument> platformDocuments = this.platformRepository.findAllByDeployedModulesNameAndDeployedModulesVersionAndDeployedModulesIsWorkingCopy(moduleKey.getName(), moduleKey.getVersion(), moduleKey.isWorkingCopy());
        return platformDocuments.stream().map(PlatformDocument::toModulePlatformView).collect(Collectors.toList());
    }

    @QueryHandler
    public List<SearchPlatformResultView> onSearchPlatformsQuery(SearchPlatformsQuery query) {
        String platformName = StringUtils.defaultString((String)query.getPlatformName(), (String)"");
        List<PlatformDocument> platformDocuments = this.platformRepository.findAllByKeyApplicationNameLikeAndKeyPlatformNameLike(query.getApplicationName(), platformName);
        return platformDocuments.stream().map(PlatformDocument::toSearchPlatformResultView).collect(Collectors.toList());
    }

    @QueryHandler
    public List<SearchApplicationResultView> onSearchApplicationsQuery(SearchApplicationsQuery query) {
        List<PlatformDocument> platformDocuments = this.platformRepository.findAllByKeyApplicationNameLike(query.getApplicationName());
        return platformDocuments.stream().map(PlatformDocument::toSearchApplicationResultView).collect(Collectors.toList());
    }

    @QueryHandler
    public List<AbstractValuedPropertyView> onGetDeployedModulePropertiesQuery(GetDeployedModulesPropertiesQuery query) {
        PlatformKeyDocument platformKeyDocument = new PlatformKeyDocument(query.getPlatformKey());
        PlatformDocument platformDocument = this.platformRepository.findByKeyAndFilterDeployedModulesByPropertiesPath(platformKeyDocument, query.getPath());
        List<AbstractValuedPropertyDocument> abstractValuedPropertyDocuments = Optional.ofNullable(platformDocument.getDeployedModules()).orElse(Collections.emptyList()).stream().filter(deployedModuleDocument -> query.getPath().equals(deployedModuleDocument.getPropertiesPath())).flatMap(deployedModuleDocument -> Optional.ofNullable(deployedModuleDocument.getValuedProperties()).orElse(Collections.emptyList()).stream()).collect(Collectors.toList());
        return AbstractValuedPropertyDocument.toAbstractValuedPropertyViews(abstractValuedPropertyDocuments);
    }

    @QueryHandler
    public List<ValuedPropertyView> onGetGlobalPropertiesQuery(GetGlobalPropertiesQuery query) {
        PlatformKeyDocument platformKeyDocument = new PlatformKeyDocument(query.getPlatformKey());
        return this.platformRepository.findOptionalByKey(platformKeyDocument).map(PlatformDocument::getValuedProperties).map(ValuedPropertyDocument::toValuedPropertyViews).orElse(Collections.emptyList());
    }

    public Boolean onDeployedModuleExistsQuery(DeployedModuleExistsQuery query) {
        PlatformKeyDocument platformKeyDocument = new PlatformKeyDocument(query.getPlatformKey());
        Module.Key moduleKey = query.getModuleKey();
        return this.platformRepository.existsByPlatformKeyAndModuleKeyAndPath(platformKeyDocument, moduleKey.getName(), moduleKey.getVersion(), moduleKey.isWorkingCopy(), query.getModulePath());
    }

    public Boolean onInstanceExistsQuery(InstanceExistsQuery query) {
        PlatformKeyDocument platformKeyDocument = new PlatformKeyDocument(query.getPlatformKey());
        Module.Key moduleKey = query.getModuleKey();
        return this.platformRepository.existsByPlatformKeyAndModuleKeyAndPathAndInstanceName(platformKeyDocument, moduleKey.getName(), moduleKey.getVersion(), moduleKey.isWorkingCopy(), query.getModulePath(), query.getInstanceName());
    }
}

