/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.modules;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.queryhandling.QueryHandler;
import org.hesperides.core.domain.modules.GetModuleTemplatesQuery;
import org.hesperides.core.domain.modules.GetTemplateByNameQuery;
import org.hesperides.core.domain.modules.TemplateCreatedEvent;
import org.hesperides.core.domain.modules.TemplateDeletedEvent;
import org.hesperides.core.domain.modules.TemplateProjectionRepository;
import org.hesperides.core.domain.modules.TemplateUpdatedEvent;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.hesperides.core.domain.templatecontainers.queries.TemplateView;
import org.hesperides.core.infrastructure.mongo.modules.ModuleDocument;
import org.hesperides.core.infrastructure.mongo.modules.MongoModuleRepository;
import org.hesperides.core.infrastructure.mongo.templatecontainers.KeyDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.TemplateDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;

@Profile(value={"mongo", "fake_mongo"})
@Repository
public class MongoTemplateProjectionRepository
implements TemplateProjectionRepository {
    private final MongoModuleRepository moduleRepository;

    @Autowired
    public MongoTemplateProjectionRepository(MongoModuleRepository moduleRepository) {
        this.moduleRepository = moduleRepository;
    }

    @EventHandler
    public void onTemplateCreatedEvent(TemplateCreatedEvent event) {
        ModuleDocument moduleDocument = (ModuleDocument)this.moduleRepository.findById(event.getModuleId()).get();
        TemplateDocument templateDocument = new TemplateDocument(event.getTemplate());
        moduleDocument.addTemplate(templateDocument);
        moduleDocument.extractPropertiesAndSave(this.moduleRepository);
    }

    @EventHandler
    public void onTemplateUpdatedEvent(TemplateUpdatedEvent event) {
        ModuleDocument moduleDocument = (ModuleDocument)this.moduleRepository.findById(event.getModuleId()).get();
        TemplateDocument templateDocument = new TemplateDocument(event.getTemplate());
        moduleDocument.updateTemplate(templateDocument);
        moduleDocument.extractPropertiesAndSave(this.moduleRepository);
    }

    @EventHandler
    public void onTemplateDeletedEvent(TemplateDeletedEvent event) {
        ModuleDocument moduleDocument = (ModuleDocument)this.moduleRepository.findById(event.getModuleId()).get();
        moduleDocument.removeTemplate(event.getTemplateName());
        moduleDocument.extractPropertiesAndSave(this.moduleRepository);
    }

    @QueryHandler
    public Optional<TemplateView> onGetTemplateByNameQuery(GetTemplateByNameQuery query) {
        String templateName = query.getTemplateName();
        return this.moduleRepository.findOptionalByKeyAndTemplatesName(new KeyDocument(query.getModuleKey()), templateName).map(moduleDocument -> moduleDocument.getTemplates().stream().filter(templateDocument -> templateDocument.getName().equalsIgnoreCase(templateName)).findFirst().map(templateDocument -> templateDocument.toTemplateView(query.getModuleKey()))).orElse(Optional.empty());
    }

    @QueryHandler
    public List<TemplateView> onGetModuleTemplatesQuery(GetModuleTemplatesQuery query) {
        TemplateContainer.Key moduleKey = query.getModuleKey();
        return this.moduleRepository.findOptionalByKey(new KeyDocument(moduleKey)).map(moduleDocument -> moduleDocument.getTemplates().stream().map(templateDocument -> templateDocument.toTemplateView(moduleKey)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

