/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.modules;

import com.mongodb.client.DistinctIterable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.queryhandling.QueryHandler;
import org.hesperides.core.domain.modules.GetModuleByIdQuery;
import org.hesperides.core.domain.modules.GetModuleByKeyQuery;
import org.hesperides.core.domain.modules.GetModuleIdFromKeyQuery;
import org.hesperides.core.domain.modules.GetModulePropertiesQuery;
import org.hesperides.core.domain.modules.GetModuleVersionTypesQuery;
import org.hesperides.core.domain.modules.GetModuleVersionsQuery;
import org.hesperides.core.domain.modules.GetModulesNameQuery;
import org.hesperides.core.domain.modules.ModuleCreatedEvent;
import org.hesperides.core.domain.modules.ModuleDeletedEvent;
import org.hesperides.core.domain.modules.ModuleExistsQuery;
import org.hesperides.core.domain.modules.ModuleProjectionRepository;
import org.hesperides.core.domain.modules.ModuleTechnosUpdatedEvent;
import org.hesperides.core.domain.modules.SearchModulesQuery;
import org.hesperides.core.domain.modules.queries.ModuleView;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.hesperides.core.domain.templatecontainers.queries.AbstractPropertyView;
import org.hesperides.core.infrastructure.mongo.modules.ModuleDocument;
import org.hesperides.core.infrastructure.mongo.modules.MongoModuleRepository;
import org.hesperides.core.infrastructure.mongo.technos.MongoTechnoProjectionRepository;
import org.hesperides.core.infrastructure.mongo.technos.TechnoDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.AbstractPropertyDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.KeyDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;

@Profile(value={"mongo", "fake_mongo"})
@Repository
public class MongoModuleProjectionRepository
implements ModuleProjectionRepository {
    private final MongoModuleRepository moduleRepository;
    private final MongoTechnoProjectionRepository technoProjectionRepository;
    private final MongoTemplate mongoTemplate;

    @Autowired
    public MongoModuleProjectionRepository(MongoModuleRepository moduleRepository, MongoTechnoProjectionRepository technoProjectionRepository, MongoTemplate mongoTemplate) {
        this.moduleRepository = moduleRepository;
        this.technoProjectionRepository = technoProjectionRepository;
        this.mongoTemplate = mongoTemplate;
    }

    @EventHandler
    public void onModuleCreatedEvent(ModuleCreatedEvent event) {
        List<TechnoDocument> technoDocuments = this.technoProjectionRepository.getTechnoDocumentsFromDomainInstances(event.getModule().getTechnos());
        ModuleDocument moduleDocument = new ModuleDocument(event.getModuleId(), event.getModule(), technoDocuments);
        moduleDocument.extractPropertiesAndSave(this.moduleRepository);
    }

    @EventHandler
    public void onModuleTechnosUpdatedEvent(ModuleTechnosUpdatedEvent event) {
        ModuleDocument moduleDocument = (ModuleDocument)this.moduleRepository.findById(event.getModuleId()).get();
        List<TechnoDocument> technoDocuments = this.technoProjectionRepository.getTechnoDocumentsFromDomainInstances(event.getTechnos());
        moduleDocument.setTechnos(technoDocuments);
        moduleDocument.setVersionId(event.getVersionId());
        moduleDocument.extractPropertiesAndSave(this.moduleRepository);
    }

    @EventHandler
    public void onModuleDeletedEvent(ModuleDeletedEvent event) {
        this.moduleRepository.deleteById(event.getModuleId());
    }

    @QueryHandler
    public Optional<String> onGetModuleIdFromKeyQuery(GetModuleIdFromKeyQuery query) {
        KeyDocument keyDocument = new KeyDocument(query.getModuleKey());
        return this.moduleRepository.findOptionalIdByKey(keyDocument).map(ModuleDocument::getId);
    }

    @QueryHandler
    public Optional<ModuleView> onGetModuleByIdQuery(GetModuleByIdQuery query) {
        return this.moduleRepository.findOptionalById(query.getModuleId()).map(ModuleDocument::toModuleView);
    }

    @QueryHandler
    public Optional<ModuleView> onGetModuleByKeyQuery(GetModuleByKeyQuery query) {
        KeyDocument keyDocument = new KeyDocument(query.getModuleKey());
        return this.moduleRepository.findOptionalByKey(keyDocument).map(ModuleDocument::toModuleView);
    }

    @QueryHandler
    public Boolean onModuleExistsQuery(ModuleExistsQuery query) {
        KeyDocument keyDocument = new KeyDocument(query.getModuleKey());
        return this.moduleRepository.existsByKey(keyDocument);
    }

    @QueryHandler
    public List<String> onGetModulesNameQuery(GetModulesNameQuery query) {
        DistinctIterable iterable = this.mongoTemplate.getCollection("module").distinct("key.name", String.class);
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    @QueryHandler
    public List<String> onGetModuleVersionTypesQuery(GetModuleVersionTypesQuery query) {
        return this.moduleRepository.findByKeyNameAndKeyVersion(query.getModuleName(), query.getModuleVersion()).stream().map(ModuleDocument::getKey).map(KeyDocument::isWorkingCopy).map(TemplateContainer.VersionType::toString).collect(Collectors.toList());
    }

    @QueryHandler
    public List<String> onGetModuleVersionsQuery(GetModuleVersionsQuery query) {
        return this.moduleRepository.findByKeyName(query.getModuleName()).stream().map(ModuleDocument::getKey).map(KeyDocument::getVersion).collect(Collectors.toList());
    }

    @QueryHandler
    public List<ModuleView> onSearchModulesQuery(SearchModulesQuery query) {
        String[] values = query.getInput().split(" ");
        String name = values.length >= 1 ? values[0] : "";
        String version = values.length >= 2 ? values[1] : "";
        PageRequest pageable = PageRequest.of((int)0, (int)10);
        List<ModuleDocument> moduleDocuments = this.moduleRepository.findAllByKeyNameLikeAndKeyVersionLike(name, version, (Pageable)pageable);
        return moduleDocuments.stream().map(ModuleDocument::toModuleView).collect(Collectors.toList());
    }

    @QueryHandler
    public List<AbstractPropertyView> onGetModulePropertiesQuery(GetModulePropertiesQuery query) {
        KeyDocument keyDocument = new KeyDocument(query.getModuleKey());
        ModuleDocument moduleDocument = this.moduleRepository.findByKey(keyDocument);
        return AbstractPropertyDocument.toAbstractPropertyViews(moduleDocument.getProperties());
    }
}

