/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.modules;

import java.util.ArrayList;
import java.util.List;
import org.hesperides.core.domain.modules.entities.Module;
import org.hesperides.core.domain.modules.queries.ModuleView;
import org.hesperides.core.domain.templatecontainers.entities.AbstractProperty;
import org.hesperides.core.domain.templatecontainers.entities.Template;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.hesperides.core.infrastructure.mongo.modules.MongoModuleRepository;
import org.hesperides.core.infrastructure.mongo.technos.TechnoDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.AbstractPropertyDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.KeyDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.TemplateDocument;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="module")
public class ModuleDocument {
    @Id
    private String id;
    @Indexed
    private KeyDocument key;
    private List<TemplateDocument> templates;
    @DBRef
    private List<TechnoDocument> technos;
    private List<AbstractPropertyDocument> properties;
    private Long versionId;

    public ModuleDocument(String id, Module module, List<TechnoDocument> technoDocuments) {
        this.id = id;
        this.key = new KeyDocument(module.getKey());
        this.templates = TemplateDocument.fromDomainInstances(module.getTemplates());
        this.technos = technoDocuments;
        this.versionId = module.getVersionId();
    }

    public ModuleView toModuleView() {
        Module.Key moduleKey = this.getDomainKey();
        return new ModuleView(this.key.getName(), this.key.getVersion(), this.key.isWorkingCopy(), TemplateDocument.toTemplateViews(this.templates, (TemplateContainer.Key)moduleKey), TechnoDocument.toTechnoViews(this.technos), this.versionId);
    }

    public void addTemplate(TemplateDocument templateDocument) {
        if (this.templates == null) {
            this.templates = new ArrayList<TemplateDocument>();
        }
        this.templates.add(templateDocument);
    }

    public void updateTemplate(TemplateDocument updatedTemplateDocument) {
        this.removeTemplate(updatedTemplateDocument.getName());
        this.addTemplate(updatedTemplateDocument);
    }

    public void removeTemplate(String templateName) {
        this.templates.removeIf(templateDocument -> templateDocument.getName().equalsIgnoreCase(templateName));
    }

    public void extractPropertiesAndSave(MongoModuleRepository moduleRepository) {
        this.setProperties(this.extractPropertiesFromTemplatesAndTechnos());
        moduleRepository.save(this);
    }

    private List<AbstractPropertyDocument> extractPropertiesFromTemplatesAndTechnos() {
        List<Template> allTemplates = this.getDomainTemplatesFromTemplateDocumentsAndTechnoDocuments();
        List abstractProperties = AbstractProperty.extractPropertiesFromTemplates(allTemplates);
        List<AbstractPropertyDocument> abstractPropertyDocuments = AbstractPropertyDocument.fromDomainInstances(abstractProperties);
        return abstractPropertyDocuments;
    }

    private List<Template> getDomainTemplatesFromTemplateDocumentsAndTechnoDocuments() {
        Module module = this.toDomainInstance();
        ArrayList<Template> allTemplates = new ArrayList<Template>();
        if (module.getTemplates() != null) {
            allTemplates.addAll(module.getTemplates());
        }
        if (module.getTechnos() != null) {
            module.getTechnos().forEach(techno -> {
                if (techno.getTemplates() != null) {
                    allTemplates.addAll(techno.getTemplates());
                }
            });
        }
        return allTemplates;
    }

    public Module toDomainInstance() {
        Module.Key moduleKey = this.getDomainKey();
        return new Module((TemplateContainer.Key)moduleKey, TemplateDocument.toDomainInstances(this.templates, (TemplateContainer.Key)moduleKey), TechnoDocument.toDomainInstances(this.technos), this.versionId);
    }

    private Module.Key getDomainKey() {
        return new Module.Key(this.key.getName(), this.key.getVersion(), TemplateContainer.getVersionType((boolean)this.key.isWorkingCopy()));
    }

    public String getId() {
        return this.id;
    }

    public KeyDocument getKey() {
        return this.key;
    }

    public List<TemplateDocument> getTemplates() {
        return this.templates;
    }

    public List<TechnoDocument> getTechnos() {
        return this.technos;
    }

    public List<AbstractPropertyDocument> getProperties() {
        return this.properties;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setKey(KeyDocument key) {
        this.key = key;
    }

    public void setTemplates(List<TemplateDocument> templates) {
        this.templates = templates;
    }

    public void setTechnos(List<TechnoDocument> technos) {
        this.technos = technos;
    }

    public void setProperties(List<AbstractPropertyDocument> properties) {
        this.properties = properties;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleDocument)) {
            return false;
        }
        ModuleDocument other = (ModuleDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        KeyDocument this$key = this.getKey();
        KeyDocument other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        List<TemplateDocument> this$templates = this.getTemplates();
        List<TemplateDocument> other$templates = other.getTemplates();
        if (this$templates == null ? other$templates != null : !((Object)this$templates).equals(other$templates)) {
            return false;
        }
        List<TechnoDocument> this$technos = this.getTechnos();
        List<TechnoDocument> other$technos = other.getTechnos();
        if (this$technos == null ? other$technos != null : !((Object)this$technos).equals(other$technos)) {
            return false;
        }
        List<AbstractPropertyDocument> this$properties = this.getProperties();
        List<AbstractPropertyDocument> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Long this$versionId = this.getVersionId();
        Long other$versionId = other.getVersionId();
        return !(this$versionId == null ? other$versionId != null : !((Object)this$versionId).equals(other$versionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        KeyDocument $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        List<TemplateDocument> $templates = this.getTemplates();
        result = result * 59 + ($templates == null ? 43 : ((Object)$templates).hashCode());
        List<TechnoDocument> $technos = this.getTechnos();
        result = result * 59 + ($technos == null ? 43 : ((Object)$technos).hashCode());
        List<AbstractPropertyDocument> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Long $versionId = this.getVersionId();
        result = result * 59 + ($versionId == null ? 43 : ((Object)$versionId).hashCode());
        return result;
    }

    public String toString() {
        return "ModuleDocument(id=" + this.getId() + ", key=" + this.getKey() + ", templates=" + this.getTemplates() + ", technos=" + this.getTechnos() + ", properties=" + this.getProperties() + ", versionId=" + this.getVersionId() + ")";
    }

    public ModuleDocument() {
    }
}

