/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.eventstores;

import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.memory.MemoryBackend;
import java.net.InetSocketAddress;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.mongo.DefaultMongoTemplate;
import org.axonframework.mongo.MongoTemplate;
import org.axonframework.mongo.eventsourcing.eventstore.MongoEventStorageEngine;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"fake_mongo"})
public class FakeAxonMongoEventStoreConfiguration {
    @Bean
    @Primary
    MongoClient mongoClient() {
        MongoServer server = new MongoServer((MongoBackend)new MemoryBackend());
        InetSocketAddress serverAddress = server.bind();
        return new MongoClient(new ServerAddress(serverAddress));
    }

    @Bean
    @Primary
    public EventStorageEngine eventStore(MongoClient client) {
        return new MongoEventStorageEngine((MongoTemplate)new DefaultMongoTemplate(client));
    }
}

