/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.eventstores;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.mongo.DefaultMongoTemplate;
import org.axonframework.mongo.MongoTemplate;
import org.axonframework.mongo.eventsourcing.eventstore.MongoEventStorageEngine;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.validation.annotation.Validated;

@Configuration
@Profile(value={"mongo"})
@Validated
@ConfigurationProperties(value="event-store")
public class AxonMongoEventStoreConfiguration {
    @NotNull
    private String uri;

    @Bean
    public MongoClient axonMongoClient(MongoClientURI axonMongoClientUri) {
        return new MongoClient(axonMongoClientUri);
    }

    @Bean
    public MongoClientURI axonMongoClientUri() {
        return new MongoClientURI(this.uri);
    }

    @Bean
    @Primary
    public EventStorageEngine eventStore(MongoClientURI axonMongoClientUri) {
        return new MongoEventStorageEngine((MongoTemplate)new DefaultMongoTemplate(this.axonMongoClient(axonMongoClientUri), axonMongoClientUri.getDatabase()));
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

