/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.eventstores;

import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.queryhandling.QueryHandler;
import org.hesperides.core.domain.events.EventRepository;
import org.hesperides.core.domain.events.GenericEventsByStreamQuery;
import org.hesperides.core.domain.events.PlatformEventsByStreamQuery;
import org.hesperides.core.domain.events.queries.EventView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;

@Profile(value={"mongo", "fake_mongo"})
@Repository
public class AxonEventRepository
implements EventRepository {
    EventStore eventStore;

    @Autowired
    public AxonEventRepository(EventStore eventStore) {
        this.eventStore = eventStore;
    }

    @QueryHandler
    public List<EventView> onGetEventsStream(GenericEventsByStreamQuery query) {
        return this.getEventViews(query.getEventStream().toString());
    }

    @QueryHandler
    public List<EventView> onGetEventsStream(PlatformEventsByStreamQuery query) {
        return this.getEventViews(query.getEventStream().toString());
    }

    private List<EventView> getEventViews(String aggragateIdentifier) {
        return this.eventStore.readEvents(aggragateIdentifier).asStream().map(EventView::new).collect(Collectors.toList());
    }
}

