/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.validation.annotation.Validated;

@Configuration
@Profile(value={"mongo"})
@EnableTransactionManagement
@EnableMongoRepositories(basePackages={"org.hesperides.core.infrastructure.mongo"})
@Validated
@ConfigurationProperties(value="projection-repository")
public class MongoProjectionRepositoryConfiguration {
    @NotNull
    private String uri;

    @Bean
    public MongoTemplate mongoTemplate(MongoClientURI projectionMongoClientUri) {
        return new MongoTemplate(this.mongo(projectionMongoClientUri), projectionMongoClientUri.getDatabase());
    }

    @Bean
    public MongoClient mongo(MongoClientURI projectionMongoClientUri) {
        return new MongoClient(projectionMongoClientUri);
    }

    @Bean
    public MongoClientURI projectionMongoClientUri() {
        return new MongoClientURI(this.uri);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

