/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo;

import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.memory.MemoryBackend;
import java.net.InetSocketAddress;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
@Profile(value={"fake_mongo"})
public class FakeMongoProjectionRepositoryConfiguration {
    private static final String MONGO_DB_NAME = "fake_database";

    @Bean(destroyMethod="close")
    public MongoClient mongo() {
        MongoServer server = new MongoServer((MongoBackend)new MemoryBackend());
        InetSocketAddress serverAddress = server.bind();
        return new MongoClient(new ServerAddress(serverAddress));
    }

    @Bean
    public MongoTemplate mongoTemplate() {
        return new MongoTemplate(this.mongo(), MONGO_DB_NAME);
    }
}

