/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.graphite;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"graphite"})
public class MetricsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MetricsConfiguration.class);
    @Value(value="${metrics.graphite.host}")
    private String graphiteHost;
    @Value(value="${metrics.graphite.period}")
    private int graphitePeriod;
    @Value(value="${metrics.graphite.port}")
    private int graphitePort;
    @Value(value="${metrics.graphite.prefix}")
    private String graphitePrefix;
    private final MetricRegistry registry = new MetricRegistry();

    @PostConstruct
    public void initialize() {
        log.info("Initializing Metrics Graphite reporting");
        Graphite graphite = new Graphite(new InetSocketAddress(this.graphiteHost, this.graphitePort));
        GraphiteReporter graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)this.registry).prefixedWith(this.graphitePrefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
        graphiteReporter.start((long)this.graphitePeriod, TimeUnit.SECONDS);
    }
}

