/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.NFISignature;

@ExportLibrary(value=InteropLibrary.class)
final class NFIClosure
implements TruffleObject {
    final Object executable;
    final NFISignature signature;

    NFIClosure(Object executable, NFISignature signature) {
        this.executable = executable;
        this.signature = signature;
    }

    @ExportMessage
    boolean isExecutable(@CachedLibrary(value="this.executable") InteropLibrary interop) {
        return interop.isExecutable(this.executable);
    }

    @ExportMessage
    static class Execute {
        Execute() {
        }

        static DirectCallNode createDirectCall(CallTarget target) {
            DirectCallNode ret = DirectCallNode.create((CallTarget)target);
            ret.forceInlining();
            return ret;
        }

        @Specialization(guards={"receiver.signature.cachedState != null", "receiver.signature.cachedState == cachedState"}, limit="3")
        static Object doOptimizedDirect(NFIClosure receiver, Object[] args, @Cached(value="receiver.signature.cachedState") NFISignature.SignatureCachedState cachedState, @Cached(value="cachedState.createOptimizedClosureCall()") CallSignatureNode call) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            assert (receiver.signature.cachedState == cachedState);
            return call.execute(receiver.signature, receiver.executable, args);
        }

        @Specialization(replaces={"doOptimizedDirect"}, guards={"receiver.signature.cachedState != null"})
        static Object doOptimizedIndirect(NFIClosure receiver, Object[] args, @Cached IndirectCallNode call) {
            return call.call(receiver.signature.cachedState.getPolymorphicClosureCall(), new Object[]{receiver.signature, receiver.executable, args});
        }

        @Specialization(guards={"receiver.signature.cachedState == null"})
        static Object doSlowPath(NFIClosure receiver, Object[] args, @Bind(value="$node") Node node, @Cached InlinedBranchProfile exception, @Cached ConvertTypeNode.ConvertFromNativeNode convertArg, @Cached ConvertTypeNode.ConvertToNativeNode convertRet, @CachedLibrary(value="receiver.executable") InteropLibrary interop) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            NFISignature signature = receiver.signature;
            if (args.length != signature.nativeArgCount) {
                exception.enter(node);
                throw ArityException.create((int)signature.nativeArgCount, (int)signature.nativeArgCount, (int)args.length);
            }
            Object[] preparedArgs = new Object[signature.managedArgCount];
            int argIdx = 0;
            for (int i = 0; i < signature.nativeArgCount; ++i) {
                if (signature.argTypes[i].cachedState.managedArgCount != 1) continue;
                preparedArgs[argIdx++] = convertArg.executeInlined(node, signature.argTypes[i], args[i]);
            }
            Object ret = interop.execute(receiver.executable, preparedArgs);
            return convertRet.executeInlined(node, signature.retType, ret);
        }
    }
}

