/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropAccessor;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.source.SourceSection;

final class LegacyTruffleExceptionSupport {
    private LegacyTruffleExceptionSupport() {
    }

    static boolean isTruffleException(Object receiver) {
        return receiver instanceof TruffleException;
    }

    private static TruffleException asTruffleException(Object receiver) {
        return (TruffleException)receiver;
    }

    static boolean isException(Object receiver) {
        if (!(receiver instanceof Throwable) || receiver instanceof ThreadDeath) {
            return false;
        }
        return LegacyTruffleExceptionSupport.isTruffleException(receiver) && !LegacyTruffleExceptionSupport.asTruffleException(receiver).isInternalError();
    }

    static RuntimeException throwException(Object receiver) {
        throw LegacyTruffleExceptionSupport.sthrow(RuntimeException.class, (Throwable)receiver);
    }

    @CompilerDirectives.TruffleBoundary
    static ExceptionType getExceptionType(Object receiver) {
        TruffleException truffleException = LegacyTruffleExceptionSupport.asTruffleException(receiver);
        if (truffleException.isExit()) {
            return ExceptionType.EXIT;
        }
        if (truffleException.isSyntaxError()) {
            return ExceptionType.PARSE_ERROR;
        }
        return ExceptionType.RUNTIME_ERROR;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isExceptionIncompleteSource(Object receiver) {
        return LegacyTruffleExceptionSupport.asTruffleException(receiver).isIncompleteSource();
    }

    @CompilerDirectives.TruffleBoundary
    static int getExceptionExitStatus(Object receiver) throws UnsupportedMessageException {
        TruffleException truffleException = LegacyTruffleExceptionSupport.asTruffleException(receiver);
        if (truffleException.isExit()) {
            return truffleException.getExitStatus();
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    static boolean hasSourceLocation(Object receiver) {
        return LegacyTruffleExceptionSupport.asTruffleException(receiver).getSourceLocation() != null;
    }

    @CompilerDirectives.TruffleBoundary
    static SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
        SourceSection sourceLocation = LegacyTruffleExceptionSupport.asTruffleException(receiver).getSourceLocation();
        if (sourceLocation == null) {
            throw UnsupportedMessageException.create();
        }
        return sourceLocation;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean hasExceptionCause(Object receiver) {
        Throwable cause = ((Throwable)receiver).getCause();
        return LegacyTruffleExceptionSupport.isTruffleException(cause);
    }

    @CompilerDirectives.TruffleBoundary
    static Object getExceptionCause(Object receiver) throws UnsupportedMessageException {
        if (!LegacyTruffleExceptionSupport.hasExceptionCause(receiver)) {
            throw UnsupportedMessageException.create();
        }
        return ((Throwable)receiver).getCause();
    }

    @CompilerDirectives.TruffleBoundary
    static boolean hasExceptionMessage(Object receiver) {
        return ((Throwable)receiver).getMessage() != null;
    }

    @CompilerDirectives.TruffleBoundary
    static Object getExceptionMessage(Object receiver) throws UnsupportedMessageException {
        String message = ((Throwable)receiver).getMessage();
        if (message == null) {
            throw UnsupportedMessageException.create();
        }
        return message;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean hasExceptionStackTrace(Object receiver) {
        return TruffleStackTrace.fillIn((Throwable)receiver) != null;
    }

    @CompilerDirectives.TruffleBoundary
    static Object getExceptionStackTrace(Object receiver) {
        return InteropAccessor.EXCEPTION.getExceptionStackTrace(receiver);
    }

    private static <T extends Throwable> T sthrow(Class<T> type, Throwable t) throws T {
        throw t;
    }
}

