/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.PolyglotImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.FileSystem;

class PolyglotSourceDispatch
extends AbstractPolyglotImpl.AbstractSourceDispatch {
    private volatile Object defaultFileSystemContext;

    protected PolyglotSourceDispatch(AbstractPolyglotImpl engineImpl) {
        super(engineImpl);
    }

    public String getName(Object impl) {
        Source source = (Source)impl;
        return source.getName();
    }

    public String getPath(Object impl) {
        Source source = (Source)impl;
        return source.getPath();
    }

    public boolean isInteractive(Object impl) {
        Source source = (Source)impl;
        return source.isInteractive();
    }

    public boolean isInternal(Object impl) {
        Source source = (Source)impl;
        return source.isInternal();
    }

    public URL getURL(Object impl) {
        Source source = (Source)impl;
        return source.getURL();
    }

    public URI getURI(Object impl) {
        Source source = (Source)impl;
        return source.getURI();
    }

    public Reader getReader(Object impl) {
        Source source = (Source)impl;
        return source.getReader();
    }

    public InputStream getInputStream(Object impl) {
        return new ByteArrayInputStream(this.getCharacters(impl).toString().getBytes());
    }

    public int getLength(Object impl) {
        Source source = (Source)impl;
        return source.getLength();
    }

    public CharSequence getCharacters(Object impl) {
        Source source = (Source)impl;
        return source.getCharacters();
    }

    public CharSequence getCharacters(Object impl, int lineNumber) {
        Source source = (Source)impl;
        return source.getCharacters(lineNumber);
    }

    public int getLineCount(Object impl) {
        Source source = (Source)impl;
        return source.getLineCount();
    }

    public int getLineNumber(Object impl, int offset) {
        Source source = (Source)impl;
        return source.getLineNumber(offset);
    }

    public int getColumnNumber(Object impl, int offset) {
        Source source = (Source)impl;
        return source.getColumnNumber(offset);
    }

    public int getLineStartOffset(Object impl, int lineNumber) {
        Source source = (Source)impl;
        return source.getLineStartOffset(lineNumber);
    }

    public int getLineLength(Object impl, int lineNumber) {
        Source source = (Source)impl;
        return source.getLineLength(lineNumber);
    }

    public String toString(Object impl) {
        Source source = (Source)impl;
        return source.toString();
    }

    public String getMimeType(Object impl) {
        Source source = (Source)impl;
        return source.getMimeType();
    }

    public String getLanguage(Object impl) {
        Source source = (Source)impl;
        return source.getLanguage();
    }

    public String findLanguage(File file) throws IOException {
        Objects.requireNonNull(file);
        String mimeType = this.findMimeType(file);
        if (mimeType != null) {
            return this.findLanguage(mimeType);
        }
        return null;
    }

    public String findLanguage(URL url) throws IOException {
        String mimeType = this.findMimeType(url);
        if (mimeType != null) {
            return this.findLanguage(mimeType);
        }
        return null;
    }

    public String findMimeType(File file) throws IOException {
        Objects.requireNonNull(file);
        TruffleFile truffleFile = EngineAccessor.LANGUAGE.getTruffleFile(file.toPath().toString(), this.getDefaultFileSystemContext());
        return truffleFile.detectMimeType();
    }

    public String findMimeType(URL url) throws IOException {
        Objects.requireNonNull(url);
        return EngineAccessor.SOURCE.findMimeType(url, this.getDefaultFileSystemContext());
    }

    public String findLanguage(String mimeType) {
        Objects.requireNonNull(mimeType);
        LanguageCache cache = LanguageCache.languageMimes().get(mimeType);
        if (cache != null) {
            return cache.getId();
        }
        return null;
    }

    public int hashCode(Object impl) {
        return impl.hashCode();
    }

    public boolean equals(Object impl, Object otherImpl) {
        return impl.equals(otherImpl);
    }

    public ByteSequence getBytes(Object impl) {
        Source source = (Source)impl;
        return source.getBytes();
    }

    public boolean hasBytes(Object impl) {
        Source source = (Source)impl;
        return source.hasBytes();
    }

    public boolean hasCharacters(Object impl) {
        Source source = (Source)impl;
        return source.hasCharacters();
    }

    public org.graalvm.polyglot.Source build(String language, Object origin, URI uri, String name, String mimeType, Object content, boolean interactive, boolean internal, boolean cached, Charset encoding) throws IOException {
        Source.SourceBuilder builder;
        assert (language != null);
        if (origin instanceof File) {
            builder = EngineAccessor.SOURCE.newBuilder(language, (File)origin);
        } else if (origin instanceof CharSequence) {
            builder = Source.newBuilder(language, (CharSequence)origin, name);
        } else if (origin instanceof ByteSequence) {
            builder = Source.newBuilder(language, (ByteSequence)origin, name);
        } else if (origin instanceof Reader) {
            builder = Source.newBuilder(language, (Reader)origin, name);
        } else if (origin instanceof URL) {
            builder = Source.newBuilder(language, (URL)origin);
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (origin instanceof File || origin instanceof URL) {
            EngineAccessor.SOURCE.setFileSystemContext(builder, this.getDefaultFileSystemContext());
        }
        if (content instanceof CharSequence) {
            builder.content((CharSequence)content);
        } else if (content instanceof ByteSequence) {
            builder.content((ByteSequence)content);
        }
        builder.uri(uri);
        builder.name(name);
        builder.internal(internal);
        builder.interactive(interactive);
        builder.mimeType(mimeType);
        builder.cached(cached);
        builder.encoding(encoding);
        try {
            return PolyglotImpl.getOrCreatePolyglotSource(this.engineImpl, builder.build());
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDefaultFileSystemContext() {
        Object res = this.defaultFileSystemContext;
        if (res == null) {
            PolyglotSourceDispatch polyglotSourceDispatch = this;
            synchronized (polyglotSourceDispatch) {
                res = this.defaultFileSystemContext;
                if (res == null) {
                    EmbedderFileSystemContext context = new EmbedderFileSystemContext();
                    this.defaultFileSystemContext = res = EngineAccessor.LANGUAGE.createFileSystemContext(context, context.fileSystem);
                }
            }
        }
        return res;
    }

    static final class EmbedderFileSystemContext {
        final FileSystem fileSystem = FileSystems.newDefaultFileSystem();
        final Map<String, LanguageCache> cachedLanguages = LanguageCache.languages();
        final Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> fileTypeDetectors = FileSystems.newFileTypeDetectorsSupplier(this.cachedLanguages.values());

        EmbedderFileSystemContext() {
        }
    }
}

