/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.RegexValidator;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyCaseFolding;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyRegexParser;
import java.util.Arrays;
import java.util.function.BiPredicate;

public final class RubyFlavor
extends RegexFlavor {
    public static final RubyFlavor INSTANCE = new RubyFlavor();

    private RubyFlavor() {
        super(143);
    }

    @Override
    public RegexValidator createValidator(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return RubyRegexParser.createValidator(source);
    }

    @Override
    public RegexParser createParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return RubyRegexParser.createParser(language, source, compilationBuffer);
    }

    @Override
    public BiPredicate<Integer, Integer> getEqualsIgnoreCasePredicate(RegexAST ast) {
        return RubyFlavor::equalsIgnoreCase;
    }

    private static boolean equalsIgnoreCase(int codePointA, int codePointB) {
        int[] foldedA = RubyCaseFolding.caseFold(codePointA);
        int[] foldedB = RubyCaseFolding.caseFold(codePointB);
        if (foldedA == null && foldedB == null) {
            return codePointA == codePointB;
        }
        if (foldedA == null) {
            return foldedB.length == 1 && codePointA == foldedB[0];
        }
        if (foldedB == null) {
            return foldedA.length == 1 && foldedA[0] == codePointB;
        }
        return Arrays.equals(foldedA, foldedB);
    }
}

