/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBFlags;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBRegexLexer;

public final class OracleDBRegexParser
implements RegexParser {
    private final RegexSource source;
    private final OracleDBFlags flags;
    private final OracleDBRegexLexer lexer;
    private final RegexASTBuilder astBuilder;

    @CompilerDirectives.TruffleBoundary
    public OracleDBRegexParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        this(language, source, compilationBuffer, source);
    }

    public OracleDBRegexParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer, RegexSource originalSource) throws RegexSyntaxException {
        this.source = source;
        this.flags = OracleDBFlags.parseFlags(source);
        this.lexer = new OracleDBRegexLexer(source, this.flags, compilationBuffer);
        this.astBuilder = new RegexASTBuilder(language, originalSource, RegexFlags.builder().dotAll(this.flags.isDotAll()).ignoreCase(this.flags.isIgnoreCase()).multiline(this.flags.isMultiline()).build(), false, compilationBuffer);
    }

    @Override
    public OracleDBFlags getFlags() {
        return this.flags;
    }

    @Override
    public AbstractRegexObject getNamedCaptureGroups() {
        return AbstractRegexObject.createNamedCaptureGroupMapInt(this.lexer.getNamedCaptureGroups());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public RegexAST parse() throws RegexSyntaxException {
        this.astBuilder.pushRootGroup();
        Token token = null;
        block11: while (this.lexer.hasNext()) {
            Token.Kind prevKind = token == null ? null : token.kind;
            token = this.lexer.next();
            switch (token.kind) {
                case A: 
                case z: {
                    this.astBuilder.addPositionAssertion(token);
                    continue block11;
                }
                case caret: {
                    if (prevKind == Token.Kind.caret) continue block11;
                    if (this.flags.isMultiline()) {
                        this.astBuilder.pushGroup();
                        this.astBuilder.addCaret();
                        this.astBuilder.nextSequence();
                        this.astBuilder.pushLookBehindAssertion(false);
                        this.astBuilder.addCharClass(CodePointSet.create(10));
                        this.astBuilder.popGroup();
                        this.astBuilder.popGroup();
                        continue block11;
                    }
                    this.astBuilder.addPositionAssertion(token);
                    continue block11;
                }
                case dollar: 
                case Z: {
                    if (prevKind == Token.Kind.dollar) continue block11;
                    this.astBuilder.pushGroup();
                    this.astBuilder.addDollar();
                    this.astBuilder.nextSequence();
                    this.astBuilder.pushLookAheadAssertion(false);
                    this.astBuilder.addCharClass(CodePointSet.create(10));
                    if (token.kind == Token.Kind.Z || !this.flags.isMultiline()) {
                        this.astBuilder.addDollar();
                    }
                    this.astBuilder.popGroup();
                    this.astBuilder.popGroup();
                    continue block11;
                }
                case backReference: {
                    this.astBuilder.addBackReference((Token.BackReference)token, this.flags.isIgnoreCase());
                    continue block11;
                }
                case quantifier: {
                    if (this.astBuilder.getCurTerm() == null || prevKind == Token.Kind.captureGroupBegin) continue block11;
                    this.astBuilder.addQuantifier((Token.Quantifier)token);
                    continue block11;
                }
                case alternation: {
                    this.astBuilder.nextSequence();
                    continue block11;
                }
                case captureGroupBegin: {
                    this.astBuilder.pushCaptureGroup(token);
                    continue block11;
                }
                case groupEnd: {
                    if (this.astBuilder.getCurGroup().getParent() instanceof RegexASTRootNode) {
                        throw this.syntaxError("unmatched parentheses in regular expression");
                    }
                    this.astBuilder.popGroup(token);
                    continue block11;
                }
                case charClass: {
                    this.astBuilder.addCharClass((Token.CharacterClass)token);
                    continue block11;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (!this.astBuilder.curGroupIsRoot()) {
            throw this.syntaxError("unmatched parentheses in regular expression");
        }
        return this.astBuilder.popRootGroup();
    }

    private RegexSyntaxException syntaxError(String msg) {
        return RegexSyntaxException.createPattern(this.source, msg, this.lexer.getLastTokenPosition());
    }
}

