/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldTable;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBFlags;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.util.JavaStringUtil;
import com.oracle.truffle.regex.util.TBitSet;
import org.graalvm.collections.EconomicMap;

public final class OracleDBRegexLexer
extends RegexLexer {
    private static final EconomicMap<String, CodePointSet> UNICODE_POSIX_CHAR_CLASSES;
    private static final CodePointSet EMPTY_POSIX_CHAR_CLASS;
    private static final TBitSet WHITESPACE;
    private final OracleDBFlags flags;
    private final CodePointSetAccumulator caseFoldTmp = new CodePointSetAccumulator();

    public OracleDBRegexLexer(RegexSource source, OracleDBFlags flags, CompilationBuffer compilationBuffer) {
        super(source, compilationBuffer);
        this.flags = flags;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = super.hasNext();
        if (this.position == this.pattern.length() - 1 && this.pattern.charAt(this.pattern.length() - 1) == '\\') {
            return false;
        }
        return hasNext;
    }

    @Override
    protected boolean featureEnabledIgnoreCase() {
        return this.flags.isIgnoreCase();
    }

    @Override
    protected boolean featureEnabledAZPositionAssertions() {
        return true;
    }

    @Override
    protected boolean featureEnabledZLowerCaseAssertion() {
        return true;
    }

    @Override
    protected boolean featureEnabledWordBoundaries() {
        return false;
    }

    @Override
    protected boolean featureEnabledBoundedQuantifierEmptyMin() {
        return false;
    }

    @Override
    protected boolean featureEnabledCharClassFirstBracketIsLiteral() {
        return true;
    }

    @Override
    protected boolean featureEnabledNestedCharClasses() {
        return true;
    }

    @Override
    protected boolean featureEnabledPOSIXCharClasses() {
        return true;
    }

    @Override
    protected CodePointSet getPOSIXCharClass(String name) {
        if (name.isEmpty()) {
            return EMPTY_POSIX_CHAR_CLASS;
        }
        CodePointSet cps = (CodePointSet)UNICODE_POSIX_CHAR_CLASSES.get((Object)name);
        if (cps != null) {
            return cps;
        }
        throw this.syntaxError("invalid character class in regular expression");
    }

    @Override
    protected void validatePOSIXCollationElement(String sequence) {
        assert (!JavaStringUtil.isSingleCodePoint(sequence));
        throw this.syntaxError("invalid collation class in regular expression");
    }

    @Override
    protected void validatePOSIXEquivalenceClass(String sequence) {
        assert (!JavaStringUtil.isSingleCodePoint(sequence));
        throw this.syntaxError("invalid equivalence class in regular expression");
    }

    @Override
    protected boolean featureEnabledForwardReferences() {
        return false;
    }

    @Override
    protected boolean featureEnabledGroupComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledLineComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledIgnoreWhiteSpace() {
        return this.flags.isIgnoreWhitespace();
    }

    @Override
    protected TBitSet getWhitespace() {
        return WHITESPACE;
    }

    @Override
    protected boolean featureEnabledOctalEscapes() {
        return false;
    }

    @Override
    protected boolean featureEnabledSpecialGroups() {
        return false;
    }

    @Override
    protected boolean featureEnabledUnicodePropertyEscapes() {
        return false;
    }

    @Override
    protected boolean featureEnabledClassSetExpressions() {
        return false;
    }

    @Override
    protected void caseFoldUnfold(CodePointSetAccumulator charClass) {
        CaseFoldTable.applyCaseFoldUnfold(charClass, this.caseFoldTmp, CaseFoldTable.CaseFoldingAlgorithm.ECMAScriptUnicode);
    }

    @Override
    protected ClassSetContents caseFoldClassSetAtom(ClassSetContents classSetContents) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected CodePointSet complementClassSet(CodePointSet codePointSet) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected CodePointSet getDotCodePointSet() {
        return this.flags.isDotAll() ? Constants.DOT_ALL : Constants.NO_NEWLINE;
    }

    @Override
    protected CodePointSet getIdContinue() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected CodePointSet getIdStart() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected int getMaxBackReferenceDigits() {
        return 1;
    }

    @Override
    protected CodePointSet getPredefinedCharClass(char c) {
        assert (UNICODE_POSIX_CHAR_CLASSES.containsKey((Object)OracleDBRegexLexer.getPOSIXCharClassName(c)));
        CodePointSet cps = (CodePointSet)UNICODE_POSIX_CHAR_CLASSES.get((Object)OracleDBRegexLexer.getPOSIXCharClassName(c));
        if (OracleDBRegexLexer.isLowerCase(c)) {
            return cps;
        }
        return cps.createInverse(Encodings.UTF_32);
    }

    private static int toLowerCase(char c) {
        return c | 0x20;
    }

    private static boolean isLowerCase(char c) {
        return (c & 0x20) != 0;
    }

    private static String getPOSIXCharClassName(char c) {
        switch (OracleDBRegexLexer.toLowerCase(c)) {
            case 115: {
                return "space";
            }
            case 100: {
                return "digit";
            }
            case 119: {
                return "alnum";
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected long boundedQuantifierMaxValue() {
        return 0xFFFFFFFFL;
    }

    @Override
    protected RegexSyntaxException handleBoundedQuantifierOutOfOrder() {
        return this.syntaxError("invalid interval value in regular expression");
    }

    @Override
    protected Token handleBoundedQuantifierSyntaxError() throws RegexSyntaxException {
        this.position = this.getLastTokenPosition() + 1;
        return this.charClass(123);
    }

    @Override
    protected Token handleBoundedQuantifierOverflow(long min, long max) {
        if (min == -1L || max == -1L) {
            this.position = this.getLastTokenPosition() + 1;
            return this.charClass(123);
        }
        if (Long.compareUnsigned(min, max) > 0) {
            throw this.handleBoundedQuantifierOutOfOrder();
        }
        return new Token.Quantifier((int)(min & Integer.MAX_VALUE), (int)(max & Integer.MAX_VALUE), !this.consumingLookahead("?"));
    }

    @Override
    protected Token handleBoundedQuantifierOverflowMin(long min, long max) {
        if (min == -1L) {
            this.position = this.getLastTokenPosition() + 1;
            return this.charClass(123);
        }
        return new Token.Quantifier((int)(min & Integer.MAX_VALUE), (int)(max & Integer.MAX_VALUE), !this.consumingLookahead("?"));
    }

    @Override
    protected RegexSyntaxException handleCCRangeOutOfOrder(int startPos) {
        return this.syntaxError("invalid range in regular expression");
    }

    @Override
    protected void handleCCRangeWithPredefCharClass(int startPos, ClassSetContents firstAtom, ClassSetContents secondAtom) {
        if (firstAtom.isAllowedInRange()) {
            throw this.syntaxError("invalid range in regular expression");
        }
    }

    @Override
    protected RegexSyntaxException handleComplementOfStringSet() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleEmptyGroupName() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleGroupRedefinition(String name, int newId, int oldId) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleIncompleteEscapeX() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleInvalidBackReference(int reference) {
        throw this.syntaxError("invalid back reference in regular expression");
    }

    @Override
    protected void handleInvalidBackReference(String reference) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleInvalidCharInCharClass() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleInvalidGroupBeginQ() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleMixedClassSetOperators(RegexLexer.ClassSetOperator leftOperator, RegexLexer.ClassSetOperator rightOperator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleMissingClassSetOperand(RegexLexer.ClassSetOperator operator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleOctalOutOfRange() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleRangeAsClassSetOperand(RegexLexer.ClassSetOperator operator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnfinishedEscape() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnfinishedGroupComment() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleUnfinishedGroupQ() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleUnfinishedRangeInClassSet() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnmatchedRightBrace() {
    }

    @Override
    protected RegexSyntaxException handleUnmatchedLeftBracket() {
        return this.syntaxError("unmatched bracket in regular expression");
    }

    @Override
    protected void handleUnmatchedRightBracket() {
    }

    @Override
    protected void checkClassSetCharacter(int codePoint) throws RegexSyntaxException {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected int parseCodePointInGroupName() throws RegexSyntaxException {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token parseCustomEscape(char c) {
        return null;
    }

    @Override
    protected int parseCustomEscapeChar(char c, boolean inCharClass) {
        if (inCharClass) {
            --this.position;
            return 92;
        }
        return c;
    }

    @Override
    protected int parseCustomEscapeCharFallback(int c, boolean inCharClass) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token parseCustomGroupBeginQ(char charAfterQuestionMark) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token parseGroupLt() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    static {
        EMPTY_POSIX_CHAR_CLASS = CodePointSet.create(58, 58, 91, 91, 93, 93);
        CodePointSet alpha = UnicodeProperties.getProperty("Alphabetic");
        CodePointSet digit = UnicodeProperties.getProperty("General_Category=Decimal_Number");
        CodePointSet space = UnicodeProperties.getProperty("White_Space");
        CodePointSet xdigit = CodePointSet.create(48, 57, 65, 70, 97, 102);
        UNICODE_POSIX_CHAR_CLASSES = EconomicMap.create((int)12);
        CompilationBuffer buffer = new CompilationBuffer(Encodings.UTF_32);
        CodePointSet blank = UnicodeProperties.getProperty("General_Category=Space_Separator").union(CodePointSet.create(9, 9));
        CodePointSet cntrl = UnicodeProperties.getProperty("General_Category=Control");
        CodePointSet graph = space.union(UnicodeProperties.getProperty("General_Category=Control")).union(UnicodeProperties.getProperty("General_Category=Surrogate")).union(UnicodeProperties.getProperty("General_Category=Unassigned")).createInverse(Encodings.UTF_32);
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"alpha", (Object)alpha);
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"alnum", (Object)alpha.union(digit));
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"blank", (Object)blank);
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"cntrl", (Object)cntrl);
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"digit", (Object)digit);
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"graph", (Object)graph);
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"lower", (Object)UnicodeProperties.getProperty("Lowercase"));
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"print", (Object)graph.union(blank).subtract(cntrl, buffer));
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"punct", (Object)UnicodeProperties.getProperty("General_Category=Punctuation").union(UnicodeProperties.getProperty("General_Category=Symbol").subtract(alpha, buffer)));
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"space", (Object)space);
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"upper", (Object)UnicodeProperties.getProperty("Uppercase"));
        UNICODE_POSIX_CHAR_CLASSES.put((Object)"xdigit", (Object)xdigit);
        WHITESPACE = TBitSet.valueOf(10, 32);
    }
}

