/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.ClassSetContentsAccumulator;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.util.JavaStringUtil;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicSet;

public abstract class RegexLexer {
    private static final TBitSet PREDEFINED_CHAR_CLASSES = TBitSet.valueOf(68, 83, 87, 100, 115, 119);
    protected static final TBitSet DEFAULT_WHITESPACE = TBitSet.valueOf(9, 10, 11, 12, 13, 32);
    public final RegexSource source;
    protected final String pattern;
    private final Encodings.Encoding encoding;
    private final CodePointSetAccumulator curCharClass = new CodePointSetAccumulator();
    protected int position = 0;
    protected Map<String, List<Integer>> namedCaptureGroups = null;
    private int curStartIndex = 0;
    private int charClassCurAtomStartIndex = 0;
    private int nGroups = 1;
    private boolean identifiedAllGroups = false;
    protected final CompilationBuffer compilationBuffer;

    public RegexLexer(RegexSource source, CompilationBuffer compilationBuffer) {
        this.source = source;
        this.pattern = source.getPattern();
        this.encoding = source.getEncoding();
        this.compilationBuffer = compilationBuffer;
    }

    protected abstract boolean featureEnabledIgnoreCase();

    protected abstract boolean featureEnabledAZPositionAssertions();

    protected abstract boolean featureEnabledZLowerCaseAssertion();

    protected abstract boolean featureEnabledWordBoundaries();

    protected abstract boolean featureEnabledBoundedQuantifierEmptyMin();

    protected abstract boolean featureEnabledCharClassFirstBracketIsLiteral();

    protected abstract boolean featureEnabledNestedCharClasses();

    protected abstract boolean featureEnabledPOSIXCharClasses();

    protected abstract CodePointSet getPOSIXCharClass(String var1);

    protected abstract void validatePOSIXCollationElement(String var1);

    protected abstract void validatePOSIXEquivalenceClass(String var1);

    protected abstract boolean featureEnabledForwardReferences();

    protected abstract boolean featureEnabledGroupComments();

    protected abstract boolean featureEnabledLineComments();

    protected abstract boolean featureEnabledIgnoreWhiteSpace();

    protected abstract TBitSet getWhitespace();

    protected abstract boolean featureEnabledOctalEscapes();

    protected abstract boolean featureEnabledSpecialGroups();

    protected abstract boolean featureEnabledUnicodePropertyEscapes();

    protected abstract boolean featureEnabledClassSetExpressions();

    protected abstract void caseFoldUnfold(CodePointSetAccumulator var1);

    protected abstract ClassSetContents caseFoldClassSetAtom(ClassSetContents var1);

    protected abstract CodePointSet complementClassSet(CodePointSet var1);

    protected abstract CodePointSet getDotCodePointSet();

    protected abstract CodePointSet getIdStart();

    protected abstract CodePointSet getIdContinue();

    protected abstract int getMaxBackReferenceDigits();

    protected abstract CodePointSet getPredefinedCharClass(char var1);

    protected abstract long boundedQuantifierMaxValue();

    protected abstract RegexSyntaxException handleBoundedQuantifierOutOfOrder();

    protected abstract Token handleBoundedQuantifierSyntaxError();

    protected abstract Token handleBoundedQuantifierOverflow(long var1, long var3);

    protected abstract Token handleBoundedQuantifierOverflowMin(long var1, long var3);

    protected abstract RegexSyntaxException handleCCRangeOutOfOrder(int var1);

    protected abstract void handleCCRangeWithPredefCharClass(int var1, ClassSetContents var2, ClassSetContents var3);

    protected abstract RegexSyntaxException handleComplementOfStringSet();

    protected abstract RegexSyntaxException handleEmptyGroupName();

    protected abstract void handleGroupRedefinition(String var1, int var2, int var3);

    protected abstract void handleIncompleteEscapeX();

    protected abstract void handleInvalidBackReference(int var1);

    protected abstract void handleInvalidBackReference(String var1);

    protected abstract RegexSyntaxException handleInvalidCharInCharClass();

    protected abstract RegexSyntaxException handleInvalidGroupBeginQ();

    protected abstract RegexSyntaxException handleMixedClassSetOperators(ClassSetOperator var1, ClassSetOperator var2);

    protected abstract RegexSyntaxException handleMissingClassSetOperand(ClassSetOperator var1);

    protected abstract void handleOctalOutOfRange();

    protected abstract RegexSyntaxException handleRangeAsClassSetOperand(ClassSetOperator var1);

    protected abstract void handleUnfinishedEscape();

    protected abstract void handleUnfinishedGroupComment();

    protected abstract RegexSyntaxException handleUnfinishedGroupQ();

    protected abstract RegexSyntaxException handleUnfinishedRangeInClassSet();

    protected abstract void handleUnmatchedRightBrace();

    protected abstract RegexSyntaxException handleUnmatchedLeftBracket();

    protected abstract void handleUnmatchedRightBracket();

    protected abstract void checkClassSetCharacter(int var1) throws RegexSyntaxException;

    protected abstract int parseCodePointInGroupName() throws RegexSyntaxException;

    protected abstract Token parseCustomEscape(char var1);

    protected abstract int parseCustomEscapeChar(char var1, boolean var2);

    protected abstract int parseCustomEscapeCharFallback(int var1, boolean var2);

    protected abstract Token parseCustomGroupBeginQ(char var1);

    protected abstract Token parseGroupLt();

    protected boolean findChars(char ... chars) {
        if (this.atEnd()) {
            return false;
        }
        int i = ArrayUtils.indexOf((String)this.pattern, (int)this.position, (int)this.pattern.length(), (char[])chars);
        if (i < 0) {
            this.position = this.pattern.length();
            return false;
        }
        this.position = i;
        return true;
    }

    protected void advance() {
        this.advance(1);
    }

    protected void retreat() {
        this.advance(-1);
    }

    public boolean hasNext() {
        if (this.featureEnabledLineComments()) {
            int p;
            do {
                p = this.position;
                this.skipWhitespace();
                if (this.consumingLookahead("#")) {
                    this.skipComment('\n');
                    continue;
                }
                if (!this.featureEnabledGroupComments() || !this.consumingLookahead("(?#") || this.skipComment(')')) continue;
                this.handleUnfinishedGroupComment();
            } while (p != this.position);
        } else if (this.featureEnabledIgnoreWhiteSpace()) {
            this.skipWhitespace();
        }
        if (this.featureEnabledGroupComments()) {
            while (this.consumingLookahead("(?#")) {
                if (this.skipComment(')')) continue;
                this.handleUnfinishedGroupComment();
            }
        }
        return !this.atEnd();
    }

    private boolean skipComment(char terminator) {
        while (this.findChars('\\', terminator)) {
            if (this.consumeChar() == '\\' && !this.atEnd()) {
                this.advance();
                continue;
            }
            return true;
        }
        return false;
    }

    private void skipWhitespace() {
        while (!this.atEnd()) {
            char curChar = this.curChar();
            if (!this.getWhitespace().get(curChar)) break;
            this.advance();
        }
    }

    public Token next() throws RegexSyntaxException {
        this.curStartIndex = this.position;
        Token t = this.getNext();
        t.setPosition(this.curStartIndex);
        this.setSourceSection(t, this.curStartIndex, this.position);
        return t;
    }

    public int getLastTokenPosition() {
        return this.curStartIndex;
    }

    protected int getLastAtomPosition() {
        return Math.max(this.curStartIndex, this.charClassCurAtomStartIndex);
    }

    protected char curChar() {
        return this.pattern.charAt(this.position);
    }

    protected char consumeChar() {
        char c = this.pattern.charAt(this.position);
        this.advance();
        return c;
    }

    protected void advance(int len) {
        this.position += len;
    }

    protected boolean lookahead(String match) {
        if (this.pattern.length() - this.position < match.length()) {
            return false;
        }
        return this.pattern.regionMatches(this.position, match, 0, match.length());
    }

    protected boolean lookahead(Predicate<Character> predicate, int length) {
        if (this.pattern.length() - this.position < length) {
            return false;
        }
        for (int i = this.position; i < this.position + length; ++i) {
            if (predicate.test(Character.valueOf(this.pattern.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private boolean consumingLookahead(char character) {
        if (this.atEnd()) {
            return false;
        }
        if (this.curChar() == character) {
            this.advance();
            return true;
        }
        return false;
    }

    protected boolean consumingLookahead(String match) {
        boolean matches = this.lookahead(match);
        if (matches) {
            this.position += match.length();
        }
        return matches;
    }

    protected boolean consumingLookahead(Predicate<Character> predicate, int length) {
        boolean matches = this.lookahead(predicate, length);
        if (matches) {
            this.position += length;
        }
        return matches;
    }

    protected boolean lookbehind(char c) {
        if (this.position < 1) {
            return false;
        }
        return this.pattern.charAt(this.position - 1) == c;
    }

    protected boolean isEscaped() {
        int backslashPosition;
        for (backslashPosition = this.position - 1; backslashPosition >= 0 && this.pattern.charAt(backslashPosition) == '\\'; --backslashPosition) {
        }
        return (this.position - backslashPosition) % 2 == 0;
    }

    protected int count(Predicate<Character> predicate) {
        return this.count(predicate, this.position, this.pattern.length());
    }

    protected int countUpTo(Predicate<Character> predicate, int max) {
        return this.count(predicate, this.position, (int)Math.min((long)this.position + (long)max, (long)this.pattern.length()));
    }

    protected int countFrom(Predicate<Character> predicate, int fromIndex) {
        return this.count(predicate, fromIndex, this.pattern.length());
    }

    protected int count(Predicate<Character> predicate, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (predicate.test(Character.valueOf(this.pattern.charAt(i)))) continue;
            return i - fromIndex;
        }
        return toIndex - fromIndex;
    }

    protected boolean atEnd() {
        return this.position >= this.pattern.length();
    }

    private void setSourceSection(Token t, int startIndex, int endIndex) {
        if (this.source.getOptions().isDumpAutomataWithSourceSections()) {
            t.setSourceSection(this.source.getSource().createSection(startIndex + 1, endIndex - startIndex));
        }
    }

    public int totalNumberOfCaptureGroups() throws RegexSyntaxException {
        if (!this.identifiedAllGroups) {
            this.identifyCaptureGroups();
            this.identifiedAllGroups = true;
        }
        return this.nGroups;
    }

    public int numberOfCaptureGroupsSoFar() {
        assert (!this.identifiedAllGroups);
        return this.nGroups;
    }

    public Map<String, List<Integer>> getNamedCaptureGroups() throws RegexSyntaxException {
        if (!this.identifiedAllGroups) {
            this.identifyCaptureGroups();
            this.identifiedAllGroups = true;
        }
        return this.namedCaptureGroups;
    }

    protected boolean hasNamedCaptureGroups() throws RegexSyntaxException {
        return this.getNamedCaptureGroups() != null;
    }

    private void registerCaptureGroup() {
        if (!this.identifiedAllGroups) {
            ++this.nGroups;
        }
    }

    protected void registerNamedCaptureGroup(String name) {
        if (!this.identifiedAllGroups) {
            List<Integer> groupsWithSameName;
            if (this.namedCaptureGroups == null) {
                this.namedCaptureGroups = new LinkedHashMap<String, List<Integer>>();
            }
            if ((groupsWithSameName = this.namedCaptureGroups.get(name)) != null) {
                this.handleGroupRedefinition(name, this.nGroups, groupsWithSameName.get(0));
                groupsWithSameName.add(this.nGroups);
            } else {
                groupsWithSameName = new ArrayList<Integer>();
                groupsWithSameName.add(this.nGroups);
                this.namedCaptureGroups.put(name, groupsWithSameName);
            }
        }
        this.registerCaptureGroup();
    }

    private void identifyCaptureGroups() throws RegexSyntaxException {
        boolean insideCharClass = false;
        int restoreIndex = this.position;
        block6: while (this.findChars('\\', '[', ']', '(')) {
            switch (this.consumeChar()) {
                case '\\': {
                    this.advance();
                    continue block6;
                }
                case '[': {
                    insideCharClass = true;
                    continue block6;
                }
                case ']': {
                    insideCharClass = false;
                    continue block6;
                }
                case '(': {
                    if (insideCharClass) continue block6;
                    this.parseGroupBegin();
                    continue block6;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        this.position = restoreIndex;
    }

    protected Token charClass(int codePoint) {
        if (this.featureEnabledIgnoreCase()) {
            this.curCharClass.clear();
            this.curCharClass.appendRange(codePoint, codePoint);
            return this.charClass(false);
        }
        return Token.createCharClass(CodePointSet.create(codePoint), true);
    }

    private Token charClass(CodePointSet codePointSet) {
        if (this.featureEnabledIgnoreCase()) {
            this.curCharClass.clear();
            this.curCharClass.addSet(codePointSet);
            return this.charClass(false);
        }
        return Token.createCharClass(codePointSet);
    }

    private Token charClass(boolean invert) {
        boolean wasSingleChar;
        boolean bl = wasSingleChar = !invert && this.curCharClass.matchesSingleChar();
        if (this.featureEnabledIgnoreCase()) {
            this.caseFoldUnfold(this.curCharClass);
        }
        CodePointSet cps = this.curCharClass.toCodePointSet();
        return Token.createCharClass(invert ? cps.createInverse(this.encoding) : cps, wasSingleChar);
    }

    private Token getNext() throws RegexSyntaxException {
        char c = this.consumeChar();
        switch (c) {
            case '.': {
                return Token.createCharClass(this.getDotCodePointSet());
            }
            case '^': {
                return Token.createCaret();
            }
            case '$': {
                return Token.createDollar();
            }
            case '*': 
            case '+': 
            case '?': 
            case '{': {
                return this.parseQuantifier(c);
            }
            case '}': {
                this.handleUnmatchedRightBrace();
                return this.charClass(c);
            }
            case '|': {
                return Token.createAlternation();
            }
            case '(': {
                return this.parseGroupBegin();
            }
            case ')': {
                return Token.createGroupEnd();
            }
            case '[': {
                return this.parseCharClass();
            }
            case ']': {
                this.handleUnmatchedRightBracket();
                return this.charClass(c);
            }
            case '\\': {
                return this.parseEscape();
            }
        }
        return this.charClass(this.toCodePoint(c));
    }

    private Token parseEscape() throws RegexSyntaxException {
        char c;
        Token custom;
        if (this.atEnd()) {
            this.handleUnfinishedEscape();
        }
        if ((custom = this.parseCustomEscape(c = this.consumeChar())) != null) {
            return custom;
        }
        if ('1' <= c && c <= '9') {
            int restoreIndex = this.position;
            int backRefNumber = this.parseIntSaturated(c - 48, this.countDecimalDigits(this.getMaxBackReferenceDigits() - 1), Integer.MAX_VALUE);
            if (backRefNumber < (this.featureEnabledForwardReferences() ? this.totalNumberOfCaptureGroups() : this.nGroups)) {
                return Token.createBackReference(backRefNumber, false);
            }
            this.handleInvalidBackReference(backRefNumber);
            this.position = restoreIndex;
        }
        if (this.featureEnabledAZPositionAssertions()) {
            if (c == 'A') {
                return Token.createA();
            }
            if (c == 'Z') {
                return Token.createZ();
            }
            if (this.featureEnabledZLowerCaseAssertion() && c == 'z') {
                return Token.createZLowerCase();
            }
        }
        if (this.featureEnabledWordBoundaries()) {
            if (c == 'b') {
                return Token.createWordBoundary();
            }
            if (c == 'B') {
                return Token.createNonWordBoundary();
            }
        }
        if (RegexLexer.isPredefCharClass(c)) {
            return Token.createCharClass(this.getPredefinedCharClass(c));
        }
        if (this.featureEnabledUnicodePropertyEscapes() && (c == 'p' || c == 'P')) {
            ClassSetContents unicodePropertyContents = this.parseUnicodeCharacterProperty(c == 'P');
            if (this.featureEnabledClassSetExpressions()) {
                return Token.createClassSetExpression(unicodePropertyContents);
            }
            assert (unicodePropertyContents.isCodePointSetOnly());
            return this.charClass(unicodePropertyContents.getCodePointSet());
        }
        return this.charClass(this.parseEscapeChar(c, false));
    }

    private Token parseGroupBegin() throws RegexSyntaxException {
        if (this.featureEnabledSpecialGroups() && this.consumingLookahead("?")) {
            if (this.atEnd()) {
                throw this.handleUnfinishedGroupQ();
            }
            char c = this.consumeChar();
            Token custom = this.parseCustomGroupBeginQ(c);
            if (custom != null) {
                return custom;
            }
            switch (c) {
                case '=': {
                    return Token.createLookAheadAssertionBegin(false);
                }
                case '!': {
                    return Token.createLookAheadAssertionBegin(true);
                }
                case ':': {
                    return Token.createNonCaptureGroupBegin();
                }
                case '<': {
                    if (this.consumingLookahead("=")) {
                        return Token.createLookBehindAssertionBegin(false);
                    }
                    if (this.consumingLookahead("!")) {
                        return Token.createLookBehindAssertionBegin(true);
                    }
                    return this.parseGroupLt();
                }
            }
            throw this.handleInvalidGroupBeginQ();
        }
        this.registerCaptureGroup();
        return Token.createCaptureGroupBegin();
    }

    protected ParseGroupNameResult parseGroupName(char terminator) throws RegexSyntaxException {
        StringBuilder sb = new StringBuilder();
        if (this.atEnd() || this.curChar() == terminator) {
            return new ParseGroupNameResult(ParseGroupNameResultState.empty, "");
        }
        int codePoint = this.parseCodePointInGroupName();
        boolean validFirstChar = this.getIdStart().contains(codePoint);
        boolean validRest = true;
        sb.appendCodePoint(codePoint);
        while (!this.atEnd() && this.curChar() != terminator) {
            codePoint = this.parseCodePointInGroupName();
            validRest &= this.getIdContinue().contains(codePoint);
            sb.appendCodePoint(codePoint);
        }
        String groupName = sb.toString();
        if (!this.consumingLookahead(terminator)) {
            return new ParseGroupNameResult(ParseGroupNameResultState.unterminated, groupName);
        }
        if (!validFirstChar) {
            return new ParseGroupNameResult(ParseGroupNameResultState.invalidStart, groupName);
        }
        if (!validRest) {
            return new ParseGroupNameResult(ParseGroupNameResultState.invalidRest, groupName);
        }
        return new ParseGroupNameResult(ParseGroupNameResultState.valid, groupName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Token parseQuantifier(char c) throws RegexSyntaxException {
        long max;
        long min;
        if (c == '{') {
            Token ret;
            if (this.lookahead("}")) {
                return this.handleBoundedQuantifierSyntaxError();
            }
            int resetIndex = this.position;
            int lengthMin = this.countDecimalDigits();
            if (lengthMin == 0) {
                if (!this.featureEnabledBoundedQuantifierEmptyMin()) return this.handleBoundedQuantifierSyntaxError();
                min = 0L;
            } else {
                min = this.parseIntSaturated(0, lengthMin, -1, this.boundedQuantifierMaxValue());
            }
            if (this.consumingLookahead(",}")) {
                Token ret2;
                max = -1L;
                if (min != -1L && min <= Integer.MAX_VALUE || (ret2 = this.handleBoundedQuantifierOverflowMin(min, max)) == null) return Token.createQuantifier((int)min, (int)max, !this.consumingLookahead("?"));
                return ret2;
            }
            if (this.consumingLookahead("}")) {
                Token ret3;
                max = min;
                if (min != -1L && min <= Integer.MAX_VALUE || (ret3 = this.handleBoundedQuantifierOverflowMin(min, max)) == null) return Token.createQuantifier((int)min, (int)max, !this.consumingLookahead("?"));
                return ret3;
            }
            if (!this.consumingLookahead(",")) {
                return this.handleBoundedQuantifierSyntaxError();
            }
            int lengthMax = this.countDecimalDigits();
            max = this.parseIntSaturated(0, lengthMax, -1, this.boundedQuantifierMaxValue());
            if (!this.consumingLookahead("}")) {
                return this.handleBoundedQuantifierSyntaxError();
            }
            if ((min == -1L || max == -1L || min > Integer.MAX_VALUE || max > Integer.MAX_VALUE) && (ret = this.handleBoundedQuantifierOverflow(min, max)) != null) {
                return ret;
            }
            if (!this.isQuantifierOutOfOrder(min, max, resetIndex, lengthMin, lengthMax)) return Token.createQuantifier((int)min, (int)max, !this.consumingLookahead("?"));
            throw this.handleBoundedQuantifierOutOfOrder();
        }
        min = c == '+' ? 1L : 0L;
        max = c == '?' ? 1L : -1L;
        return Token.createQuantifier((int)min, (int)max, !this.consumingLookahead("?"));
    }

    private boolean isQuantifierOutOfOrder(long parsedMin, long parsedMax, int startMin, int lengthMin, int lengthMax) {
        if (Long.compareUnsigned(parsedMin, parsedMax) > 0) {
            return true;
        }
        if (parsedMin == -1L && parsedMax == -1L) {
            int nZerosMax;
            int lengthMaxTrunc;
            int startMax = startMin + lengthMin + 1;
            int nZerosMin = this.countZeros(startMin);
            int lengthMinTrunc = lengthMin - nZerosMin;
            return lengthMinTrunc > (lengthMaxTrunc = lengthMax - (nZerosMax = this.countZeros(startMax))) || lengthMinTrunc == lengthMaxTrunc && this.pattern.substring(startMin + nZerosMin, startMin + lengthMin).compareTo(this.pattern.substring(startMax + nZerosMax, startMax + lengthMax)) > 0;
        }
        return false;
    }

    protected int parseIntSaturated(int firstDigit, int length, int returnOnOverflow) {
        return (int)this.parseIntSaturated(firstDigit, length, returnOnOverflow, Integer.MAX_VALUE);
    }

    protected long parseIntSaturated(int firstDigit, int length, int returnOnOverflow, long maxValue) {
        int fromIndex = this.position;
        this.position += length;
        long ret = firstDigit;
        for (int i = fromIndex; i < fromIndex + length; ++i) {
            int nextDigit = this.pattern.charAt(i) - 48;
            if (ret > maxValue / 10L) {
                return returnOnOverflow;
            }
            if ((ret *= 10L) > maxValue - (long)nextDigit) {
                return returnOnOverflow;
            }
            ret += (long)nextDigit;
        }
        return ret;
    }

    protected int countDecimalDigits() {
        return this.count(RegexLexer::isDecimalDigit);
    }

    private int countDecimalDigits(int maxLength) {
        return this.countUpTo(RegexLexer::isDecimalDigit, maxLength);
    }

    private int countZeros(int fromIndex) {
        return this.countFrom(c -> c.charValue() == '0', fromIndex);
    }

    private Token parseCharClass() throws RegexSyntaxException {
        if (this.featureEnabledClassSetExpressions()) {
            return Token.createClassSetExpression(this.parseClassSetExpression());
        }
        boolean invert = this.consumingLookahead("^");
        this.curCharClass.clear();
        int startPos = this.position;
        while (!this.atEnd()) {
            char c = this.consumeChar();
            if (!(c != ']' || this.featureEnabledCharClassFirstBracketIsLiteral() && this.position == startPos + 1)) {
                return this.charClass(invert);
            }
            this.parseCharClassRange(c);
        }
        throw this.handleUnmatchedLeftBracket();
    }

    private ClassSetContents parseCharClassAtomPredefCharClass(char c) throws RegexSyntaxException {
        if (c == '\\') {
            if (this.atEnd()) {
                this.handleUnfinishedEscape();
            }
            if (this.isEscapeCharClass(this.curChar())) {
                ClassSetContents contents = this.parseEscapeCharClass(this.consumeChar());
                assert (this.featureEnabledClassSetExpressions() || contents.isCodePointSetOnly());
                return contents;
            }
        } else if (this.featureEnabledNestedCharClasses() && c == '[') {
            if (this.atEnd()) {
                throw this.handleUnmatchedLeftBracket();
            }
            if (this.featureEnabledPOSIXCharClasses()) {
                return this.parsePOSIXCharClassElement();
            }
        }
        return null;
    }

    private ClassSetContents parsePOSIXCharClassElement() {
        int end;
        int resetIndex = this.position;
        char delim = this.consumeChar();
        if ((delim == ':' || delim == '.' || delim == '=') && (end = this.pattern.indexOf(RegexLexer.getPosixCharClassEndStr(delim), this.position)) >= 0) {
            String name = this.pattern.substring(this.position, end);
            this.position = end + 2;
            switch (delim) {
                case ':': {
                    return ClassSetContents.createCharacterClass(this.getPOSIXCharClass(name));
                }
                case '.': {
                    if (JavaStringUtil.isSingleCodePoint(name)) {
                        return ClassSetContents.createPOSIXCollationElement(name.codePointAt(0));
                    }
                    this.validatePOSIXCollationElement(name);
                    return ClassSetContents.createPOSIXCollationElement(name);
                }
                case '=': {
                    if (JavaStringUtil.isSingleCodePoint(name)) {
                        return ClassSetContents.createPOSIXCollationEquivalenceClass(name.codePointAt(0));
                    }
                    this.validatePOSIXCollationElement(name);
                    return ClassSetContents.createPOSIXCollationEquivalenceClass(name);
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        this.position = resetIndex;
        return ClassSetContents.createCharacter(91);
    }

    private static String getPosixCharClassEndStr(char delim) {
        switch (delim) {
            case ':': {
                return ":]";
            }
            case '.': {
                return ".]";
            }
            case '=': {
                return "=]";
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private int parseCharClassAtomCodePoint(char c) throws RegexSyntaxException {
        if (c == '\\') {
            assert (!this.atEnd());
            assert (!this.isEscapeCharClass(this.curChar()));
            return this.parseEscapeChar(this.consumeChar(), true);
        }
        int codePoint = this.toCodePoint(c);
        if (this.featureEnabledClassSetExpressions()) {
            this.checkClassSetCharacter(codePoint);
        }
        return codePoint;
    }

    private ClassSetContents parseCharClassAtom(char c) throws RegexSyntaxException {
        ClassSetContents cc = this.parseCharClassAtomPredefCharClass(c);
        if (cc != null) {
            return cc;
        }
        return ClassSetContents.createCharacter(this.parseCharClassAtomCodePoint(c));
    }

    private void parseCharClassRange(char c) throws RegexSyntaxException {
        int startPos = this.position - 1;
        this.charClassCurAtomStartIndex = this.position - 1;
        ClassSetContents firstAtom = this.parseCharClassAtom(c);
        if (this.consumingLookahead("-")) {
            if (this.atEnd() || this.lookahead("]")) {
                this.addCharClassAtom(firstAtom);
                this.curCharClass.addRange(45, 45);
            } else {
                char nextC = this.consumeChar();
                this.charClassCurAtomStartIndex = this.position - 1;
                ClassSetContents secondAtom = this.parseCharClassAtom(nextC);
                if (!firstAtom.isAllowedInRange() || !secondAtom.isAllowedInRange()) {
                    this.handleCCRangeWithPredefCharClass(startPos, firstAtom, secondAtom);
                    this.addCharClassAtom(firstAtom);
                    this.addCharClassAtom(secondAtom);
                    this.curCharClass.addRange(45, 45);
                } else {
                    if (secondAtom.getCodePoint() < firstAtom.getCodePoint()) {
                        throw this.handleCCRangeOutOfOrder(startPos);
                    }
                    this.curCharClass.addRange(firstAtom.getCodePoint(), secondAtom.getCodePoint());
                }
            }
        } else {
            this.addCharClassAtom(firstAtom);
        }
    }

    private void addCharClassAtom(ClassSetContents atom) {
        assert (atom.isCodePointSetOnly());
        this.curCharClass.addSet(atom.getCodePointSet());
    }

    private ClassSetContents parseEscapeCharClass(char c) throws RegexSyntaxException {
        if (RegexLexer.isPredefCharClass(c)) {
            return ClassSetContents.createCharacterClass(this.getPredefinedCharClass(c));
        }
        if (this.featureEnabledUnicodePropertyEscapes() && (c == 'p' || c == 'P')) {
            return this.parseUnicodeCharacterProperty(c == 'P');
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private ClassSetContents parseClassSetExpression() throws RegexSyntaxException {
        boolean invert = this.consumingLookahead("^");
        ClassSetContentsAccumulator curClassSet = new ClassSetContentsAccumulator();
        ClassSetOperator operator = null;
        boolean firstOperandIsRange = false;
        int startPos = this.position;
        while (!this.atEnd()) {
            if (!(this.curChar() != ']' || this.featureEnabledCharClassFirstBracketIsLiteral() && this.position == startPos)) {
                this.advance();
                if (invert && curClassSet.mayContainStrings()) {
                    throw this.handleComplementOfStringSet();
                }
                if (invert) {
                    assert (!curClassSet.mayContainStrings() && curClassSet.isCodePointSetOnly());
                    return ClassSetContents.createCharacterClass(this.complementClassSet(curClassSet.getCodePointSet()));
                }
                EconomicSet stringsCopy = EconomicSet.create((int)curClassSet.getStrings().size());
                stringsCopy.addAll(curClassSet.getStrings());
                return ClassSetContents.createClass(curClassSet.getCodePointSet(), (EconomicSet<String>)stringsCopy, curClassSet.mayContainStrings());
            }
            ClassSetOperator newOperator = this.parseClassSetOperator();
            if (this.position == startPos) {
                if (newOperator != ClassSetOperator.Union) {
                    throw this.handleMissingClassSetOperand(newOperator);
                }
            } else if (operator == null) {
                operator = newOperator;
                if (firstOperandIsRange && operator != ClassSetOperator.Union) {
                    throw this.handleRangeAsClassSetOperand(operator);
                }
            } else if (operator != newOperator) {
                throw this.handleMixedClassSetOperators(operator, newOperator);
            }
            if (this.atEnd()) break;
            if (this.curChar() == ']') {
                throw this.handleMissingClassSetOperand(newOperator);
            }
            ClassSetContents operand = this.parseClassSetOperandOrRange();
            if (operand.isRange() && operator != null && operator != ClassSetOperator.Union) {
                throw this.handleRangeAsClassSetOperand(operator);
            }
            if (operator == null) {
                curClassSet.addAll(operand);
                firstOperandIsRange = operand.isRange();
                continue;
            }
            switch (operator) {
                case Union: {
                    curClassSet.addAll(operand);
                    break;
                }
                case Intersection: {
                    curClassSet.retainAll(operand);
                    break;
                }
                case Difference: {
                    curClassSet.removeAll(operand, this.encoding);
                }
            }
        }
        throw this.handleUnmatchedLeftBracket();
    }

    private ClassSetOperator parseClassSetOperator() {
        if (this.consumingLookahead("&&")) {
            if (this.lookahead("&")) {
                throw this.handleInvalidCharInCharClass();
            }
            return ClassSetOperator.Intersection;
        }
        if (this.consumingLookahead("--")) {
            return ClassSetOperator.Difference;
        }
        return ClassSetOperator.Union;
    }

    private ClassSetContents parseClassSetOperandOrRange() {
        int startPos = this.position;
        this.charClassCurAtomStartIndex = this.position;
        char c = this.consumeChar();
        ClassSetContents contents = this.parseClassSetStrings(c);
        if (contents != null) {
            return this.caseFoldClassSetAtom(contents);
        }
        contents = this.parseCharClassAtomPredefCharClass(c);
        if (contents != null) {
            return contents;
        }
        if (c == '[') {
            return this.parseClassSetExpression();
        }
        int firstCodePoint = this.parseCharClassAtomCodePoint(c);
        if (this.lookahead("-") && !this.lookahead("--")) {
            this.advance();
            if (this.atEnd()) {
                throw this.handleUnmatchedLeftBracket();
            }
            if (this.curChar() == ']') {
                throw this.handleUnfinishedRangeInClassSet();
            }
            int secondCodePoint = this.parseCharClassAtomCodePoint(this.consumeChar());
            if (secondCodePoint < firstCodePoint) {
                throw this.handleCCRangeOutOfOrder(startPos);
            }
            return this.caseFoldClassSetAtom(ClassSetContents.createRange(firstCodePoint, secondCodePoint));
        }
        return this.caseFoldClassSetAtom(ClassSetContents.createCharacter(firstCodePoint));
    }

    private ClassSetContents parseClassSetStrings(char c) {
        if (c == '\\' && this.consumingLookahead("q{")) {
            EconomicSet strings = EconomicSet.create();
            CodePointSetAccumulator singleCodePoints = new CodePointSetAccumulator();
            do {
                String string;
                if ((string = this.parseClassSetString()).codePointCount(0, string.length()) == 1) {
                    singleCodePoints.addCodePoint(string.codePointAt(0));
                } else {
                    strings.add((Object)string);
                }
                if (!this.atEnd()) continue;
                throw this.syntaxError("Unterminated string set");
            } while (this.consumingLookahead('|'));
            if (this.atEnd()) {
                throw this.syntaxError("Unterminated string set");
            }
            assert (this.curChar() == '}');
            this.advance();
            return ClassSetContents.createStrings(singleCodePoints.toCodePointSet(), (EconomicSet<String>)strings);
        }
        return null;
    }

    private String parseClassSetString() {
        StringBuilder sb = new StringBuilder();
        while (!this.atEnd() && this.curChar() != '|' && this.curChar() != '}') {
            if (this.consumingLookahead('\\')) {
                if (this.atEnd()) {
                    this.handleUnfinishedEscape();
                }
                sb.appendCodePoint(this.parseEscapeChar(this.consumeChar(), true));
                continue;
            }
            sb.append(this.consumeChar());
        }
        return sb.toString();
    }

    private ClassSetContents parseUnicodeCharacterProperty(boolean invert) throws RegexSyntaxException {
        if (!this.consumingLookahead("{")) {
            throw this.syntaxError("Invalid Unicode property escape");
        }
        int namePos = this.position;
        while (!this.atEnd() && this.curChar() != '}') {
            this.advance();
        }
        if (!this.consumingLookahead("}")) {
            throw this.syntaxError("Ends with an unfinished Unicode property escape");
        }
        try {
            String propertyName = this.pattern.substring(namePos, this.position - 1);
            if (this.featureEnabledClassSetExpressions()) {
                ClassSetContents property = UnicodeProperties.getPropertyOfStrings(propertyName);
                if (invert) {
                    if (property.mayContainStrings()) {
                        throw this.handleComplementOfStringSet();
                    }
                    assert (property.isCodePointSetOnly());
                    property = this.caseFoldClassSetAtom(property);
                    return ClassSetContents.createCharacterClass(this.complementClassSet(property.getCodePointSet()));
                }
                return this.caseFoldClassSetAtom(property);
            }
            CodePointSet propertySet = UnicodeProperties.getProperty(propertyName);
            return ClassSetContents.createCharacterClass(invert ? propertySet.createInverse(this.encoding) : propertySet);
        }
        catch (IllegalArgumentException e) {
            throw this.syntaxError(e.getMessage());
        }
    }

    private int parseEscapeChar(char c, boolean inCharClass) throws RegexSyntaxException {
        int custom = this.parseCustomEscapeChar(c, inCharClass);
        if (custom >= 0) {
            return custom;
        }
        switch (c) {
            case 'b': {
                assert (inCharClass);
                return 8;
            }
            case 'f': {
                return 12;
            }
            case 'n': {
                return 10;
            }
            case 'r': {
                return 13;
            }
            case 't': {
                return 9;
            }
            case 'v': {
                return 11;
            }
            case 'x': {
                if (!this.consumingLookahead(RegexLexer::isHexDigit, 2)) {
                    this.handleIncompleteEscapeX();
                    return c;
                }
                return Integer.parseInt(this.pattern, this.position - 2, this.position, 16);
            }
        }
        if (this.featureEnabledOctalEscapes() && RegexLexer.isOctalDigit(c)) {
            return this.parseOctal(c - 48);
        }
        return this.parseCustomEscapeCharFallback(this.toCodePoint(c), inCharClass);
    }

    private int toCodePoint(char c) {
        if (this.encoding != Encodings.UTF_16_RAW && Character.isHighSurrogate(c)) {
            return this.finishSurrogatePair(c);
        }
        return c;
    }

    protected int finishSurrogatePair(char c) {
        assert (Character.isHighSurrogate(c));
        if (!this.atEnd() && Character.isLowSurrogate(this.curChar())) {
            return Character.toCodePoint(c, this.consumeChar());
        }
        return c;
    }

    protected int parseOctal(int firstDigit) {
        int ret = firstDigit;
        for (int i = 0; !this.atEnd() && RegexLexer.isOctalDigit(this.curChar()) && i < 2; ++i) {
            if (ret * 8 > 255) {
                this.handleOctalOutOfRange();
                return ret;
            }
            ret *= 8;
            ret += this.consumeChar() - 48;
        }
        return ret;
    }

    private boolean isEscapeCharClass(char c) {
        return RegexLexer.isPredefCharClass(c) || this.featureEnabledUnicodePropertyEscapes() && (c == 'p' || c == 'P');
    }

    public RegexSyntaxException syntaxError(String msg) {
        return RegexSyntaxException.createPattern(this.source, msg, this.getLastAtomPosition());
    }

    private static boolean isPredefCharClass(char c) {
        return PREDEFINED_CHAR_CLASSES.get(c);
    }

    protected static boolean isDecimalDigit(int c) {
        return 48 <= c && c <= 57;
    }

    protected static boolean isOctalDigit(int c) {
        return 48 <= c && c <= 55;
    }

    protected static boolean isHexDigit(int c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    public static final class ParseGroupNameResult {
        public final ParseGroupNameResultState state;
        public final String groupName;

        ParseGroupNameResult(ParseGroupNameResultState state, String groupName) {
            this.state = state;
            this.groupName = groupName;
        }
    }

    protected static enum ParseGroupNameResultState {
        empty,
        unterminated,
        invalidStart,
        invalidRest,
        valid;

    }

    public static enum ClassSetOperator {
        Union("implicit union"),
        Intersection("&&"),
        Difference("--");

        private final String repr;

        private ClassSetOperator(String repr) {
            this.repr = repr;
        }

        public String toString() {
            return this.repr;
        }
    }
}

