/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexExecNode;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.literal.LiteralRegexExecNode;
import com.oracle.truffle.regex.result.RegexResult;
import com.oracle.truffle.regex.runtime.nodes.ToLongNode;
import com.oracle.truffle.regex.tregex.TRegexCompilationRequest;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

@ExportLibrary(value=InteropLibrary.class)
public final class RegexObject
extends AbstractConstantKeysObject {
    static final String PROP_EXEC = "exec";
    static final String PROP_EXEC_BOOLEAN = "execBoolean";
    private static final String PROP_PATTERN = "pattern";
    private static final String PROP_FLAGS = "flags";
    private static final String PROP_GROUP_COUNT = "groupCount";
    private static final String PROP_GROUPS = "groups";
    private static final String PROP_IS_BACKTRACKING = "isBacktracking";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("exec", "execBoolean", "pattern", "flags", "groupCount", "groups", "isBacktracking");
    private final RegexLanguage language;
    private final RegexSource source;
    private final AbstractRegexObject flags;
    private final int numberOfCaptureGroups;
    private final AbstractRegexObject namedCaptureGroups;
    @CompilerDirectives.CompilationFinal
    private RegexRootNode execRootNode;
    @CompilerDirectives.CompilationFinal
    private RegexRootNode execBooleanRootNode;
    private final boolean backtracking;
    private static final String N_METHODS = "2";

    public RegexObject(RegexExecNode execNode, RegexSource source, AbstractRegexObject flags, int numberOfCaptureGroups, AbstractRegexObject namedCaptureGroups) {
        this.language = execNode.getRegexLanguage();
        this.source = source;
        this.flags = flags;
        this.numberOfCaptureGroups = numberOfCaptureGroups;
        this.namedCaptureGroups = namedCaptureGroups;
        RegexRootNode rootNode = new RegexRootNode(execNode.getRegexLanguage(), execNode);
        if (execNode.isBooleanMatch()) {
            this.execBooleanRootNode = rootNode;
        } else {
            this.execRootNode = rootNode;
        }
        this.backtracking = execNode.isBacktracking();
    }

    public RegexSource getSource() {
        return this.source;
    }

    public TruffleObject getFlags() {
        return this.flags;
    }

    public int getNumberOfCaptureGroups() {
        return this.numberOfCaptureGroups;
    }

    public TruffleObject getNamedCaptureGroups() {
        return this.namedCaptureGroups;
    }

    public String getLabel() {
        return this.execRootNode == null ? RegexObject.getLabel(this.execBooleanRootNode) : RegexObject.getLabel(this.execRootNode);
    }

    private static String getLabel(RegexRootNode rootNode) {
        RegexExecNode execNode = (RegexExecNode)rootNode.getBodyUnwrapped();
        if (execNode instanceof LiteralRegexExecNode) {
            return "literal";
        }
        if (execNode.isBacktracking()) {
            return "backtracker";
        }
        if (execNode.isNFA()) {
            return "nfa";
        }
        return "dfa";
    }

    public CallTarget getExecCallTarget() {
        if (this.execRootNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.execRootNode = new RegexRootNode(this.language, new TRegexCompilationRequest(this.language, this.execBooleanRootNode.getSource().withoutBooleanMatch()).compile());
        }
        return this.execRootNode.getCallTarget();
    }

    public CallTarget getExecBooleanCallTarget() {
        if (this.execBooleanRootNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.execBooleanRootNode = new RegexRootNode(this.language, new TRegexCompilationRequest(this.language, this.execRootNode.getSource().withBooleanMatch()).compile());
        }
        return this.execBooleanRootNode.getCallTarget();
    }

    public boolean isBacktracking() {
        return this.backtracking;
    }

    public RegexObjectExecMethod getExecMethod() {
        return new RegexObjectExecMethod(this);
    }

    public RegexObjectExecBooleanMethod getExecBooleanMethod() {
        return new RegexObjectExecBooleanMethod(this);
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public boolean isMemberReadableImpl(String symbol) {
        switch (symbol) {
            case "exec": 
            case "execBoolean": 
            case "pattern": 
            case "flags": 
            case "groupCount": 
            case "groups": 
            case "isBacktracking": {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "exec": {
                return this.getExecMethod();
            }
            case "execBoolean": {
                return this.getExecBooleanMethod();
            }
            case "pattern": {
                return this.getSource().getPattern();
            }
            case "flags": {
                return this.getFlags();
            }
            case "groupCount": {
                return this.getNumberOfCaptureGroups();
            }
            case "groups": {
                return this.getNamedCaptureGroups();
            }
            case "isBacktracking": {
                return this.isBacktracking();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create((String)symbol);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached ToLongNode toLongNode, @Cached InvokeCacheNode invokeCache) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
        if (args.length != 2) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ArityException.create((int)2, (int)2, (int)args.length);
        }
        Object input = args[0];
        long fromIndex = toLongNode.execute(args[1]);
        if (fromIndex > Integer.MAX_VALUE) {
            return RegexResult.getNoMatchInstance();
        }
        return invokeCache.execute(member, this, input, (int)fromIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "TRegexObject{source=" + this.source + "}";
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RegexObjectExecMethod
    extends AbstractRegexObject {
        private final RegexObject regex;

        public RegexObjectExecMethod(RegexObject regex) {
            this.regex = regex;
        }

        public RegexObject getRegexObject() {
            return this.regex;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] args, @Cached ToLongNode toLongNode, @Cached ExecCompiledRegexNode execNode) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (args.length != 2) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create((int)2, (int)2, (int)args.length);
            }
            Object input = args[0];
            long fromIndex = toLongNode.execute(args[1]);
            if (fromIndex > Integer.MAX_VALUE) {
                return RegexResult.getNoMatchInstance();
            }
            return execNode.execute(this.getRegexObject().getExecCallTarget(), input, (int)fromIndex);
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexObjectExecMethod{regex=" + this.regex + "}";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RegexObjectExecBooleanMethod
    extends AbstractRegexObject {
        private final RegexObject regex;

        public RegexObjectExecBooleanMethod(RegexObject regex) {
            this.regex = regex;
        }

        public RegexObject getRegexObject() {
            return this.regex;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        boolean execute(Object[] args, @Cached ToLongNode toLongNode, @Cached ExecCompiledRegexNode execNode) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (args.length != 2) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create((int)2, (int)2, (int)args.length);
            }
            Object input = args[0];
            long fromIndex = toLongNode.execute(args[1]);
            if (fromIndex > Integer.MAX_VALUE) {
                return false;
            }
            return execNode.execute(this.getRegexObject().getExecBooleanCallTarget(), input, (int)fromIndex) != RegexResult.getNoMatchInstance();
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexObjectExecMethod{regex=" + this.regex + "}";
        }
    }

    @ImportStatic(value={RegexObject.class})
    @GenerateUncached
    static abstract class InvokeCacheNode
    extends Node {
        InvokeCacheNode() {
        }

        abstract Object execute(String var1, RegexObject var2, Object var3, int var4) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException;

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_EXEC)"}, limit="2")
        Object execIdentity(String symbol, RegexObject receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver.getExecCallTarget(), input, fromIndex);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_EXEC)"}, limit="2", replaces={"execIdentity"})
        Object execEquals(String symbol, RegexObject receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver.getExecCallTarget(), input, fromIndex);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_EXEC_BOOLEAN)"}, limit="2")
        boolean execBooleanIdentity(String symbol, RegexObject receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver.getExecBooleanCallTarget(), input, fromIndex) != RegexResult.getNoMatchInstance();
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_EXEC_BOOLEAN)"}, limit="2", replaces={"execBooleanIdentity"})
        boolean execBooleanEquals(String symbol, RegexObject receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver.getExecBooleanCallTarget(), input, fromIndex) != RegexResult.getNoMatchInstance();
        }

        @Specialization(replaces={"execEquals", "execBooleanEquals"})
        @ReportPolymorphism.Megamorphic
        static Object invokeGeneric(String symbol, RegexObject receiver, Object input, int fromIndex, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
            switch (symbol) {
                case "exec": {
                    return execNode.execute(receiver.getExecCallTarget(), input, fromIndex);
                }
                case "execBoolean": {
                    return execNode.execute(receiver.getExecBooleanCallTarget(), input, fromIndex) != RegexResult.getNoMatchInstance();
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create((String)symbol);
        }
    }

    @ImportStatic(value={RegexObject.class})
    @GenerateUncached
    static abstract class ExecCompiledRegexNode
    extends Node {
        ExecCompiledRegexNode() {
        }

        abstract Object execute(CallTarget var1, Object var2, int var3) throws UnsupportedMessageException, ArityException, UnsupportedTypeException;

        @Specialization(guards={"receiver == cachedCallTarget"}, limit="4")
        static Object doDirectCall(CallTarget receiver, Object input, int fromIndex, @Cached(value="receiver") CallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode directCallNode) {
            return directCallNode.call(new Object[]{input, fromIndex});
        }

        @Specialization(replaces={"doDirectCall"})
        @ReportPolymorphism.Megamorphic
        static Object doIndirectCall(CallTarget receiver, Object input, int fromIndex, @Cached IndirectCallNode indirectCallNode) {
            return indirectCallNode.call(receiver, new Object[]{input, fromIndex});
        }
    }

    @ExportMessage
    static abstract class IsMemberInvocable {
        IsMemberInvocable() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "result"}, limit="2")
        static boolean cacheIdentity(RegexObject receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "result"}, limit="2", replaces={"cacheIdentity"})
        static boolean cacheEquals(RegexObject receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isInvocable(RegexObject receiver, String symbol) {
            return RegexObject.PROP_EXEC.equals(symbol) || RegexObject.PROP_EXEC_BOOLEAN.equals(symbol);
        }
    }
}

