// CheckStyle: start generated
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.tregex.nodes.input.InputCharAtNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(InputIndexOfNode.class)
public final class InputIndexOfNodeGen extends InputIndexOfNode {

    @CompilationFinal private int state_;
    @Child private InputCharAtNode indexOf1_charAtNode_;

    private InputIndexOfNodeGen() {
    }

    @Override
    public int execute(Object arg0Value, int arg1Value, int arg2Value, char[] arg3Value) {
        int state = state_;
        if (state != 0 /* is-active indexOf(String, int, int, char[]) || indexOf(TruffleObject, int, int, char[], InputCharAtNode) */) {
            if ((state & 0b1) != 0 /* is-active indexOf(String, int, int, char[]) */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return indexOf(arg0Value_, arg1Value, arg2Value, arg3Value);
            }
            if ((state & 0b10) != 0 /* is-active indexOf(TruffleObject, int, int, char[], InputCharAtNode) */ && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                return indexOf(arg0Value_, arg1Value, arg2Value, arg3Value, this.indexOf1_charAtNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    private int executeAndSpecialize(Object arg0Value, int arg1Value, int arg2Value, char[] arg3Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        try {
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                this.state_ = state = state | 0b1 /* add-active indexOf(String, int, int, char[]) */;
                lock.unlock();
                hasLock = false;
                return indexOf(arg0Value_, arg1Value, arg2Value, arg3Value);
            }
            if (arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                this.indexOf1_charAtNode_ = super.insert((InputCharAtNode.create()));
                this.state_ = state = state | 0b10 /* add-active indexOf(TruffleObject, int, int, char[], InputCharAtNode) */;
                lock.unlock();
                hasLock = false;
                return indexOf(arg0Value_, arg1Value, arg2Value, arg3Value, this.indexOf1_charAtNode_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static InputIndexOfNode create() {
        return new InputIndexOfNodeGen();
    }

}
