// CheckStyle: start generated
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.regex.runtime.nodes.ToCharNode;
import com.oracle.truffle.regex.runtime.nodes.ToCharNodeGen;
import com.oracle.truffle.regex.runtime.nodes.ToStringNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ToStringNode.class)
public final class ToStringNodeGen extends ToStringNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private BoxedString0Data boxedString0_cache;
    @Child private BoxedCharArray0Data boxedCharArray0_cache;
    @Child private ToCharNode boxedCharArray1_toCharNode_;

    private ToStringNodeGen() {
    }

    @ExplodeLoop
    @Override
    public String execute(Object arg0Value) throws UnsupportedTypeException {
        int state = state_;
        if ((state & 0b1) != 0 /* is-active doString(String) */ && arg0Value instanceof String) {
            String arg0Value_ = (String) arg0Value;
            return ToStringNode.doString(arg0Value_);
        }
        if ((state & 0b11110) != 0 /* is-active doBoxedString(Object, InteropLibrary) || doBoxedString(Object, InteropLibrary) || doBoxedCharArray(Object, InteropLibrary, ToCharNode) || doBoxedCharArray(Object, InteropLibrary, ToCharNode) */) {
            if ((state & 0b10) != 0 /* is-active doBoxedString(Object, InteropLibrary) */) {
                BoxedString0Data s2_ = this.boxedString0_cache;
                while (s2_ != null) {
                    if ((s2_.inputs_.accepts(arg0Value)) && (s2_.inputs_.isString(arg0Value))) {
                        return ToStringNode.doBoxedString(arg0Value, s2_.inputs_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 0b100) != 0 /* is-active doBoxedString(Object, InteropLibrary) */) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    if (((INTEROP_LIBRARY_.getUncached(arg0Value)).isString(arg0Value))) {
                        return ToStringNode.doBoxedString(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
                    }
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
            if ((state & 0b1000) != 0 /* is-active doBoxedCharArray(Object, InteropLibrary, ToCharNode) */) {
                BoxedCharArray0Data s4_ = this.boxedCharArray0_cache;
                while (s4_ != null) {
                    if ((s4_.inputs_.accepts(arg0Value)) && (s4_.inputs_.hasArrayElements(arg0Value))) {
                        return ToStringNode.doBoxedCharArray(arg0Value, s4_.inputs_, s4_.toCharNode_);
                    }
                    s4_ = s4_.next_;
                }
            }
            if ((state & 0b10000) != 0 /* is-active doBoxedCharArray(Object, InteropLibrary, ToCharNode) */) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    if (((INTEROP_LIBRARY_.getUncached(arg0Value)).hasArrayElements(arg0Value))) {
                        return ToStringNode.doBoxedCharArray(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)), this.boxedCharArray1_toCharNode_);
                    }
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private String executeAndSpecialize(Object arg0Value) throws UnsupportedTypeException {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                this.state_ = state = state | 0b1 /* add-active doString(String) */;
                lock.unlock();
                hasLock = false;
                return ToStringNode.doString(arg0Value_);
            }
            if (((exclude & 0b1)) == 0 /* is-not-excluded doBoxedString(Object, InteropLibrary) */) {
                int count2_ = 0;
                BoxedString0Data s2_ = this.boxedString0_cache;
                if ((state & 0b10) != 0 /* is-active doBoxedString(Object, InteropLibrary) */) {
                    while (s2_ != null) {
                        if ((s2_.inputs_.accepts(arg0Value)) && (s2_.inputs_.isString(arg0Value))) {
                            break;
                        }
                        s2_ = s2_.next_;
                        count2_++;
                    }
                }
                if (s2_ == null) {
                    {
                        InteropLibrary inputs__ = super.insert((INTEROP_LIBRARY_.create(arg0Value)));
                        // assert (s2_.inputs_.accepts(arg0Value));
                        if ((inputs__.isString(arg0Value)) && count2_ < (2)) {
                            s2_ = super.insert(new BoxedString0Data(boxedString0_cache));
                            s2_.inputs_ = s2_.insertAccessor(inputs__);
                            this.boxedString0_cache = s2_;
                            this.state_ = state = state | 0b10 /* add-active doBoxedString(Object, InteropLibrary) */;
                        }
                    }
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return ToStringNode.doBoxedString(arg0Value, s2_.inputs_);
                }
            }
            {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    {
                        InteropLibrary boxedString1_inputs__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                        if ((boxedString1_inputs__.isString(arg0Value))) {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doBoxedString(Object, InteropLibrary) */;
                            this.boxedString0_cache = null;
                            state = state & 0xfffffffd /* remove-active doBoxedString(Object, InteropLibrary) */;
                            this.state_ = state = state | 0b100 /* add-active doBoxedString(Object, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return ToStringNode.doBoxedString(arg0Value, boxedString1_inputs__);
                        }
                    }
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
            if (((exclude & 0b10)) == 0 /* is-not-excluded doBoxedCharArray(Object, InteropLibrary, ToCharNode) */) {
                int count4_ = 0;
                BoxedCharArray0Data s4_ = this.boxedCharArray0_cache;
                if ((state & 0b1000) != 0 /* is-active doBoxedCharArray(Object, InteropLibrary, ToCharNode) */) {
                    while (s4_ != null) {
                        if ((s4_.inputs_.accepts(arg0Value)) && (s4_.inputs_.hasArrayElements(arg0Value))) {
                            break;
                        }
                        s4_ = s4_.next_;
                        count4_++;
                    }
                }
                if (s4_ == null) {
                    {
                        InteropLibrary inputs__ = super.insert((INTEROP_LIBRARY_.create(arg0Value)));
                        // assert (s4_.inputs_.accepts(arg0Value));
                        if ((inputs__.hasArrayElements(arg0Value)) && count4_ < (2)) {
                            s4_ = super.insert(new BoxedCharArray0Data(boxedCharArray0_cache));
                            s4_.inputs_ = s4_.insertAccessor(inputs__);
                            s4_.toCharNode_ = s4_.insertAccessor((ToCharNode.create()));
                            this.boxedCharArray0_cache = s4_;
                            this.state_ = state = state | 0b1000 /* add-active doBoxedCharArray(Object, InteropLibrary, ToCharNode) */;
                        }
                    }
                }
                if (s4_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return ToStringNode.doBoxedCharArray(arg0Value, s4_.inputs_, s4_.toCharNode_);
                }
            }
            {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    {
                        InteropLibrary boxedCharArray1_inputs__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                        if ((boxedCharArray1_inputs__.hasArrayElements(arg0Value))) {
                            this.boxedCharArray1_toCharNode_ = super.insert((ToCharNode.create()));
                            this.exclude_ = exclude = exclude | 0b10 /* add-excluded doBoxedCharArray(Object, InteropLibrary, ToCharNode) */;
                            this.boxedCharArray0_cache = null;
                            state = state & 0xfffffff7 /* remove-active doBoxedCharArray(Object, InteropLibrary, ToCharNode) */;
                            this.state_ = state = state | 0b10000 /* add-active doBoxedCharArray(Object, InteropLibrary, ToCharNode) */;
                            lock.unlock();
                            hasLock = false;
                            return ToStringNode.doBoxedCharArray(arg0Value, boxedCharArray1_inputs__, this.boxedCharArray1_toCharNode_);
                        }
                    }
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            BoxedString0Data s2_ = this.boxedString0_cache;
            BoxedCharArray0Data s4_ = this.boxedCharArray0_cache;
            if ((s2_ == null || s2_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToStringNode create() {
        return new ToStringNodeGen();
    }

    public static ToStringNode getUncached() {
        return ToStringNodeGen.UNCACHED;
    }

    @GeneratedBy(ToStringNode.class)
    private static final class BoxedString0Data extends Node {

        @Child BoxedString0Data next_;
        @Child InteropLibrary inputs_;

        BoxedString0Data(BoxedString0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(ToStringNode.class)
    private static final class BoxedCharArray0Data extends Node {

        @Child BoxedCharArray0Data next_;
        @Child InteropLibrary inputs_;
        @Child ToCharNode toCharNode_;

        BoxedCharArray0Data(BoxedCharArray0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(ToStringNode.class)
    private static final class Uncached extends ToStringNode {

        @TruffleBoundary
        @Override
        public String execute(Object arg0Value) throws UnsupportedTypeException {
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return ToStringNode.doString(arg0Value_);
            }
            if (((INTEROP_LIBRARY_.getUncached(arg0Value)).isString(arg0Value))) {
                return ToStringNode.doBoxedString(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
            }
            if (((INTEROP_LIBRARY_.getUncached(arg0Value)).hasArrayElements(arg0Value))) {
                return ToStringNode.doBoxedCharArray(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)), (ToCharNodeGen.getUncached()));
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
