// CheckStyle: start generated
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.regex.result.LazyCaptureGroupsResult;
import com.oracle.truffle.regex.result.NoMatchResult;
import com.oracle.truffle.regex.result.RegexResultGetEndNode;
import com.oracle.truffle.regex.result.SingleIndexArrayResult;
import com.oracle.truffle.regex.result.SingleResult;
import com.oracle.truffle.regex.result.SingleResultLazyStart;
import com.oracle.truffle.regex.result.TraceFinderResult;
import com.oracle.truffle.regex.runtime.nodes.LazyCaptureGroupGetResultNode;
import com.oracle.truffle.regex.runtime.nodes.LazyCaptureGroupGetResultNodeGen;
import com.oracle.truffle.regex.runtime.nodes.TraceFinderGetResultNode;
import com.oracle.truffle.regex.runtime.nodes.TraceFinderGetResultNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(RegexResultGetEndNode.class)
final class RegexResultGetEndNodeGen extends RegexResultGetEndNode {

    private static final Uncached UNCACHED = new Uncached();

    @CompilationFinal private int state_;
    @CompilationFinal private ConditionProfile singleResult_boundsProfile_;
    @CompilationFinal private ConditionProfile singleResultLazyStart_boundsProfile_;
    @Child private TraceFinderGetResultNode traceFinder_getResultNode_;
    @Child private LazyCaptureGroupGetResultNode lazyCaptureGroups_getResultNode_;

    private RegexResultGetEndNodeGen() {
    }

    @Override
    int execute(Object arg0Value, int arg1Value) {
        int state = state_;
        if (state != 0 /* is-active doNoMatch(NoMatchResult, int) || doSingleResult(SingleResult, int, ConditionProfile) || doSingleResultLazyStart(SingleResultLazyStart, int, ConditionProfile) || doSingleIndexArray(SingleIndexArrayResult, int) || doTraceFinder(TraceFinderResult, int, TraceFinderGetResultNode) || doLazyCaptureGroups(LazyCaptureGroupsResult, int, LazyCaptureGroupGetResultNode) */) {
            if ((state & 0b1) != 0 /* is-active doNoMatch(NoMatchResult, int) */ && arg0Value instanceof NoMatchResult) {
                NoMatchResult arg0Value_ = (NoMatchResult) arg0Value;
                return RegexResultGetEndNode.doNoMatch(arg0Value_, arg1Value);
            }
            if ((state & 0b10) != 0 /* is-active doSingleResult(SingleResult, int, ConditionProfile) */ && arg0Value instanceof SingleResult) {
                SingleResult arg0Value_ = (SingleResult) arg0Value;
                return RegexResultGetEndNode.doSingleResult(arg0Value_, arg1Value, this.singleResult_boundsProfile_);
            }
            if ((state & 0b100) != 0 /* is-active doSingleResultLazyStart(SingleResultLazyStart, int, ConditionProfile) */ && arg0Value instanceof SingleResultLazyStart) {
                SingleResultLazyStart arg0Value_ = (SingleResultLazyStart) arg0Value;
                return RegexResultGetEndNode.doSingleResultLazyStart(arg0Value_, arg1Value, this.singleResultLazyStart_boundsProfile_);
            }
            if ((state & 0b1000) != 0 /* is-active doSingleIndexArray(SingleIndexArrayResult, int) */ && arg0Value instanceof SingleIndexArrayResult) {
                SingleIndexArrayResult arg0Value_ = (SingleIndexArrayResult) arg0Value;
                return RegexResultGetEndNode.doSingleIndexArray(arg0Value_, arg1Value);
            }
            if ((state & 0b10000) != 0 /* is-active doTraceFinder(TraceFinderResult, int, TraceFinderGetResultNode) */ && arg0Value instanceof TraceFinderResult) {
                TraceFinderResult arg0Value_ = (TraceFinderResult) arg0Value;
                return RegexResultGetEndNode.doTraceFinder(arg0Value_, arg1Value, this.traceFinder_getResultNode_);
            }
            if ((state & 0b100000) != 0 /* is-active doLazyCaptureGroups(LazyCaptureGroupsResult, int, LazyCaptureGroupGetResultNode) */ && arg0Value instanceof LazyCaptureGroupsResult) {
                LazyCaptureGroupsResult arg0Value_ = (LazyCaptureGroupsResult) arg0Value;
                return RegexResultGetEndNode.doLazyCaptureGroups(arg0Value_, arg1Value, this.lazyCaptureGroups_getResultNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private int executeAndSpecialize(Object arg0Value, int arg1Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int oldState = state;
        try {
            if (arg0Value instanceof NoMatchResult) {
                NoMatchResult arg0Value_ = (NoMatchResult) arg0Value;
                this.state_ = state = state | 0b1 /* add-active doNoMatch(NoMatchResult, int) */;
                lock.unlock();
                hasLock = false;
                return RegexResultGetEndNode.doNoMatch(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof SingleResult) {
                SingleResult arg0Value_ = (SingleResult) arg0Value;
                this.singleResult_boundsProfile_ = (ConditionProfile.createBinaryProfile());
                this.state_ = state = state | 0b10 /* add-active doSingleResult(SingleResult, int, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return RegexResultGetEndNode.doSingleResult(arg0Value_, arg1Value, this.singleResult_boundsProfile_);
            }
            if (arg0Value instanceof SingleResultLazyStart) {
                SingleResultLazyStart arg0Value_ = (SingleResultLazyStart) arg0Value;
                this.singleResultLazyStart_boundsProfile_ = (ConditionProfile.createBinaryProfile());
                this.state_ = state = state | 0b100 /* add-active doSingleResultLazyStart(SingleResultLazyStart, int, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return RegexResultGetEndNode.doSingleResultLazyStart(arg0Value_, arg1Value, this.singleResultLazyStart_boundsProfile_);
            }
            if (arg0Value instanceof SingleIndexArrayResult) {
                SingleIndexArrayResult arg0Value_ = (SingleIndexArrayResult) arg0Value;
                this.state_ = state = state | 0b1000 /* add-active doSingleIndexArray(SingleIndexArrayResult, int) */;
                lock.unlock();
                hasLock = false;
                return RegexResultGetEndNode.doSingleIndexArray(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof TraceFinderResult) {
                TraceFinderResult arg0Value_ = (TraceFinderResult) arg0Value;
                this.traceFinder_getResultNode_ = super.insert((TraceFinderGetResultNodeGen.create()));
                this.state_ = state = state | 0b10000 /* add-active doTraceFinder(TraceFinderResult, int, TraceFinderGetResultNode) */;
                lock.unlock();
                hasLock = false;
                return RegexResultGetEndNode.doTraceFinder(arg0Value_, arg1Value, this.traceFinder_getResultNode_);
            }
            if (arg0Value instanceof LazyCaptureGroupsResult) {
                LazyCaptureGroupsResult arg0Value_ = (LazyCaptureGroupsResult) arg0Value;
                this.lazyCaptureGroups_getResultNode_ = super.insert((LazyCaptureGroupGetResultNodeGen.create()));
                this.state_ = state = state | 0b100000 /* add-active doLazyCaptureGroups(LazyCaptureGroupsResult, int, LazyCaptureGroupGetResultNode) */;
                lock.unlock();
                hasLock = false;
                return RegexResultGetEndNode.doLazyCaptureGroups(arg0Value_, arg1Value, this.lazyCaptureGroups_getResultNode_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        } finally {
            if (oldState != 0) {
                checkForPolymorphicSpecialize(oldState);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState) {
        int newState = this.state_;
        if ((oldState ^ newState) != 0) {
            this.reportPolymorphicSpecialize();
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static RegexResultGetEndNode create() {
        return new RegexResultGetEndNodeGen();
    }

    public static RegexResultGetEndNode getUncached() {
        return RegexResultGetEndNodeGen.UNCACHED;
    }

    @GeneratedBy(RegexResultGetEndNode.class)
    private static final class Uncached extends RegexResultGetEndNode {

        @TruffleBoundary
        @Override
        int execute(Object arg0Value, int arg1Value) {
            if (arg0Value instanceof NoMatchResult) {
                NoMatchResult arg0Value_ = (NoMatchResult) arg0Value;
                return RegexResultGetEndNode.doNoMatch(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof SingleResult) {
                SingleResult arg0Value_ = (SingleResult) arg0Value;
                return RegexResultGetEndNode.doSingleResult(arg0Value_, arg1Value, (ConditionProfile.getUncached()));
            }
            if (arg0Value instanceof SingleResultLazyStart) {
                SingleResultLazyStart arg0Value_ = (SingleResultLazyStart) arg0Value;
                return RegexResultGetEndNode.doSingleResultLazyStart(arg0Value_, arg1Value, (ConditionProfile.getUncached()));
            }
            if (arg0Value instanceof SingleIndexArrayResult) {
                SingleIndexArrayResult arg0Value_ = (SingleIndexArrayResult) arg0Value;
                return RegexResultGetEndNode.doSingleIndexArray(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof TraceFinderResult) {
                TraceFinderResult arg0Value_ = (TraceFinderResult) arg0Value;
                return RegexResultGetEndNode.doTraceFinder(arg0Value_, arg1Value, (TraceFinderGetResultNodeGen.getUncached()));
            }
            if (arg0Value instanceof LazyCaptureGroupsResult) {
                LazyCaptureGroupsResult arg0Value_ = (LazyCaptureGroupsResult) arg0Value;
                return RegexResultGetEndNode.doLazyCaptureGroups(arg0Value_, arg1Value, (LazyCaptureGroupGetResultNodeGen.getUncached()));
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
