/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.charset.RangesAccumulator;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.tregex.TRegexCompilationRequest;
import com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import com.oracle.truffle.regex.tregex.buffer.AbstractArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.CharRangesBuffer;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.ShortArrayBuffer;
import com.oracle.truffle.regex.tregex.dfa.DFACaptureGroupTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFAStateNodeBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFATransitionCanonicalizer;
import com.oracle.truffle.regex.tregex.dfa.NFAStateSet;
import com.oracle.truffle.regex.tregex.dfa.NFATransitionSet;
import com.oracle.truffle.regex.tregex.dfa.PrioritySensitiveNFATransitionSet;
import com.oracle.truffle.regex.tregex.matchers.AnyMatcher;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nfa.ASTNodeSet;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.AllTransitionsInOneTreeMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.BackwardDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.CGTrackingDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupLazyTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAFindInnerLiteralStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAInitialStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCG;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCGTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorDebugRecorder;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorProperties;
import com.oracle.truffle.regex.tregex.nodes.dfa.TraceFinderDFAStateNode;
import com.oracle.truffle.regex.tregex.nodesplitter.DFANodeSplit;
import com.oracle.truffle.regex.tregex.nodesplitter.DFANodeSplitBailoutException;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.RegexProperties;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.AddToSetVisitor;
import com.oracle.truffle.regex.tregex.util.MathUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graalvm.collections.EconomicMap;

public final class DFAGenerator
implements JsonConvertible {
    private static final DFAStateTransitionBuilder[] EMPTY_TRANSITIONS_ARRAY = new DFAStateTransitionBuilder[0];
    private static final short[] EMPTY_SHORT_ARRAY = new short[0];
    private final TRegexCompilationRequest compilationReqest;
    private final NFA nfa;
    private final TRegexDFAExecutorProperties executorProps;
    private final CompilationBuffer compilationBuffer;
    private final RegexOptions engineOptions;
    private final boolean pruneUnambiguousPaths;
    private final Map<DFAStateNodeBuilder, DFAStateNodeBuilder> stateMap = new HashMap<DFAStateNodeBuilder, DFAStateNodeBuilder>();
    private final ArrayDeque<DFAStateNodeBuilder> expansionQueue = new ArrayDeque();
    private DFAStateNodeBuilder[] stateIndexMap = null;
    private short nextID = 1;
    private final DFAStateNodeBuilder lookupDummyState = new DFAStateNodeBuilder(-1, null, false, false);
    private final Counter transitionIDCounter = new Counter.ThresholdCounter(Integer.MAX_VALUE, "too many transitions");
    private final Counter cgPartialTransitionIDCounter = new Counter.ThresholdCounter(Integer.MAX_VALUE, "too many partial transitions");
    private int maxNumberOfNfaStates = 1;
    private boolean hasAmbiguousStates = false;
    private boolean doSimpleCG = false;
    private boolean simpleCGMustCopy = false;
    private DFAStateNodeBuilder[] entryStates;
    private final DFACaptureGroupTransitionBuilder initialCGTransition;
    private DFACaptureGroupLazyTransition[] captureGroupTransitions = null;
    private final List<DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo> cgPartialTransitions;
    private final DFATransitionCanonicalizer canonicalizer;
    private final List<DFAStateTransitionBuilder> expandDFATransitions = new ArrayList<DFAStateTransitionBuilder>();
    private List<DFAStateTransitionBuilder[]> bfsTraversalCur;
    private List<DFAStateTransitionBuilder[]> bfsTraversalNext;
    private EconomicMap<Short, DFAAbstractStateNode> stateReplacements;

    public DFAGenerator(TRegexCompilationRequest compilationReqest, NFA nfa, TRegexDFAExecutorProperties executorProps, CompilationBuffer compilationBuffer, RegexOptions engineOptions) {
        this.compilationReqest = compilationReqest;
        this.nfa = nfa;
        this.executorProps = executorProps;
        this.pruneUnambiguousPaths = executorProps.isBackward() && nfa.isTraceFinderNFA() && nfa.hasReverseUnAnchoredEntry();
        this.canonicalizer = new DFATransitionCanonicalizer(this.isGenericCG());
        this.compilationBuffer = compilationBuffer;
        this.engineOptions = engineOptions;
        this.cgPartialTransitions = this.debugMode() ? new ArrayList() : null;
        this.bfsTraversalCur = this.needBFSTraversalLists() ? new ArrayList() : null;
        this.bfsTraversalNext = this.needBFSTraversalLists() ? new ArrayList() : null;
        this.initialCGTransition = this.isGenericCG() ? new DFACaptureGroupTransitionBuilder(null, null, null) : null;
        this.transitionIDCounter.inc();
        this.cgPartialTransitionIDCounter.inc();
        if (this.debugMode()) {
            this.registerCGPartialTransitionDebugInfo(new DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo(DFACaptureGroupPartialTransition.getEmptyInstance()));
        }
        assert (!nfa.isDead());
    }

    public NFA getNfa() {
        return this.nfa;
    }

    public DFAStateNodeBuilder[] getEntryStates() {
        return this.entryStates;
    }

    public Map<DFAStateNodeBuilder, DFAStateNodeBuilder> getStateMap() {
        return this.stateMap;
    }

    public TRegexDFAExecutorProperties getProps() {
        return this.executorProps;
    }

    public boolean isForward() {
        return this.executorProps.isForward();
    }

    public boolean isGenericCG() {
        return this.executorProps.isGenericCG();
    }

    public boolean isSearching() {
        return this.executorProps.isSearching();
    }

    private RegexOptions getOptions() {
        return this.nfa.getAst().getOptions();
    }

    public RegexOptions getEngineOptions() {
        return this.engineOptions;
    }

    private DFAStateNodeBuilder[] getStateIndexMap() {
        if (this.stateIndexMap == null) {
            this.createStateIndexMap(this.nextID);
        }
        return this.stateIndexMap;
    }

    public DFAStateNodeBuilder getState(short stateNodeID) {
        assert (this.debugMode());
        this.getStateIndexMap();
        return this.stateIndexMap[stateNodeID];
    }

    private void createStateIndexMap(int size) {
        assert (this.debugMode());
        this.stateIndexMap = new DFAStateNodeBuilder[size];
        Iterator<DFAStateNodeBuilder> iterator = this.stateMap.values().iterator();
        while (iterator.hasNext()) {
            DFAStateNodeBuilder s;
            this.stateIndexMap[s.getId()] = s = iterator.next();
        }
    }

    public void nodeSplitSetNewDFASize(int size) {
        assert (this.debugMode());
        assert (this.stateIndexMap == null);
        this.createStateIndexMap(size);
    }

    public void nodeSplitRegisterDuplicateState(short oldID, short newID) {
        DFAStateNodeBuilder copy;
        assert (this.debugMode());
        this.stateIndexMap[newID] = copy = this.stateIndexMap[oldID].createNodeSplitCopy(newID);
        for (DFAStateTransitionBuilder t : copy.getTransitions()) {
            t.setId(this.transitionIDCounter.inc());
            t.setSource(copy);
        }
    }

    public void nodeSplitUpdateSuccessors(short stateID, short[] newSuccessors) {
        assert (this.debugMode());
        assert (this.stateIndexMap[stateID] != null);
        this.stateIndexMap[stateID].nodeSplitUpdateSuccessors(newSuccessors, this.stateIndexMap);
    }

    public Counter getCgPartialTransitionIDCounter() {
        return this.cgPartialTransitionIDCounter;
    }

    public void registerCGPartialTransitionDebugInfo(DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo partialTransition) {
        if (this.cgPartialTransitions.size() == partialTransition.getNode().getId()) {
            this.cgPartialTransitions.add(partialTransition);
        } else assert (partialTransition.getNode() == this.cgPartialTransitions.get(partialTransition.getNode().getId()).getNode());
    }

    private boolean needBFSTraversalLists() {
        return this.pruneUnambiguousPaths || this.nfa.getAst().getProperties().hasInnerLiteral();
    }

    private void bfsExpand(DFAStateNodeBuilder s) {
        if (s.getTransitions() != null) {
            this.bfsTraversalNext.add(s.getTransitions());
        }
    }

    private void bfsSwapLists() {
        List<DFAStateTransitionBuilder[]> tmp = this.bfsTraversalCur;
        this.bfsTraversalCur = this.bfsTraversalNext;
        this.bfsTraversalNext = tmp;
    }

    @CompilerDirectives.TruffleBoundary
    public void calcDFA() {
        if (this.isForward()) {
            this.createInitialStatesForward();
        } else {
            this.createInitialStatesBackward();
        }
        while (!this.expansionQueue.isEmpty()) {
            this.expandState(this.expansionQueue.pop());
        }
        this.optimizeDFA();
    }

    @CompilerDirectives.TruffleBoundary
    public TRegexDFAExecutorNode createDFAExecutor() {
        if (this.isGenericCG()) {
            int maxNumberOfEntryStateSuccessors = 0;
            for (DFAStateNodeBuilder entryState : this.entryStates) {
                if (entryState == null) continue;
                maxNumberOfEntryStateSuccessors = Math.max(entryState.getTransitions().length, maxNumberOfEntryStateSuccessors);
            }
            this.captureGroupTransitions = new DFACaptureGroupLazyTransition[this.transitionIDCounter.getCount()];
            Object[] partialTransitions = new DFACaptureGroupPartialTransition[maxNumberOfEntryStateSuccessors];
            Arrays.fill(partialTransitions, DFACaptureGroupPartialTransition.getEmptyInstance());
            DFACaptureGroupLazyTransition emptyInitialTransition = new DFACaptureGroupLazyTransition(0, (DFACaptureGroupPartialTransition[])partialTransitions, DFACaptureGroupPartialTransition.getEmptyInstance(), DFACaptureGroupPartialTransition.getEmptyInstance());
            this.registerCGTransition(emptyInitialTransition);
            this.initialCGTransition.setLazyTransition(emptyInitialTransition);
        }
        DFAAbstractStateNode[] states = this.createDFAExecutorStates();
        assert (states[0] == null);
        short[] entryStateIDs = new short[this.entryStates.length];
        for (int i = 0; i < this.entryStates.length; ++i) {
            entryStateIDs[i] = this.entryStates[i] == null ? -1 : this.entryStates[i].getId();
        }
        states[0] = new DFAInitialStateNode(entryStateIDs, this.isSearching(), this.isGenericCG());
        this.executorProps.setSimpleCG(this.doSimpleCG);
        this.executorProps.setSimpleCGMustCopy(this.simpleCGMustCopy);
        return new TRegexDFAExecutorNode(this.executorProps, this.maxNumberOfNfaStates, states, this.captureGroupTransitions, TRegexDFAExecutorDebugRecorder.create(this.engineOptions, this));
    }

    private void createInitialStatesForward() {
        int numberOfEntryPoints = this.nfa.getAnchoredEntry().length;
        this.entryStates = new DFAStateNodeBuilder[numberOfEntryPoints * 2];
        this.nfa.setInitialLoopBack(this.isSearching() && !this.nfa.getAst().getFlags().isSticky());
        for (int i = 0; i < numberOfEntryPoints; ++i) {
            NFATransitionSet anchoredEntryStateSet = this.createNFATransitionSet(this.nfa.getAnchoredEntry()[i]);
            if (this.nfa.getUnAnchoredEntry()[i].getTarget().getNext().length == 0) {
                this.entryStates[numberOfEntryPoints + i] = null;
            } else {
                NFATransitionSet unAnchoredEntryStateSet = this.createNFATransitionSet(this.nfa.getUnAnchoredEntry()[i]);
                anchoredEntryStateSet.addAll(unAnchoredEntryStateSet);
                DFAStateTransitionBuilder unAnchoredEntryTransition = this.createTransitionBuilder(unAnchoredEntryStateSet);
                this.entryStates[numberOfEntryPoints + i] = this.createInitialState(unAnchoredEntryTransition);
            }
            DFAStateTransitionBuilder anchoredEntryTransition = this.createTransitionBuilder(anchoredEntryStateSet);
            this.entryStates[i] = this.createInitialState(anchoredEntryTransition);
        }
    }

    private void createInitialStatesBackward() {
        NFATransitionSet anchoredEntry = this.createNFATransitionSet(this.nfa.getReverseAnchoredEntry());
        this.entryStates = new DFAStateNodeBuilder[]{null, null};
        if (this.nfa.hasReverseUnAnchoredEntry()) {
            anchoredEntry.add(this.nfa.getReverseUnAnchoredEntry());
            NFATransitionSet unAnchoredEntry = this.createNFATransitionSet(this.nfa.getReverseUnAnchoredEntry());
            this.entryStates[1] = this.createInitialState(this.createTransitionBuilder(unAnchoredEntry));
        }
        this.entryStates[0] = this.createInitialState(this.createTransitionBuilder(anchoredEntry));
    }

    private DFAStateNodeBuilder createInitialState(DFAStateTransitionBuilder transition) {
        DFAStateNodeBuilder lookup = this.lookupState((NFATransitionSet)transition.getTransitionSet(), false);
        if (lookup == null) {
            lookup = this.createState((NFATransitionSet)transition.getTransitionSet(), false, true);
            lookup.updateFinalStateData(this);
        }
        transition.setTarget(lookup);
        if (this.isGenericCG()) {
            lookup.addPrecedingTransition(this.initialCGTransition);
        }
        return lookup;
    }

    private void expandState(DFAStateNodeBuilder state) {
        if (this.pruneUnambiguousPaths && this.tryPruneTraceFinderState(state)) {
            return;
        }
        this.expandDFATransitions.clear();
        boolean anyPrefixStateSuccessors = false;
        boolean allPrefixStateSuccessors = true;
        block0: for (NFAStateTransition transition : state.getNfaTransitionSet()) {
            NFAState nfaState = transition.getTarget(this.isForward());
            for (NFAStateTransition nfaTransition : nfaState.getNext(this.isForward())) {
                NFAState target = nfaTransition.getTarget(this.isForward());
                if (!(target.isFinalState(this.isForward()) || state.isBackwardPrefixState() && !target.hasPrefixStates())) {
                    anyPrefixStateSuccessors |= target.hasPrefixStates();
                    allPrefixStateSuccessors &= target.hasPrefixStates();
                    this.expandDFATransitions.add(this.createTransitionBuilder(target.getCharSet(), this.createNFATransitionSet(nfaTransition)));
                    continue;
                }
                if (!this.isForward() || !target.isForwardUnAnchoredFinalState()) continue;
                assert (target == this.nfa.getReverseUnAnchoredEntry().getSource());
                break block0;
            }
        }
        if (!this.isForward() && anyPrefixStateSuccessors) {
            if (allPrefixStateSuccessors) {
                state.setBackwardPrefixState(state.getId());
            } else {
                assert (!state.isBackwardPrefixState());
                DFAStateNodeBuilder lookup = this.lookupState(state.getNfaTransitionSet(), true);
                if (lookup == null) {
                    lookup = this.createState(state.getNfaTransitionSet(), true, false);
                }
                state.setBackwardPrefixState(lookup.getId());
            }
        }
        DFAStateTransitionBuilder[] transitions = (DFAStateTransitionBuilder[])this.canonicalizer.run(this.expandDFATransitions, this.compilationBuffer);
        Arrays.sort(transitions, Comparator.comparing(TransitionBuilder::getMatcherBuilder));
        for (DFAStateTransitionBuilder transition : transitions) {
            assert (!((NFATransitionSet)transition.getTransitionSet()).isEmpty());
            transition.setId(this.transitionIDCounter.inc());
            transition.setSource(state);
            DFAStateNodeBuilder successorState = this.lookupState((NFATransitionSet)transition.getTransitionSet(), false);
            if (successorState == null) {
                successorState = this.createState((NFATransitionSet)transition.getTransitionSet(), false, false);
            } else if (this.pruneUnambiguousPaths) {
                this.reScheduleFinalStateSuccessors(state, successorState);
            }
            if (this.pruneUnambiguousPaths && (state.isFinalState() || state.isFinalStateSuccessor())) {
                state.setFinalStateSuccessor();
                successorState.setFinalStateSuccessor();
            }
            transition.setTarget(successorState);
            successorState.updateFinalStateData(this);
            if (this.isGenericCG()) {
                transition.getTarget().addPrecedingTransition((DFACaptureGroupTransitionBuilder)transition);
            }
            if (!state.isFinalState() || successorState.isFinalState() || successorState.isAnchoredFinalState()) continue;
            this.simpleCGMustCopy = true;
        }
        state.setTransitions(transitions);
    }

    private DFAStateTransitionBuilder createTransitionBuilder(NFATransitionSet transitionSet) {
        return this.createTransitionBuilder(null, transitionSet);
    }

    private DFAStateTransitionBuilder createTransitionBuilder(CharSet matcherBuilder, NFATransitionSet transitionSet) {
        if (this.isGenericCG()) {
            return new DFACaptureGroupTransitionBuilder(matcherBuilder, transitionSet, this);
        }
        return new DFAStateTransitionBuilder(matcherBuilder, transitionSet);
    }

    private NFATransitionSet createNFATransitionSet(NFAStateTransition initialTransition) {
        if (this.isForward()) {
            return PrioritySensitiveNFATransitionSet.create(this.nfa, true, initialTransition);
        }
        return NFATransitionSet.create(this.nfa, false, initialTransition);
    }

    private boolean tryPruneTraceFinderState(DFAStateNodeBuilder state) {
        assert (this.nfa.isTraceFinderNFA());
        if (state.isFinalStateSuccessor()) {
            return false;
        }
        PreCalculatedResultFactory result = null;
        int resultIndex = -1;
        assert (!state.getNfaTransitionSet().isEmpty());
        for (NFAStateTransition transition : state.getNfaTransitionSet()) {
            NFAState nfaState = transition.getTarget(this.isForward());
            for (int i : nfaState.getPossibleResults()) {
                if (result == null) {
                    result = this.nfa.getPreCalculatedResults()[i];
                    resultIndex = (byte)i;
                    continue;
                }
                if (result == this.nfa.getPreCalculatedResults()[i]) continue;
                return false;
            }
        }
        if (resultIndex >= 0) {
            state.setOverrideFinalState(true);
            state.updatePreCalcUnAnchoredResult(resultIndex);
            state.setTransitions(EMPTY_TRANSITIONS_ARRAY);
            return true;
        }
        return false;
    }

    private void reScheduleFinalStateSuccessors(DFAStateNodeBuilder state, DFAStateNodeBuilder successorState) {
        assert (this.nfa.isTraceFinderNFA());
        if ((state.isFinalState() || state.isFinalStateSuccessor()) && !successorState.isFinalStateSuccessor()) {
            this.reScheduleFinalStateSuccessor(successorState);
            this.bfsTraversalCur.clear();
            if (successorState.getTransitions() != null) {
                this.bfsTraversalCur.add(successorState.getTransitions());
            }
            while (!this.bfsTraversalCur.isEmpty()) {
                this.bfsTraversalNext.clear();
                for (DFAStateTransitionBuilder[] cur : this.bfsTraversalCur) {
                    for (DFAStateTransitionBuilder t : cur) {
                        if (t.getTarget().isFinalStateSuccessor()) continue;
                        this.bfsExpand(t.getTarget());
                        this.reScheduleFinalStateSuccessor(t.getTarget());
                    }
                }
                this.bfsSwapLists();
            }
        }
    }

    private void reScheduleFinalStateSuccessor(DFAStateNodeBuilder finalStateSuccessor) {
        finalStateSuccessor.setFinalStateSuccessor();
        finalStateSuccessor.setOverrideFinalState(false);
        finalStateSuccessor.clearPreCalculatedResults();
        finalStateSuccessor.updateFinalStateData(this);
        this.expansionQueue.push(finalStateSuccessor);
    }

    private DFAStateNodeBuilder lookupState(NFATransitionSet transitionSet, boolean isBackWardPrefixState) {
        this.lookupDummyState.setNfaTransitionSet(transitionSet);
        this.lookupDummyState.setIsBackwardPrefixState(isBackWardPrefixState);
        return this.stateMap.get(this.lookupDummyState);
    }

    private DFAStateNodeBuilder createState(NFATransitionSet transitionSet, boolean isBackwardPrefixState, boolean isInitialState) {
        assert (this.stateIndexMap == null) : "state index map created before dfa generation!";
        short s = this.nextID;
        this.nextID = (short)(s + 1);
        DFAStateNodeBuilder dfaState = new DFAStateNodeBuilder(s, transitionSet, isBackwardPrefixState, isInitialState);
        this.stateMap.put(dfaState, dfaState);
        if (this.stateMap.size() + (this.isForward() ? this.expansionQueue.size() : 0) > 2400) {
            throw new UnsupportedRegexException((this.isForward() ? (this.isGenericCG() ? "CG" : "Forward") : "Backward") + " DFA explosion");
        }
        if (!this.hasAmbiguousStates && (transitionSet.size() > 2 || transitionSet.size() == 2 && transitionSet.getTransition(1) != this.nfa.getInitialLoopBackTransition())) {
            this.hasAmbiguousStates = true;
        }
        this.expansionQueue.push(dfaState);
        return dfaState;
    }

    private void optimizeDFA() {
        RegexProperties props = this.nfa.getAst().getProperties();
        boolean bl = this.doSimpleCG = !(!this.executorProps.isAllowSimpleCG() || this.hasAmbiguousStates || this.nfa.isTraceFinderNFA() || this.isGenericCG() || !this.isSearching() && !props.hasCaptureGroups() || !props.hasAlternations() && !props.hasLookAroundAssertions());
        if (this.isForward() && this.isSearching() && !this.isGenericCG() && !this.nfa.getAst().getFlags().isSticky() && props.hasInnerLiteral()) {
            int literalEnd = props.getInnerLiteralEnd();
            int literalStart = props.getInnerLiteralStart();
            Sequence rootSeq = this.nfa.getAst().getRoot().getAlternatives().get(0);
            ASTNodeSet<RegexASTNode> prefixAstNodes = new ASTNodeSet<RegexASTNode>(this.nfa.getAst());
            for (int i = 0; i < literalStart; ++i) {
                AddToSetVisitor.addCharacterClasses(prefixAstNodes, rootSeq.getTerms().get(i));
            }
            NFAStateSet prefixNFAStates = new NFAStateSet(this.nfa);
            prefixNFAStates.add(this.nfa.getUnAnchoredInitialState());
            NFAState literalFirstState = null;
            NFAState literalLastState = null;
            for (NFAState s : this.nfa.getStates()) {
                if (s == null) continue;
                if (!s.getStateSet().isEmpty() && prefixAstNodes.containsAll(s.getStateSet())) {
                    prefixNFAStates.add(s);
                }
                if (s.getStateSet().contains(rootSeq.getTerms().get(literalStart))) {
                    if (literalFirstState != null) {
                        return;
                    }
                    literalFirstState = s;
                }
                if (!s.getStateSet().contains(rootSeq.getTerms().get(literalEnd - 1))) continue;
                if (literalLastState != null) {
                    return;
                }
                literalLastState = s;
            }
            assert (literalFirstState != null);
            assert (literalLastState != null);
            DFAStateNodeBuilder literalFirstDFAState = null;
            DFAStateNodeBuilder literalLastDFAState = null;
            DFAStateNodeBuilder unanchoredInitialState = this.entryStates[this.nfa.getAnchoredEntry().length];
            CompilationFinalBitSet visited = new CompilationFinalBitSet(this.nextID);
            visited.set(unanchoredInitialState.getId());
            this.bfsTraversalCur.clear();
            this.bfsTraversalCur.add(unanchoredInitialState.getTransitions());
            while (!this.bfsTraversalCur.isEmpty()) {
                this.bfsTraversalNext.clear();
                block3: for (DFAStateTransitionBuilder[] cur : this.bfsTraversalCur) {
                    for (DFAStateTransitionBuilder t : cur) {
                        DFAStateNodeBuilder target = t.getTarget();
                        if (visited.get(target.getId())) continue;
                        visited.set(target.getId());
                        NFAStateSet targetStateSet = target.getNfaTransitionSet().getTargetStateSet();
                        if (literalFirstDFAState == null && targetStateSet.contains(literalFirstState)) {
                            literalFirstDFAState = target;
                        }
                        if (targetStateSet.contains(literalLastState)) {
                            literalLastDFAState = target;
                            this.bfsTraversalNext.clear();
                            continue block3;
                        }
                        this.bfsExpand(target);
                    }
                }
                this.bfsSwapLists();
            }
            assert (literalFirstDFAState != null);
            assert (literalLastDFAState != null);
            TRegexDFAExecutorNode prefixMatcher = null;
            if (literalStart > 0) {
                if (rootSeq.getTerms().get(literalStart - 1).getMinPath() < rootSeq.getTerms().get(literalStart - 1).getMaxPath()) {
                    this.nfa.setInitialLoopBack(false);
                    if (this.innerLiteralMatchesPrefix(prefixNFAStates)) {
                        this.nfa.setInitialLoopBack(true);
                        return;
                    }
                    this.nfa.setInitialLoopBack(true);
                }
                RangesAccumulator<CharRangesBuffer> acc = new RangesAccumulator<CharRangesBuffer>(new CharRangesBuffer());
                for (DFAStateNodeBuilder s : this.stateMap.values()) {
                    acc.clear();
                    if (prefixNFAStates.containsAll(s.getNfaTransitionSet().getTargetStateSet())) continue;
                    TransitionBuilder mergedTransition = null;
                    AbstractArrayBuffer newTransitions = null;
                    for (int i = 0; i < s.getTransitions().length; ++i) {
                        DFAStateTransitionBuilder t = s.getTransitions()[i];
                        if (prefixNFAStates.containsAll(t.getTarget().getNfaTransitionSet().getTargetStateSet())) {
                            if (mergedTransition == null) {
                                t.setTarget(unanchoredInitialState);
                                mergedTransition = t;
                                continue;
                            }
                            if (newTransitions == null) {
                                newTransitions = this.compilationBuffer.getObjectBuffer1();
                                ((ObjectArrayBuffer)newTransitions).addAll(s.getTransitions(), 0, i);
                                acc.addSet(mergedTransition.getMatcherBuilder());
                                acc.addSet(t.getMatcherBuilder());
                                continue;
                            }
                            acc.addSet(t.getMatcherBuilder());
                            continue;
                        }
                        if (newTransitions == null) continue;
                        ((ObjectArrayBuffer)newTransitions).add(t);
                    }
                    if (newTransitions == null || mergedTransition == null) continue;
                    mergedTransition.setMatcherBuilder(CharSet.create(acc.get()));
                    s.setTransitions(((ObjectArrayBuffer)newTransitions).toArray(new DFAStateTransitionBuilder[newTransitions.length()]));
                    Arrays.sort(s.getTransitions(), Comparator.comparing(TransitionBuilder::getMatcherBuilder));
                }
                this.nfa.setInitialLoopBack(false);
                NFAState reverseAnchoredInitialState = this.nfa.getReverseAnchoredEntry().getSource();
                NFAState reverseUnAnchoredInitialState = this.nfa.getReverseUnAnchoredEntry().getSource();
                this.nfa.getReverseAnchoredEntry().setSource(literalFirstState);
                this.nfa.getReverseUnAnchoredEntry().setSource(literalFirstState);
                prefixMatcher = this.compilationReqest.createDFAExecutor(this.nfa, new TRegexDFAExecutorProperties(false, false, false, this.doSimpleCG, this.getOptions().isRegressionTestMode(), this.nfa.getAst().getNumberOfCaptureGroups(), rootSeq.getTerms().get(literalStart - 1).getMinPath()), "innerLiteralPrefix");
                prefixMatcher.setRoot(this.compilationReqest.getRoot());
                prefixMatcher.getProperties().setSimpleCGMustCopy(false);
                this.doSimpleCG = this.doSimpleCG && prefixMatcher.isSimpleCG();
                this.nfa.setInitialLoopBack(true);
                this.nfa.getReverseAnchoredEntry().setSource(reverseAnchoredInitialState);
                this.nfa.getReverseUnAnchoredEntry().setSource(reverseUnAnchoredInitialState);
            }
            CharRangesBuffer literal = this.compilationBuffer.getCharRangesBuffer1();
            CharRangesBuffer mask = this.compilationBuffer.getCharRangesBuffer2();
            literal.ensureCapacity(literalEnd - literalStart);
            mask.ensureCapacity(literalEnd - literalStart);
            boolean hasMask = false;
            for (int i = literalStart; i < literalEnd; ++i) {
                CharacterClass cc = (CharacterClass)rootSeq.getTerms().get(i);
                assert (cc.getCharSet().matchesSingleChar() || cc.getCharSet().matches2CharsWith1BitDifference());
                cc.extractSingleChar(literal, mask);
                hasMask |= cc.getCharSet().matches2CharsWith1BitDifference();
            }
            this.registerStateReplacement(unanchoredInitialState.getId(), new DFAFindInnerLiteralStateNode(unanchoredInitialState.getId(), new short[]{literalLastDFAState.getId()}, new String(literal.toArray()), hasMask ? new String(mask.toArray()) : null, prefixMatcher));
        }
    }

    private boolean innerLiteralMatchesPrefix(NFAStateSet prefixNFAStates) {
        int literalEnd = this.nfa.getAst().getProperties().getInnerLiteralEnd();
        int literalStart = this.nfa.getAst().getProperties().getInnerLiteralStart();
        Sequence rootSeq = this.nfa.getAst().getRoot().getAlternatives().get(0);
        NFAStateSet curState = this.entryStates[0].getNfaTransitionSet().getTargetStateSet().copy();
        NFAStateSet nextState = new NFAStateSet(this.nfa);
        for (int i = literalStart; i < literalEnd; ++i) {
            CharSet c = ((CharacterClass)rootSeq.getTerms().get(i)).getCharSet();
            for (NFAState s : curState) {
                for (NFAStateTransition t : s.getNext()) {
                    if (i == literalStart && !prefixNFAStates.contains(t.getTarget()) || !c.intersects(t.getTarget().getCharSet())) continue;
                    nextState.add(t.getTarget());
                }
            }
            if (nextState.isEmpty()) {
                return false;
            }
            NFAStateSet tmp = curState;
            curState = nextState;
            nextState = tmp;
            nextState.clear();
        }
        return true;
    }

    private void registerStateReplacement(short id, DFAAbstractStateNode replacement) {
        if (this.stateReplacements == null) {
            this.stateReplacements = EconomicMap.create();
        }
        this.stateReplacements.put((Object)id, (Object)replacement);
    }

    private DFAAbstractStateNode getReplacement(short id) {
        return this.stateReplacements == null ? null : (DFAAbstractStateNode)this.stateReplacements.get((Object)id);
    }

    private DFAAbstractStateNode[] createDFAExecutorStates() {
        DFAAbstractStateNode[] ret = new DFAAbstractStateNode[this.stateMap.values().size() + 1];
        for (DFAStateNodeBuilder s : this.stateMap.values()) {
            boolean useTreeTransitionMatcher;
            DFAAbstractStateNode replacement = this.getReplacement(s.getId());
            if (replacement != null) {
                ret[s.getId()] = replacement;
                continue;
            }
            CharMatcher[] matchers = s.getTransitions().length > 0 ? new CharMatcher[s.getTransitions().length] : CharMatcher.EMPTY;
            DFASimpleCGTransition[] simpleCGTransitions = this.doSimpleCG ? new DFASimpleCGTransition[matchers.length] : null;
            int nRanges = 0;
            int estimatedTransitionsCost = 0;
            boolean coversCharSpace = s.coversFullCharSpace(this.compilationBuffer);
            for (int i = 0; i < matchers.length; ++i) {
                DFAStateTransitionBuilder t = s.getTransitions()[i];
                CharSet matcherBuilder = t.getMatcherBuilder();
                if (i == matchers.length - 1 && (coversCharSpace || this.pruneUnambiguousPaths && !s.isFinalStateSuccessor())) {
                    matchers[i] = AnyMatcher.create();
                } else {
                    nRanges += matcherBuilder.size();
                    matchers[i] = matcherBuilder.createMatcher(this.compilationBuffer);
                }
                estimatedTransitionsCost += matchers[i].estimatedCost();
                if (!this.doSimpleCG) continue;
                assert (((NFATransitionSet)t.getTransitionSet()).size() <= 2);
                assert (((NFATransitionSet)t.getTransitionSet()).size() == 1 || ((NFATransitionSet)t.getTransitionSet()).getTransition(0) != this.nfa.getInitialLoopBackTransition());
                simpleCGTransitions[i] = this.createSimpleCGTransition(((NFATransitionSet)t.getTransitionSet()).getTransition(0));
            }
            AllTransitionsInOneTreeMatcher allTransitionsInOneTreeMatcher = null;
            boolean bl = useTreeTransitionMatcher = nRanges > 1 && MathUtil.log2ceil(nRanges + 2) * 8 < estimatedTransitionsCost;
            if (useTreeTransitionMatcher) {
                if (!this.getOptions().isRegressionTestMode()) {
                    matchers = null;
                }
                allTransitionsInOneTreeMatcher = this.createAllTransitionsInOneTreeMatcher(s);
            }
            short[] successors = s.getNumberOfSuccessors() > 0 ? new short[s.getNumberOfSuccessors()] : EMPTY_SHORT_ARRAY;
            short[] cgTransitions = null;
            short[] cgPrecedingTransitions = null;
            if (this.isGenericCG()) {
                cgTransitions = new short[s.getTransitions().length];
                List<DFACaptureGroupTransitionBuilder> precedingTransitions = s.getPrecedingTransitions();
                assert (!precedingTransitions.isEmpty());
                cgPrecedingTransitions = new short[precedingTransitions.size()];
                for (int i = 0; i < precedingTransitions.size(); ++i) {
                    DFACaptureGroupTransitionBuilder transitionBuilder = precedingTransitions.get(i);
                    cgPrecedingTransitions[i] = transitionBuilder.toLazyTransition(this.compilationBuffer).getId();
                }
            }
            char[] indexOfChars = null;
            short loopToSelf = -1;
            for (int i = 0; i < successors.length - (s.hasBackwardPrefixState() ? 1 : 0); ++i) {
                successors[i] = s.getTransitions()[i].getTarget().getId();
                if (successors[i] == s.getId()) {
                    loopToSelf = (short)i;
                    CharSet loopMB = s.getTransitions()[i].getMatcherBuilder();
                    if (coversCharSpace && !loopMB.matchesEverything() && loopMB.inverseValueCount() <= 4) {
                        indexOfChars = loopMB.inverseToCharArray();
                    }
                }
                assert (successors[i] >= 0 && successors[i] < ret.length);
                if (!this.isGenericCG()) continue;
                DFACaptureGroupLazyTransition transition = ((DFACaptureGroupTransitionBuilder)s.getTransitions()[i]).toLazyTransition(this.compilationBuffer);
                cgTransitions[i] = transition.getId();
                this.registerCGTransition(transition);
            }
            if (s.hasBackwardPrefixState()) {
                successors[successors.length - 1] = s.getBackwardPrefixState();
            }
            byte flags = DFAStateNode.buildFlags(s.isFinalState(), s.isAnchoredFinalState(), s.hasBackwardPrefixState());
            DFAStateNode.LoopOptimizationNode loopOptimizationNode = null;
            if (loopToSelf != -1) {
                loopOptimizationNode = DFAStateNode.buildLoopOptimizationNode(loopToSelf, indexOfChars);
            }
            DFASimpleCG simpleCG = null;
            if (this.doSimpleCG) {
                simpleCG = DFASimpleCG.create(simpleCGTransitions, this.createSimpleCGTransition(s.getUnAnchoredFinalStateTransition()), this.createSimpleCGTransition(s.getAnchoredFinalStateTransition()));
            }
            DFAStateNode stateNode = this.isGenericCG() ? new CGTrackingDFAStateNode(s.getId(), flags, loopOptimizationNode, successors, matchers, allTransitionsInOneTreeMatcher, cgTransitions, cgPrecedingTransitions, this.createCGFinalTransition(s.getAnchoredFinalStateTransition()), this.createCGFinalTransition(s.getUnAnchoredFinalStateTransition())) : (this.nfa.isTraceFinderNFA() ? new TraceFinderDFAStateNode(s.getId(), flags, loopOptimizationNode, successors, matchers, allTransitionsInOneTreeMatcher, s.getPreCalculatedUnAnchoredResult(), s.getPreCalculatedAnchoredResult()) : (this.isForward() ? new DFAStateNode(s.getId(), flags, loopOptimizationNode, successors, matchers, simpleCG, allTransitionsInOneTreeMatcher) : new BackwardDFAStateNode(s.getId(), flags, loopOptimizationNode, successors, matchers, simpleCG, allTransitionsInOneTreeMatcher)));
            ret[s.getId()] = stateNode;
        }
        return ret;
    }

    private DFASimpleCGTransition createSimpleCGTransition(NFAStateTransition nfaTransition) {
        return DFASimpleCGTransition.create(nfaTransition, this.isForward() && nfaTransition != null && nfaTransition.getSource() == this.nfa.getInitialLoopBackTransition().getSource());
    }

    private AllTransitionsInOneTreeMatcher createAllTransitionsInOneTreeMatcher(DFAStateNodeBuilder state) {
        DFAStateTransitionBuilder[] transitions = state.getTransitions();
        CharRangesBuffer sortedRangesBuf = this.compilationBuffer.getCharRangesBuffer1();
        ShortArrayBuffer rangeTreeSuccessorsBuf = this.compilationBuffer.getShortArrayBuffer();
        int[] matcherIndices = new int[transitions.length];
        boolean rangesLeft = false;
        for (int i = 0; i < transitions.length; ++i) {
            matcherIndices[i] = 0;
            rangesLeft |= matcherIndices[i] < transitions[i].getMatcherBuilder().size();
        }
        int lastHi = 0;
        while (rangesLeft) {
            int minLo = Integer.MAX_VALUE;
            int minMb = -1;
            for (int i = 0; i < transitions.length; ++i) {
                CharSet mb = transitions[i].getMatcherBuilder();
                if (matcherIndices[i] >= mb.size() || mb.getLo(matcherIndices[i]) >= minLo) continue;
                minLo = mb.getLo(matcherIndices[i]);
                minMb = i;
            }
            if (minMb == -1) break;
            if (minLo != lastHi) {
                rangeTreeSuccessorsBuf.add((short)-1);
                sortedRangesBuf.add((char)minLo);
            }
            rangeTreeSuccessorsBuf.add((short)minMb);
            lastHi = transitions[minMb].getMatcherBuilder().getHi(matcherIndices[minMb]) + 1;
            if (lastHi <= 65535) {
                sortedRangesBuf.add((char)lastHi);
            }
            int n = minMb;
            matcherIndices[n] = matcherIndices[n] + 1;
        }
        if (lastHi != 65536) {
            rangeTreeSuccessorsBuf.add((short)-1);
        }
        return new AllTransitionsInOneTreeMatcher(sortedRangesBuf.toArray(), rangeTreeSuccessorsBuf.toArray());
    }

    private void registerCGTransition(DFACaptureGroupLazyTransition cgTransition) {
        assert (this.captureGroupTransitions[cgTransition.getId()] == null);
        this.captureGroupTransitions[cgTransition.getId()] = cgTransition;
    }

    private DFACaptureGroupPartialTransition createCGFinalTransition(NFAStateTransition transition) {
        if (transition == null) {
            return null;
        }
        GroupBoundaries groupBoundaries = transition.getGroupBoundaries();
        Object indexUpdates = DFACaptureGroupPartialTransition.EMPTY_INDEX_UPDATES;
        Object indexClears = DFACaptureGroupPartialTransition.EMPTY_INDEX_CLEARS;
        if (groupBoundaries.hasIndexUpdates()) {
            indexUpdates = new byte[][]{groupBoundaries.updatesToPartialTransitionArray(0)};
        }
        if (groupBoundaries.hasIndexClears()) {
            indexClears = new byte[][]{groupBoundaries.clearsToPartialTransitionArray(0)};
        }
        DFACaptureGroupPartialTransition partialTransitionNode = DFACaptureGroupPartialTransition.create(this, DFACaptureGroupPartialTransition.EMPTY_REORDER_SWAPS, DFACaptureGroupPartialTransition.EMPTY_ARRAY_COPIES, indexUpdates, indexClears, (byte)0);
        if (this.debugMode()) {
            DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo debugInfo = new DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo(partialTransitionNode, 1);
            debugInfo.mapResultToNFATransition(0, transition);
            this.registerCGPartialTransitionDebugInfo(debugInfo);
        }
        return partialTransitionNode;
    }

    void updateMaxNumberOfNFAStatesInOneTransition(int value) {
        if (value > this.maxNumberOfNfaStates) {
            this.maxNumberOfNfaStates = value;
            if (this.maxNumberOfNfaStates > 255) {
                throw new UnsupportedRegexException("DFA transition size explosion");
            }
        }
    }

    private DFAAbstractStateNode[] tryMakeReducible(DFAAbstractStateNode[] states) {
        try {
            if (this.debugMode()) {
                return DFANodeSplit.createReducibleGraphAndUpdateDFAGen(this, states);
            }
            return DFANodeSplit.createReducibleGraph(states);
        }
        catch (DFANodeSplitBailoutException e) {
            return states;
        }
    }

    private boolean debugMode() {
        return this.engineOptions.isDumpAutomata() || this.engineOptions.isStepExecution();
    }

    public String getDebugDumpName(String name) {
        return name == null ? this.getDebugDumpName() : name;
    }

    public String getDebugDumpName() {
        if (this.isForward()) {
            if (this.isGenericCG()) {
                if (this.isSearching()) {
                    return "eagerCG";
                }
                return "lazyCG";
            }
            return "forward";
        }
        if (this.nfa.isTraceFinderNFA()) {
            return "traceFinder";
        }
        return "backward";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        if (this.isForward()) {
            this.nfa.setInitialLoopBack(this.isSearching() && !this.nfa.getAst().getFlags().isSticky());
        }
        DFAStateTransitionBuilder[] transitionList = new DFAStateTransitionBuilder[this.transitionIDCounter.getCount()];
        for (DFAStateNodeBuilder s : this.getStateIndexMap()) {
            if (s == null) continue;
            DFAStateTransitionBuilder[] dFAStateTransitionBuilderArray = s.getTransitions();
            int n = dFAStateTransitionBuilderArray.length;
            for (int i = 0; i < n; ++i) {
                DFAStateTransitionBuilder t;
                transitionList[t.getId()] = t = dFAStateTransitionBuilderArray[i];
            }
        }
        return Json.obj(Json.prop("pattern", this.nfa.getAst().getSource().toString()), Json.prop("nfa", this.nfa.toJson(this.isForward())), Json.prop("dfa", Json.obj(Json.prop("states", Arrays.stream(this.getStateIndexMap())), Json.prop("transitions", Arrays.stream(transitionList)), Json.prop("captureGroupPartialTransitions", this.cgPartialTransitions), Json.prop("entryStates", Arrays.stream(this.entryStates).filter(Objects::nonNull).map(x -> Json.val(x.getId()))))));
    }
}

