/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.buffer;

import com.oracle.truffle.regex.tregex.buffer.AbstractArrayBuffer;
import java.util.Arrays;
import java.util.Iterator;

public final class ObjectArrayBuffer
extends AbstractArrayBuffer
implements Iterable<Object> {
    private Object[] buf;

    public ObjectArrayBuffer() {
        this(16);
    }

    public ObjectArrayBuffer(int initialSize) {
        this.buf = new Object[initialSize];
    }

    @Override
    int getBufferLength() {
        return this.buf.length;
    }

    @Override
    void grow(int newSize) {
        this.buf = Arrays.copyOf(this.buf, newSize);
    }

    public Object get(int i) {
        return this.buf[i];
    }

    public Object getLast() {
        return this.buf[this.length() - 1];
    }

    public void add(Object o) {
        if (this.length == this.buf.length) {
            this.grow(this.length * 2);
        }
        this.buf[this.length] = o;
        ++this.length;
    }

    public void addAll(ObjectArrayBuffer other) {
        this.addAll(other.buf, 0, other.length);
    }

    public void addAll(Object[] arr, int fromIndex, int toIndex) {
        int len = toIndex - fromIndex;
        this.ensureCapacity(this.length + len);
        System.arraycopy(arr, fromIndex, this.buf, this.length, len);
        this.length += len;
    }

    public Object pop() {
        return this.buf[--this.length];
    }

    public Object peek() {
        return this.buf[this.length - 1];
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.length) {
            return Arrays.copyOf(this.buf, this.length, a.getClass());
        }
        System.arraycopy(this.buf, 0, a, 0, this.length);
        return a;
    }

    @Override
    public Iterator<Object> iterator() {
        return new ObjectBufferIterator(this.buf, this.length);
    }

    private static final class ObjectBufferIterator
    implements Iterator<Object> {
        private final Object[] buf;
        private final int size;
        private int i = 0;

        private ObjectBufferIterator(Object[] buf, int size) {
            this.buf = buf;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public Object next() {
            return this.buf[this.i++];
        }
    }
}

