// CheckStyle: start generated
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.matchers.ProfilingCharMatcher;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ProfilingCharMatcher.class)
public final class ProfilingCharMatcherNodeGen extends ProfilingCharMatcher {

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;

    private ProfilingCharMatcherNodeGen(CharMatcher byteMatcher, CharMatcher charMatcher) {
        super(byteMatcher, charMatcher);
    }

    @Override
    public boolean execute(char arg0Value, boolean arg1Value) {
        int state = state_;
        if (state != 0 /* is-active matchCompactString(char, boolean) || matchByte(char, boolean) || matchChar(char, boolean) */) {
            if ((state & 0b1) != 0 /* is-active matchCompactString(char, boolean) */) {
                if ((arg1Value)) {
                    return matchCompactString(arg0Value, arg1Value);
                }
            }
            if ((state & 0b10) != 0 /* is-active matchByte(char, boolean) */) {
                if ((!(arg1Value)) && (ProfilingCharMatcher.isByte(arg0Value))) {
                    return matchByte(arg0Value, arg1Value);
                }
            }
            if ((state & 0b100) != 0 /* is-active matchChar(char, boolean) */) {
                if ((!(arg1Value))) {
                    return matchChar(arg0Value, arg1Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private boolean executeAndSpecialize(char arg0Value, boolean arg1Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if ((arg1Value)) {
                this.state_ = state = state | 0b1 /* add-active matchCompactString(char, boolean) */;
                lock.unlock();
                hasLock = false;
                return matchCompactString(arg0Value, arg1Value);
            }
            if ((exclude) == 0 /* is-not-excluded matchByte(char, boolean) */) {
                if ((!(arg1Value)) && (ProfilingCharMatcher.isByte(arg0Value))) {
                    this.state_ = state = state | 0b10 /* add-active matchByte(char, boolean) */;
                    lock.unlock();
                    hasLock = false;
                    return matchByte(arg0Value, arg1Value);
                }
            }
            if ((!(arg1Value))) {
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded matchByte(char, boolean) */;
                state = state & 0xfffffffd /* remove-active matchByte(char, boolean) */;
                this.state_ = state = state | 0b100 /* add-active matchChar(char, boolean) */;
                lock.unlock();
                hasLock = false;
                return matchChar(arg0Value, arg1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ProfilingCharMatcher create(CharMatcher byteMatcher, CharMatcher charMatcher) {
        return new ProfilingCharMatcherNodeGen(byteMatcher, charMatcher);
    }

}
