// CheckStyle: start generated
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.regex.runtime.nodes.ToCharNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ToCharNode.class)
public final class ToCharNodeGen extends ToCharNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private Long0Data long0_cache;

    private ToCharNodeGen() {
    }

    @ExplodeLoop
    @Override
    public char execute(Object arg0Value) throws UnsupportedTypeException {
        int state = state_;
        if ((state & 0b1) != 0 /* is-active doByte(byte) */ && arg0Value instanceof Byte) {
            byte arg0Value_ = (byte) arg0Value;
            return ToCharNode.doByte(arg0Value_);
        }
        if ((state & 0b10) != 0 /* is-active doChar(char) */ && arg0Value instanceof Character) {
            char arg0Value_ = (char) arg0Value;
            return ToCharNode.doChar(arg0Value_);
        }
        if ((state & 0b1100) != 0 /* is-active doLong(Object, InteropLibrary) || doLong(Object, InteropLibrary) */) {
            if ((state & 0b100) != 0 /* is-active doLong(Object, InteropLibrary) */) {
                Long0Data s3_ = this.long0_cache;
                while (s3_ != null) {
                    if ((s3_.args_.accepts(arg0Value)) && (s3_.args_.fitsInInt(arg0Value))) {
                        return ToCharNode.doLong(arg0Value, s3_.args_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 0b1000) != 0 /* is-active doLong(Object, InteropLibrary) */) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    if (((INTEROP_LIBRARY_.getUncached(arg0Value)).fitsInInt(arg0Value))) {
                        return ToCharNode.doLong(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
                    }
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private char executeAndSpecialize(Object arg0Value) throws UnsupportedTypeException {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                this.state_ = state = state | 0b1 /* add-active doByte(byte) */;
                lock.unlock();
                hasLock = false;
                return ToCharNode.doByte(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                this.state_ = state = state | 0b10 /* add-active doChar(char) */;
                lock.unlock();
                hasLock = false;
                return ToCharNode.doChar(arg0Value_);
            }
            if ((exclude) == 0 /* is-not-excluded doLong(Object, InteropLibrary) */) {
                int count3_ = 0;
                Long0Data s3_ = this.long0_cache;
                if ((state & 0b100) != 0 /* is-active doLong(Object, InteropLibrary) */) {
                    while (s3_ != null) {
                        if ((s3_.args_.accepts(arg0Value)) && (s3_.args_.fitsInInt(arg0Value))) {
                            break;
                        }
                        s3_ = s3_.next_;
                        count3_++;
                    }
                }
                if (s3_ == null) {
                    {
                        InteropLibrary args__ = super.insert((INTEROP_LIBRARY_.create(arg0Value)));
                        // assert (s3_.args_.accepts(arg0Value));
                        if ((args__.fitsInInt(arg0Value)) && count3_ < (2)) {
                            s3_ = super.insert(new Long0Data(long0_cache));
                            s3_.args_ = s3_.insertAccessor(args__);
                            this.long0_cache = s3_;
                            this.state_ = state = state | 0b100 /* add-active doLong(Object, InteropLibrary) */;
                        }
                    }
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return ToCharNode.doLong(arg0Value, s3_.args_);
                }
            }
            {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    {
                        InteropLibrary long1_args__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                        if ((long1_args__.fitsInInt(arg0Value))) {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doLong(Object, InteropLibrary) */;
                            this.long0_cache = null;
                            state = state & 0xfffffffb /* remove-active doLong(Object, InteropLibrary) */;
                            this.state_ = state = state | 0b1000 /* add-active doLong(Object, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return ToCharNode.doLong(arg0Value, long1_args__);
                        }
                    }
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            Long0Data s3_ = this.long0_cache;
            if ((s3_ == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToCharNode create() {
        return new ToCharNodeGen();
    }

    public static ToCharNode getUncached() {
        return ToCharNodeGen.UNCACHED;
    }

    @GeneratedBy(ToCharNode.class)
    private static final class Long0Data extends Node {

        @Child Long0Data next_;
        @Child InteropLibrary args_;

        Long0Data(Long0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(ToCharNode.class)
    private static final class Uncached extends ToCharNode {

        @TruffleBoundary
        @Override
        public char execute(Object arg0Value) throws UnsupportedTypeException {
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return ToCharNode.doByte(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return ToCharNode.doChar(arg0Value_);
            }
            if (((INTEROP_LIBRARY_.getUncached(arg0Value)).fitsInInt(arg0Value))) {
                return ToCharNode.doLong(arg0Value, (INTEROP_LIBRARY_.getUncached(arg0Value)));
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
