// CheckStyle: start generated
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.regex.CompiledRegexObject;
import com.oracle.truffle.regex.RegexObject;
import com.oracle.truffle.regex.RegexObject.ExecCompiledRegexNode;
import com.oracle.truffle.regex.RegexObject.GetCompiledRegexNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(RegexObject.class)
public final class RegexObjectFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(GetCompiledRegexNode.class)
    static final class GetCompiledRegexNodeGen extends GetCompiledRegexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private ExecuteFixedData executeFixed_cache;

        private GetCompiledRegexNodeGen() {
        }

        @ExplodeLoop
        @Override
        Object execute(RegexObject arg0Value) {
            int state = state_;
            if (state != 0 /* is-active executeFixed(RegexObject, RegexObject, Object) || executeVarying(RegexObject) */) {
                if ((state & 0b1) != 0 /* is-active executeFixed(RegexObject, RegexObject, Object) */) {
                    ExecuteFixedData s1_ = this.executeFixed_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedReceiver_)) {
                            return GetCompiledRegexNode.executeFixed(arg0Value, s1_.cachedReceiver_, s1_.cachedCompiledRegex_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active executeVarying(RegexObject) */) {
                    return GetCompiledRegexNode.executeVarying(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(RegexObject arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            int oldState = state;
            int oldExclude = exclude;
            int oldCacheCount = state == 0 ? 0 : countCaches();
            try {
                if ((exclude) == 0 /* is-not-excluded executeFixed(RegexObject, RegexObject, Object) */) {
                    int count1_ = 0;
                    ExecuteFixedData s1_ = this.executeFixed_cache;
                    if ((state & 0b1) != 0 /* is-active executeFixed(RegexObject, RegexObject, Object) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedReceiver_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value == s1_.cachedReceiver_);
                        if (count1_ < (4)) {
                            s1_ = new ExecuteFixedData(executeFixed_cache);
                            s1_.cachedReceiver_ = (arg0Value);
                            s1_.cachedCompiledRegex_ = (arg0Value.getCompiledRegexObject());
                            this.executeFixed_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active executeFixed(RegexObject, RegexObject, Object) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return GetCompiledRegexNode.executeFixed(arg0Value, s1_.cachedReceiver_, s1_.cachedCompiledRegex_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded executeFixed(RegexObject, RegexObject, Object) */;
                this.executeFixed_cache = null;
                state = state & 0xfffffffe /* remove-active executeFixed(RegexObject, RegexObject, Object) */;
                this.state_ = state = state | 0b10 /* add-active executeVarying(RegexObject) */;
                lock.unlock();
                hasLock = false;
                return GetCompiledRegexNode.executeVarying(arg0Value);
            } finally {
                if (oldState != 0 || oldExclude != 0) {
                    checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
            int newState = this.state_;
            int newExclude = this.exclude_;
            if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            ExecuteFixedData s1_ = this.executeFixed_cache;
            while (s1_ != null) {
                cacheCount++;
                s1_= s1_.next_;
            }
            return cacheCount;
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                ExecuteFixedData s1_ = this.executeFixed_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static GetCompiledRegexNode create() {
            return new GetCompiledRegexNodeGen();
        }

        public static GetCompiledRegexNode getUncached() {
            return GetCompiledRegexNodeGen.UNCACHED;
        }

        @GeneratedBy(GetCompiledRegexNode.class)
        private static final class ExecuteFixedData {

            @CompilationFinal ExecuteFixedData next_;
            @CompilationFinal RegexObject cachedReceiver_;
            @CompilationFinal Object cachedCompiledRegex_;

            ExecuteFixedData(ExecuteFixedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(GetCompiledRegexNode.class)
        private static final class Uncached extends GetCompiledRegexNode {

            @TruffleBoundary
            @Override
            Object execute(RegexObject arg0Value) {
                return GetCompiledRegexNode.executeVarying(arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ExecCompiledRegexNode.class)
    static final class ExecCompiledRegexNodeGen extends ExecCompiledRegexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private ExecuteTRegexFixedData executeTRegexFixed_cache;
        @Child private IndirectCallNode executeTRegexVarying_indirectCallNode_;
        @Child private ExecuteForeign0Data executeForeign0_cache;

        private ExecCompiledRegexNodeGen() {
        }

        @ExplodeLoop
        @Override
        Object execute(Object arg0Value, Object arg1Value, int arg2Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
            int state = state_;
            if (state != 0 /* is-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) || executeTRegexVarying(CompiledRegexObject, Object, int, IndirectCallNode) || executeForeign(TruffleObject, Object, int, InteropLibrary) || executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                if ((state & 0b11) != 0 /* is-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) || executeTRegexVarying(CompiledRegexObject, Object, int, IndirectCallNode) */ && arg0Value instanceof CompiledRegexObject) {
                    CompiledRegexObject arg0Value_ = (CompiledRegexObject) arg0Value;
                    if ((state & 0b1) != 0 /* is-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */) {
                        ExecuteTRegexFixedData s1_ = this.executeTRegexFixed_cache;
                        while (s1_ != null) {
                            if ((arg0Value_ == s1_.cachedReceiver_)) {
                                return ExecCompiledRegexNode.executeTRegexFixed(arg0Value_, arg1Value, arg2Value, s1_.cachedReceiver_, s1_.directCallNode_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active executeTRegexVarying(CompiledRegexObject, Object, int, IndirectCallNode) */) {
                        return ExecCompiledRegexNode.executeTRegexVarying(arg0Value_, arg1Value, arg2Value, this.executeTRegexVarying_indirectCallNode_);
                    }
                }
                if ((state & 0b1100) != 0 /* is-active executeForeign(TruffleObject, Object, int, InteropLibrary) || executeForeign(TruffleObject, Object, int, InteropLibrary) */ && arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    if ((state & 0b100) != 0 /* is-active executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                        ExecuteForeign0Data s3_ = this.executeForeign0_cache;
                        while (s3_ != null) {
                            if ((s3_.receivers_.accepts(arg0Value_)) && (s3_.receivers_.isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                                return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, s3_.receivers_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            if (((INTEROP_LIBRARY_.getUncached(arg0Value_)).isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                                return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg0Value_)));
                            }
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Object arg0Value, Object arg1Value, int arg2Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            int oldState = state;
            int oldExclude = exclude;
            int oldCacheCount = state == 0 ? 0 : countCaches();
            try {
                if (arg0Value instanceof CompiledRegexObject) {
                    CompiledRegexObject arg0Value_ = (CompiledRegexObject) arg0Value;
                    if (((exclude & 0b1)) == 0 /* is-not-excluded executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */) {
                        int count1_ = 0;
                        ExecuteTRegexFixedData s1_ = this.executeTRegexFixed_cache;
                        if ((state & 0b1) != 0 /* is-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */) {
                            while (s1_ != null) {
                                if ((arg0Value_ == s1_.cachedReceiver_)) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (arg0Value_ == s1_.cachedReceiver_);
                            if (count1_ < (4)) {
                                s1_ = super.insert(new ExecuteTRegexFixedData(executeTRegexFixed_cache));
                                s1_.cachedReceiver_ = (arg0Value_);
                                s1_.directCallNode_ = s1_.insertAccessor((DirectCallNode.create(s1_.cachedReceiver_.getCallTarget())));
                                this.executeTRegexFixed_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return ExecCompiledRegexNode.executeTRegexFixed(arg0Value_, arg1Value, arg2Value, s1_.cachedReceiver_, s1_.directCallNode_);
                        }
                    }
                    this.executeTRegexVarying_indirectCallNode_ = super.insert((IndirectCallNode.create()));
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */;
                    this.executeTRegexFixed_cache = null;
                    state = state & 0xfffffffe /* remove-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */;
                    this.state_ = state = state | 0b10 /* add-active executeTRegexVarying(CompiledRegexObject, Object, int, IndirectCallNode) */;
                    lock.unlock();
                    hasLock = false;
                    return ExecCompiledRegexNode.executeTRegexVarying(arg0Value_, arg1Value, arg2Value, this.executeTRegexVarying_indirectCallNode_);
                }
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    if (((exclude & 0b10)) == 0 /* is-not-excluded executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                        int count3_ = 0;
                        ExecuteForeign0Data s3_ = this.executeForeign0_cache;
                        if ((state & 0b100) != 0 /* is-active executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                            while (s3_ != null) {
                                if ((s3_.receivers_.accepts(arg0Value_)) && (s3_.receivers_.isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                                    break;
                                }
                                s3_ = s3_.next_;
                                count3_++;
                            }
                        }
                        if (s3_ == null) {
                            {
                                InteropLibrary receivers__ = super.insert((INTEROP_LIBRARY_.create(arg0Value_)));
                                // assert (s3_.receivers_.accepts(arg0Value_));
                                if ((receivers__.isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC)) && count3_ < (4)) {
                                    s3_ = super.insert(new ExecuteForeign0Data(executeForeign0_cache));
                                    s3_.receivers_ = s3_.insertAccessor(receivers__);
                                    this.executeForeign0_cache = s3_;
                                    this.state_ = state = state | 0b100 /* add-active executeForeign(TruffleObject, Object, int, InteropLibrary) */;
                                }
                            }
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, s3_.receivers_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            {
                                InteropLibrary executeForeign1_receivers__ = (INTEROP_LIBRARY_.getUncached(arg0Value_));
                                if ((executeForeign1_receivers__.isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                                    this.exclude_ = exclude = exclude | 0b10 /* add-excluded executeForeign(TruffleObject, Object, int, InteropLibrary) */;
                                    this.executeForeign0_cache = null;
                                    state = state & 0xfffffffb /* remove-active executeForeign(TruffleObject, Object, int, InteropLibrary) */;
                                    this.state_ = state = state | 0b1000 /* add-active executeForeign(TruffleObject, Object, int, InteropLibrary) */;
                                    lock.unlock();
                                    hasLock = false;
                                    return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, executeForeign1_receivers__);
                                }
                            }
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (oldState != 0 || oldExclude != 0) {
                    checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
            int newState = this.state_;
            int newExclude = this.exclude_;
            if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            ExecuteTRegexFixedData s1_ = this.executeTRegexFixed_cache;
            while (s1_ != null) {
                cacheCount++;
                s1_= s1_.next_;
            }
            ExecuteForeign0Data s3_ = this.executeForeign0_cache;
            while (s3_ != null) {
                cacheCount++;
                s3_= s3_.next_;
            }
            return cacheCount;
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                ExecuteTRegexFixedData s1_ = this.executeTRegexFixed_cache;
                ExecuteForeign0Data s3_ = this.executeForeign0_cache;
                if ((s1_ == null || s1_.next_ == null) && (s3_ == null || s3_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ExecCompiledRegexNode create() {
            return new ExecCompiledRegexNodeGen();
        }

        public static ExecCompiledRegexNode getUncached() {
            return ExecCompiledRegexNodeGen.UNCACHED;
        }

        @GeneratedBy(ExecCompiledRegexNode.class)
        private static final class ExecuteTRegexFixedData extends Node {

            @Child ExecuteTRegexFixedData next_;
            @CompilationFinal CompiledRegexObject cachedReceiver_;
            @Child DirectCallNode directCallNode_;

            ExecuteTRegexFixedData(ExecuteTRegexFixedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ExecCompiledRegexNode.class)
        private static final class ExecuteForeign0Data extends Node {

            @Child ExecuteForeign0Data next_;
            @Child InteropLibrary receivers_;

            ExecuteForeign0Data(ExecuteForeign0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ExecCompiledRegexNode.class)
        private static final class Uncached extends ExecCompiledRegexNode {

            @TruffleBoundary
            @Override
            Object execute(Object arg0Value, Object arg1Value, int arg2Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
                if (arg0Value instanceof CompiledRegexObject) {
                    CompiledRegexObject arg0Value_ = (CompiledRegexObject) arg0Value;
                    return ExecCompiledRegexNode.executeTRegexVarying(arg0Value_, arg1Value, arg2Value, (IndirectCallNode.getUncached()));
                }
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    if (((INTEROP_LIBRARY_.getUncached(arg0Value_)).isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                        return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg0Value_)));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
