// CheckStyle: start generated
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.RegexEngine;
import com.oracle.truffle.regex.AbstractConstantKeysObject.IsReadableCacheNode;
import com.oracle.truffle.regex.AbstractConstantKeysObject.ReadCacheNode;
import com.oracle.truffle.regex.runtime.nodes.StringEqualsNode;
import com.oracle.truffle.regex.runtime.nodes.StringEqualsNodeGen;
import com.oracle.truffle.regex.runtime.nodes.ToStringNode;
import com.oracle.truffle.regex.runtime.nodes.ToStringNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(RegexEngine.class)
final class RegexEngineGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(RegexEngine.class, new InteropLibraryExports());
    }

    private RegexEngineGen() {
    }

    @GeneratedBy(RegexEngine.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, RegexEngine.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof RegexEngine;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof RegexEngine;
            return new Cached(receiver);
        }

        @GeneratedBy(RegexEngine.class)
        private static final class Cached extends InteropLibrary {

            private final Class<? extends RegexEngine> receiverClass_;
            @CompilationFinal private int state_;
            @CompilationFinal private ValueProfile receiverProfile;
            @Child private ToStringNode patternToStringNode;
            @Child private ToStringNode flagsToStringNode;
            @Child private StringEqualsNode isValidatePropNode;
            @Child private IsReadableCacheNode isMemberReadableNode__cache_;
            @Child private ReadCacheNode readMemberNode__readCache_;

            Cached(Object receiver) {
                this.receiverClass_ = ((RegexEngine) receiver).getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.regex.RegexEngine'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                AbstractConstantKeysObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b1) != 0 /* is-active isMemberReadable(AbstractConstantKeysObject, String, IsReadableCacheNode, ValueProfile) */) {
                    return arg0Value.isMemberReadable(arg1Value, this.isMemberReadableNode__cache_, this.receiverProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(AbstractConstantKeysObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.isMemberReadableNode__cache_ = super.insert((IsReadableCacheNode.create()));
                    if (this.receiverProfile == null) {
                        this.receiverProfile = (ValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b1 /* add-active isMemberReadable(AbstractConstantKeysObject, String, IsReadableCacheNode, ValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMemberReadable(arg1Value, this.isMemberReadableNode__cache_, this.receiverProfile);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                AbstractConstantKeysObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b10) != 0 /* is-active readMember(AbstractConstantKeysObject, String, ReadCacheNode, ValueProfile) */) {
                    return arg0Value.readMember(arg1Value, this.readMemberNode__readCache_, this.receiverProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(AbstractConstantKeysObject arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.readMemberNode__readCache_ = super.insert((ReadCacheNode.create()));
                    if (this.receiverProfile == null) {
                        this.receiverProfile = (ValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b10 /* add-active readMember(AbstractConstantKeysObject, String, ReadCacheNode, ValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.readMember(arg1Value, this.readMemberNode__readCache_, this.receiverProfile);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                RegexEngine arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b100) != 0 /* is-active execute(RegexEngine, Object[], ToStringNode, ToStringNode) */) {
                    return arg0Value.execute(arg1Value, this.patternToStringNode, this.flagsToStringNode);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(RegexEngine arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.patternToStringNode == null) {
                        this.patternToStringNode = super.insert((ToStringNode.create()));
                    }
                    if (this.flagsToStringNode == null) {
                        this.flagsToStringNode = super.insert((ToStringNode.create()));
                    }
                    this.state_ = state = state | 0b100 /* add-active execute(RegexEngine, Object[], ToStringNode, ToStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.execute(arg1Value, this.patternToStringNode, this.flagsToStringNode);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                RegexEngine arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b1000) != 0 /* is-active isMemberInvocable(RegexEngine, String, StringEqualsNode) */) {
                    return arg0Value.isMemberInvocable(arg1Value, this.isValidatePropNode);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(RegexEngine arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.isValidatePropNode == null) {
                        this.isValidatePropNode = super.insert((StringEqualsNodeGen.create()));
                    }
                    this.state_ = state = state | 0b1000 /* add-active isMemberInvocable(RegexEngine, String, StringEqualsNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMemberInvocable(arg1Value, this.isValidatePropNode);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                RegexEngine arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b10000) != 0 /* is-active invokeMember(RegexEngine, String, Object[], StringEqualsNode, ToStringNode, ToStringNode) */) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.isValidatePropNode, this.patternToStringNode, this.flagsToStringNode);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(RegexEngine arg0Value, String arg1Value, Object[] arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.isValidatePropNode == null) {
                        this.isValidatePropNode = super.insert((StringEqualsNodeGen.create()));
                    }
                    if (this.patternToStringNode == null) {
                        this.patternToStringNode = super.insert((ToStringNode.create()));
                    }
                    if (this.flagsToStringNode == null) {
                        this.flagsToStringNode = super.insert((ToStringNode.create()));
                    }
                    this.state_ = state = state | 0b10000 /* add-active invokeMember(RegexEngine, String, Object[], StringEqualsNode, ToStringNode, ToStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.isValidatePropNode, this.patternToStringNode, this.flagsToStringNode);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(RegexEngine.class)
        private static final class Uncached extends InteropLibrary {

            private final Class<? extends RegexEngine> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((RegexEngine) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.regex.RegexEngine'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractConstantKeysObject) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractConstantKeysObject) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                AbstractConstantKeysObject arg0Value = (AbstractConstantKeysObject) arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, (IsReadableCacheNode.getUncached()), (ValueProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                AbstractConstantKeysObject arg0Value = (AbstractConstantKeysObject) arg0Value_;
                return arg0Value.readMember(arg1Value, (ReadCacheNode.getUncached()), (ValueProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((RegexEngine) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws ArityException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                RegexEngine arg0Value = (RegexEngine) arg0Value_;
                return arg0Value.execute(arg1Value, (ToStringNodeGen.getUncached()), (ToStringNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                RegexEngine arg0Value = (RegexEngine) arg0Value_;
                return arg0Value.isMemberInvocable(arg1Value, (StringEqualsNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                RegexEngine arg0Value = (RegexEngine) arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, (StringEqualsNodeGen.getUncached()), (ToStringNodeGen.getUncached()), (ToStringNodeGen.getUncached()));
            }

        }
    }
}
