/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.thread.PRLock;
import com.oracle.graal.python.builtins.objects.thread.RLockBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PRLock})
public final class RLockBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return RLockBuiltinsFactory.getFactories();
    }

    @Builtin(name="_recursion_count", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class RecursionCountNode
    extends PythonUnaryBuiltinNode {
        RecursionCountNode() {
        }

        @Specialization
        static int recursionCount(PRLock self) {
            if (self.isOwned()) {
                return self.getCount();
            }
            return 0;
        }
    }

    @Builtin(name="_release_save", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReleaseSaveRLockNode
    extends PythonUnaryBuiltinNode {
        ReleaseSaveRLockNode() {
        }

        @Specialization
        static Object releaseSave(PRLock self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile countProfile, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            int count = self.getCount();
            if (countProfile.profile(inliningTarget, count == 0)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.RuntimeError, ErrorMessages.CANNOT_RELEASE_UNAQUIRED_LOCK);
            }
            PTuple retVal = factory.createTuple(new Object[]{count, self.getOwnerId()});
            self.releaseAll();
            return retVal;
        }
    }

    @Builtin(name="_acquire_restore", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class AcquireRestoreRLockNode
    extends PythonBinaryBuiltinNode {
        AcquireRestoreRLockNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object acquireRestore(PRLock self, PTuple state, @Bind(value="this") Node inliningTarget, @Cached GilNode gil, @Cached CastToJavaUnsignedLongNode castLong, @Cached SequenceStorageNodes.GetItemDynamicNode getItemNode) {
            long actualCount;
            if (!self.acquireNonBlocking()) {
                gil.release(true);
                try {
                    self.acquireBlocking(this);
                }
                finally {
                    gil.acquire();
                }
            }
            long count = castLong.execute(inliningTarget, getItemNode.execute(inliningTarget, state.getSequenceStorage(), 0));
            for (actualCount = (long)self.getCount(); count > actualCount; ++actualCount) {
                self.acquireBlocking(this);
            }
            while (count < actualCount) {
                self.release();
                --actualCount;
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="_is_owned", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsOwnedRLockNode
    extends PythonUnaryBuiltinNode {
        IsOwnedRLockNode() {
        }

        @Specialization
        boolean isOwned(PRLock self) {
            return self.isOwned();
        }
    }
}

