/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.range;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.range.RangeBuiltins;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public abstract class PRange
extends PythonBuiltinObject {
    public PRange(PythonLanguage lang) {
        super((Object)PythonBuiltinClassType.PRange, PythonBuiltinClassType.PRange.getInstanceShape(lang));
    }

    public abstract Object getStart();

    public abstract Object getStep();

    public abstract Object getStop();

    public abstract Object getLength();

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(Object o) {
        return this.hashCode() - o.hashCode();
    }

    protected abstract boolean withStep();

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this.withStep()) {
            return String.format("range(%s, %s, %s)", this.getStart(), this.getStop(), this.getStep());
        }
        return String.format("range(%s, %s)", this.getStart(), this.getStop());
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public long getArraySize(@Cached.Shared @Cached RangeBuiltins.LenNode lenNode) {
        return lenNode.execute(this);
    }

    @ExportMessage
    public Object readArrayElement(long index, @Cached RangeBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(this, index);
    }

    @ExportMessage
    public boolean isArrayElementReadable(long idx, @Cached.Shared @Cached RangeBuiltins.LenNode lenNode) {
        return 0L <= idx && idx < (long)lenNode.execute(this);
    }

    @ExportMessage
    public boolean isArrayElementModifiable(long idx) {
        return false;
    }

    @ExportMessage
    public boolean isArrayElementInsertable(long idx) {
        return false;
    }

    @ExportMessage
    public boolean isArrayElementRemovable(long idx) {
        return false;
    }
}

