/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZLibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZlibDecompressBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.zlib.ZlibDecompressBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.zlib.ZlibNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ZlibDecompress})
public final class ZlibDecompressBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ZlibDecompressBuiltinsFactory.getFactories();
    }

    @Builtin(name="eof", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class EOFNode
    extends PythonUnaryBuiltinNode {
        EOFNode() {
        }

        @Specialization(guards={"self.isEof() || !self.isInitialized()"})
        static boolean doit(ZLibCompObject.NativeZlibCompObject self) {
            return self.isEof();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!self.isEof()", "self.isInitialized()"})
        boolean getit(ZLibCompObject.NativeZlibCompObject self, @Cached NativeLibrary.InvokeNativeFunction getEOF) {
            ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                NFIZlibSupport zlibSupport = PythonContext.get(this).getNFIZlibSupport();
                self.setEof(zlibSupport.getEOF(self.getZst(), getEOF) == 1);
                return self.isEof();
            }
        }

        @Specialization
        static boolean doit(ZLibCompObject.JavaZlibCompObject self) {
            return self.isEof();
        }
    }

    @Builtin(name="unconsumed_tail", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class UnconsumedTailNode
    extends PythonUnaryBuiltinNode {
        UnconsumedTailNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isInitialized()"})
        static PBytes doit(ZLibCompObject.NativeZlibCompObject self, @Bind(value="this") Node inliningTarget, @Cached ZlibNodes.GetNativeBufferNode getBuffer, @Cached PythonObjectFactory factory) {
            ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                return factory.createBytes(getBuffer.getUnconsumedTailBuffer(inliningTarget, self.getZst(), PythonContext.get(inliningTarget)));
            }
        }

        @Specialization(guards={"!self.isInitialized()"})
        static PBytes doeof(ZLibCompObject.NativeZlibCompObject self) {
            return self.getUnconsumedTail();
        }

        @Specialization
        static PBytes doit(ZLibCompObject.JavaZlibCompObject self) {
            return self.getUnconsumedTail();
        }
    }

    @Builtin(name="unused_data", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class UnusedDataNode
    extends PythonUnaryBuiltinNode {
        UnusedDataNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isInitialized()"})
        static PBytes doit(ZLibCompObject.NativeZlibCompObject self, @Bind(value="this") Node inliningTarget, @Cached ZlibNodes.GetNativeBufferNode getBuffer, @Cached PythonObjectFactory factory) {
            ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                return factory.createBytes(getBuffer.getUnusedDataBuffer(inliningTarget, self.getZst(), PythonContext.get(inliningTarget)));
            }
        }

        @Specialization(guards={"!self.isInitialized()"})
        static PBytes doeof(ZLibCompObject.NativeZlibCompObject self) {
            return self.getUnusedData();
        }

        @Specialization
        static PBytes doit(ZLibCompObject.JavaZlibCompObject self) {
            return self.getUnusedData();
        }
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1, parameterNames={"$self", "length"})
    @ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="ZLibModuleBuiltins.DEF_BUF_SIZE", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class FlushNode
    extends PythonBinaryClinicBuiltinNode {
        FlushNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZlibDecompressBuiltinsClinicProviders.FlushNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"length > 0", "!self.isEof()", "self.isInitialized()"})
        static PBytes doit(ZLibCompObject.NativeZlibCompObject self, int length, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction decompressObjFlush, @Cached ZlibNodes.GetNativeBufferNode getBuffer, @Cached NativeLibrary.InvokeNativeFunction getIsInitialised, @Cached ZlibNodes.NativeDeallocation processDeallocation, @Cached ZlibNodes.ZlibNativeErrorHandling errorHandling, @Cached.Shared @Cached PythonObjectFactory factory) {
            ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                PythonContext ctxt = PythonContext.get(inliningTarget);
                assert (self.isInitialized());
                NFIZlibSupport zlibSupport = ctxt.getNFIZlibSupport();
                int err = zlibSupport.decompressObjFlush(self.getZst(), length, decompressObjFlush);
                if (err != 0) {
                    errorHandling.execute(inliningTarget, self.getZst(), err, zlibSupport, false);
                }
                byte[] resultArray = getBuffer.getOutputBuffer(inliningTarget, self.getZst(), ctxt);
                if (zlibSupport.getIsInitialised(self.getZst(), getIsInitialised) == 0) {
                    processDeallocation.execute(inliningTarget, self, ctxt, factory, false);
                }
                return factory.createBytes(resultArray);
            }
        }

        @Specialization(guards={"length > 0", "!self.isEof()", "self.isInitialized()"})
        PBytes doit(VirtualFrame frame, ZLibCompObject.JavaZlibCompObject self, int length, @Cached BytesNodes.ToBytesNode toBytes, @Cached.Shared @Cached PythonObjectFactory factory) {
            byte[] res;
            try {
                byte[] bytes = toBytes.execute(self.getUnconsumedTail());
                res = ZlibNodes.JavaDecompressor.execute(frame, self, bytes, bytes.length, 0, length, this, factory, toBytes);
            }
            catch (PException e) {
                res = PythonUtils.EMPTY_BYTE_ARRAY;
            }
            self.setUninitialized();
            return factory.createBytes(res);
        }

        @Specialization(guards={"length > 0", "self.isEof() || !self.isInitialized()"})
        static PBytes empty(ZLibCompObject.JavaZlibCompObject self, int length, @Cached.Shared @Cached PythonObjectFactory factory) {
            self.setUninitialized();
            return factory.createEmptyBytes();
        }

        @Specialization(guards={"length > 0", "self.isEof() || !self.isInitialized()"})
        static PBytes empty(ZLibCompObject.NativeZlibCompObject self, int length, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createEmptyBytes();
        }

        @Specialization(guards={"length <= 0"})
        static PBytes error(ZLibCompObject self, int length, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.S_MUST_BE_GREATER_THAN_ZERO, "length");
        }
    }

    @Builtin(name="__deepcopy__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DeepCopyNode
    extends PythonBinaryBuiltinNode {
        DeepCopyNode() {
        }

        @Specialization
        static Object doit(ZLibCompObject self, Object memo, @Bind(value="this") Node inliningTarget, @Cached BaseCopyNode copyNode, @Cached PythonObjectFactory factory) {
            return copyNode.execute(inliningTarget, self, PythonContext.get(inliningTarget), factory);
        }
    }

    @Builtin(name="__copy__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class UndescoreCopyNode
    extends CopyNode {
        UndescoreCopyNode() {
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        CopyNode() {
        }

        @Specialization
        static Object doit(ZLibCompObject self, @Bind(value="this") Node inliningTarget, @Cached BaseCopyNode copyNode, @Cached PythonObjectFactory factory) {
            return copyNode.execute(inliningTarget, self, PythonContext.get(inliningTarget), factory);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class BaseCopyNode
    extends PNodeWithContext {
        BaseCopyNode() {
        }

        public abstract Object execute(Node var1, ZLibCompObject var2, PythonContext var3, PythonObjectFactory var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isInitialized()"})
        static Object doNative(Node inliningTarget, ZLibCompObject.NativeZlibCompObject self, PythonContext ctxt, PythonObjectFactory factory, @Cached(inline=false) NativeLibrary.InvokeNativeFunction createCompObject, @Cached(inline=false) NativeLibrary.InvokeNativeFunction decompressObjCopy, @Cached(inline=false) NativeLibrary.InvokeNativeFunction deallocateStream, @Cached ZlibNodes.ZlibNativeErrorHandling errorHandling) {
            ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                NFIZlibSupport zlibSupport = ctxt.getNFIZlibSupport();
                Object zstNewCopy = zlibSupport.createCompObject(createCompObject);
                int err = zlibSupport.decompressObjCopy(self.getZst(), zstNewCopy, decompressObjCopy);
                if (err != 0) {
                    zlibSupport.deallocateStream(zstNewCopy, deallocateStream);
                    errorHandling.execute(inliningTarget, self.getZst(), err, zlibSupport, false);
                }
                ZLibCompObject copy = factory.createNativeZLibCompObject((Object)PythonBuiltinClassType.ZlibDecompress, zstNewCopy, zlibSupport);
                copy.setEof(self.isEof());
                return copy;
            }
        }

        @Specialization(guards={"self.isInitialized()", "self.canCopy()"})
        static Object doJava(Node inliningTarget, ZLibCompObject.JavaZlibCompObject self, PythonContext ctxt, PythonObjectFactory factory) {
            return self.copyDecompressObj(factory, inliningTarget);
        }

        @Specialization(guards={"self.isInitialized()", "!self.canCopy()"})
        static PNone error(ZLibCompObject.JavaZlibCompObject self, PythonContext ctxt, PythonObjectFactory factory, @Cached.Shared @Cached(inline=false) PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("JDK based zlib doesn't support copying"));
        }

        @Specialization(guards={"!self.isInitialized()"})
        static PNone error(ZLibCompObject self, PythonContext ctxt, PythonObjectFactory factory, @Cached.Shared @Cached(inline=false) PRaiseNode raise) {
            throw raise.raise(PythonErrorType.ValueError, ErrorMessages.INCONSISTENT_STREAM_STATE);
        }
    }

    @Builtin(name="decompress", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "data", "max_length"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="max_length", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="0", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class DecompressNode
    extends PythonTernaryClinicBuiltinNode {
        DecompressNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZlibDecompressBuiltinsClinicProviders.DecompressNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PBytes decompress(VirtualFrame frame, ZLibCompObject self, Object buffer, int maxLength, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached DecompressInnerNode innerNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                if (!self.isInitialized()) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ZLibError, ErrorMessages.ERROR_D_S_S, -2, "while decompressing data", "inconsistent stream state");
                }
                if (maxLength < 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.S_MUST_BE_GREATER_THAN_ZERO, "max_length");
                }
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                PBytes pBytes = factory.createBytes(innerNode.execute(frame, inliningTarget, self, bytes, len, maxLength));
                return pBytes;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class DecompressInnerNode
        extends Node {
            DecompressInnerNode() {
            }

            abstract byte[] execute(VirtualFrame var1, Node var2, Object var3, byte[] var4, int var5, int var6);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Specialization
            static byte[] doNative(Node inliningTarget, ZLibCompObject.NativeZlibCompObject self, byte[] bytes, int length, int maxLength, @Cached ZlibNodes.ZlibNativeDecompressObj decompressObj) {
                ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
                synchronized (nativeZlibCompObject) {
                    return decompressObj.execute(inliningTarget, self, PythonContext.get(inliningTarget), bytes, length, maxLength);
                }
            }

            @Specialization
            static byte[] doJava(VirtualFrame frame, Node inliningTarget, ZLibCompObject.JavaZlibCompObject self, byte[] bytes, int length, int maxLength, @Cached(inline=false) BytesNodes.ToBytesNode toBytes, @Cached(inline=false) PythonObjectFactory factory) {
                return ZlibNodes.JavaDecompressor.execute(frame, self, bytes, length, maxLength, 16384, inliningTarget, factory, toBytes);
            }
        }
    }
}

