/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNodeGen;
import com.oracle.graal.python.nodes.util.CastToJavaLongNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class CastToJavaLongExactNode
extends CastToJavaLongNode {
    public static long executeUncached(Object x) throws CannotCastException {
        return CastToJavaLongExactNodeGen.getUncached().execute(null, x);
    }

    @Specialization(rewriteOn={OverflowException.class})
    protected static long toLongNoOverflow(PInt x) throws OverflowException {
        return x.longValueExact();
    }

    @Specialization(replaces={"toLongNoOverflow"})
    protected static long toLong(Node inliningTarget, PInt x, @Cached PRaiseNode.Lazy raiseNode) {
        try {
            return x.longValueExact();
        }
        catch (OverflowException e) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "long");
        }
    }
}

