/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins;

import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonSenaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class BuiltinCallNode
extends Node {
    public abstract Object execute(VirtualFrame var1);

    protected abstract PythonBuiltinBaseNode getNode();

    public static final class BuiltinVarArgsCallNode
    extends BuiltinCallNode {
        @Node.Child
        private PythonVarargsBuiltinNode node;
        @Node.Child
        private ReadArgumentNode arg1;
        @Node.Child
        private ReadArgumentNode arg2;
        @Node.Child
        private ReadArgumentNode arg3;

        public BuiltinVarArgsCallNode(PythonVarargsBuiltinNode node, ReadArgumentNode arg1, ReadArgumentNode arg2, ReadArgumentNode arg3) {
            this.node = node;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(frame, this.arg1.execute(frame), (Object[])this.arg2.execute(frame), (PKeyword[])this.arg3.execute(frame));
        }

        @Override
        protected PythonBuiltinBaseNode getNode() {
            return this.node;
        }
    }

    public static final class BuiltinSenaryCallNode
    extends BuiltinCallNode {
        @Node.Child
        private PythonSenaryBuiltinNode node;
        @Node.Child
        private ReadArgumentNode arg1;
        @Node.Child
        private ReadArgumentNode arg2;
        @Node.Child
        private ReadArgumentNode arg3;
        @Node.Child
        private ReadArgumentNode arg4;
        @Node.Child
        private ReadArgumentNode arg5;
        @Node.Child
        private ReadArgumentNode arg6;

        public BuiltinSenaryCallNode(PythonSenaryBuiltinNode node, ReadArgumentNode arg1, ReadArgumentNode arg2, ReadArgumentNode arg3, ReadArgumentNode arg4, ReadArgumentNode arg5, ReadArgumentNode arg6) {
            this.node = node;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
            this.arg5 = arg5;
            this.arg6 = arg6;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(frame, this.arg1.execute(frame), this.arg2.execute(frame), this.arg3.execute(frame), this.arg4.execute(frame), this.arg5.execute(frame), this.arg6.execute(frame));
        }

        @Override
        protected PythonBuiltinBaseNode getNode() {
            return this.node;
        }
    }

    public static final class BuiltinQuaternaryCallNode
    extends BuiltinCallNode {
        @Node.Child
        private PythonQuaternaryBuiltinNode node;
        @Node.Child
        private ReadArgumentNode arg1;
        @Node.Child
        private ReadArgumentNode arg2;
        @Node.Child
        private ReadArgumentNode arg3;
        @Node.Child
        private ReadArgumentNode arg4;

        public BuiltinQuaternaryCallNode(PythonQuaternaryBuiltinNode node, ReadArgumentNode arg1, ReadArgumentNode arg2, ReadArgumentNode arg3, ReadArgumentNode arg4) {
            this.node = node;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(frame, this.arg1.execute(frame), this.arg2.execute(frame), this.arg3.execute(frame), this.arg4.execute(frame));
        }

        @Override
        protected PythonBuiltinBaseNode getNode() {
            return this.node;
        }
    }

    public static final class BuiltinTernaryCallNode
    extends BuiltinCallNode {
        @Node.Child
        private PythonTernaryBuiltinNode node;
        @Node.Child
        ReadArgumentNode arg1;
        @Node.Child
        ReadArgumentNode arg2;
        @Node.Child
        private ReadArgumentNode arg3;

        public BuiltinTernaryCallNode(PythonTernaryBuiltinNode node, ReadArgumentNode arg1, ReadArgumentNode arg2, ReadArgumentNode arg3) {
            this.node = node;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(frame, this.arg1.execute(frame), this.arg2.execute(frame), this.arg3.execute(frame));
        }

        @Override
        protected PythonBuiltinBaseNode getNode() {
            return this.node;
        }
    }

    public static final class BuiltinBinaryCallNode
    extends BuiltinCallNode {
        @Node.Child
        private PythonBinaryBuiltinNode node;
        @Node.Child
        ReadArgumentNode arg1;
        @Node.Child
        ReadArgumentNode arg2;

        public BuiltinBinaryCallNode(PythonBinaryBuiltinNode node, ReadArgumentNode arg1, ReadArgumentNode arg2) {
            this.node = node;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(frame, this.arg1.execute(frame), this.arg2.execute(frame));
        }

        @Override
        protected PythonBuiltinBaseNode getNode() {
            return this.node;
        }
    }

    public static final class BuiltinUnaryCallNode
    extends BuiltinCallNode {
        @Node.Child
        private PythonUnaryBuiltinNode node;
        @Node.Child
        private ReadArgumentNode arg;

        public BuiltinUnaryCallNode(PythonUnaryBuiltinNode node, ReadArgumentNode argument2) {
            this.node = node;
            this.arg = argument2;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(frame, this.arg.execute(frame));
        }

        @Override
        protected PythonBuiltinBaseNode getNode() {
            return this.node;
        }
    }

    public static final class BuiltinAnyCallNode
    extends BuiltinCallNode {
        @Node.Child
        private PythonBuiltinNode node;

        public BuiltinAnyCallNode(PythonBuiltinNode node) {
            this.node = node;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(frame);
        }

        @Override
        protected PythonBuiltinBaseNode getNode() {
            return this.node;
        }
    }
}

