/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.frame;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;

public final class PFrame
extends PythonBuiltinObject {
    private Object[] arguments;
    private final MaterializedFrame locals;
    private Object localsDict;
    private final Reference virtualFrameInfo;
    private Node location;
    private RootCallTarget callTarget;
    private int line = -2;
    private int lasti = -1;
    private boolean lockLine = false;
    private Object localTraceFun = null;
    private boolean traceLine = true;
    private Reference backref = null;

    public Object getLocalTraceFun() {
        return this.localTraceFun;
    }

    public void setLocalTraceFun(Object localTraceFun) {
        this.localTraceFun = localTraceFun;
    }

    public boolean getTraceLine() {
        return this.traceLine;
    }

    public void setTraceLine(boolean traceLine) {
        this.traceLine = traceLine;
    }

    public PFrame(PythonLanguage lang, Reference virtualFrameInfo, Node location, MaterializedFrame locals) {
        super((Object)PythonBuiltinClassType.PFrame, PythonBuiltinClassType.PFrame.getInstanceShape(lang));
        this.virtualFrameInfo = virtualFrameInfo;
        this.locals = locals;
        this.location = location;
    }

    public PFrame(PythonLanguage lang, Object threadState, PCode code, PythonObject globals, Object localsDict) {
        super((Object)PythonBuiltinClassType.PFrame, PythonBuiltinClassType.PFrame.getInstanceShape(lang));
        Reference curFrameInfo;
        Object[] frameArgs = PArguments.create();
        PArguments.setGlobals(frameArgs, globals);
        PArguments.setSpecialArgument(frameArgs, localsDict);
        this.virtualFrameInfo = curFrameInfo = new Reference(null);
        curFrameInfo.setPyFrame(this);
        this.location = CodeNodes.GetCodeRootNode.executeUncached(code);
        this.line = this.location == null ? code.getFirstLineNo() : -2;
        this.arguments = frameArgs;
        this.locals = null;
        this.localsDict = localsDict;
    }

    public MaterializedFrame getLocals() {
        return this.locals;
    }

    public Object getLocalsDict() {
        return this.localsDict;
    }

    public boolean hasCustomLocals() {
        return this.locals == null;
    }

    public void setLocalsDict(Object dict) {
        this.localsDict = dict;
    }

    public Reference getRef() {
        return this.virtualFrameInfo;
    }

    public Reference getBackref() {
        return this.backref;
    }

    public void setBackref(Reference backref) {
        assert (this.backref == null || this.backref == backref) : "setBackref tried to set a backref different to the one that was previously attached";
        this.backref = backref;
    }

    public void setLine(int line) {
        if (this.lockLine) {
            return;
        }
        this.line = line;
    }

    public void setLineLock(int line) {
        this.line = line;
        this.lockLine = true;
    }

    public void lineUnlock() {
        this.lockLine = false;
    }

    @CompilerDirectives.TruffleBoundary
    public int getLine() {
        if (this.line == -2) {
            if (this.location == null) {
                this.line = -1;
            } else {
                if (this.location instanceof PBytecodeRootNode) {
                    return ((PBytecodeRootNode)this.location).bciToLine(this.lasti);
                }
                SourceSection sourceSection = this.location.getEncapsulatingSourceSection();
                if (sourceSection == null) {
                    return -1;
                }
                return sourceSection.getStartLine();
            }
        }
        return this.line;
    }

    public PythonObject getGlobals() {
        return PArguments.getGlobals(this.arguments);
    }

    public RootCallTarget getTarget() {
        if (this.callTarget == null) {
            if (this.location != null) {
                this.callTarget = PythonUtils.getOrCreateCallTarget(this.location.getRootNode());
            } else if (this.getRef() != null && this.getRef().getCallNode() != null) {
                this.callTarget = PythonUtils.getOrCreateCallTarget(this.getRef().getCallNode().getRootNode());
            }
        }
        return this.callTarget;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments2) {
        this.arguments = arguments2;
    }

    public void setLocation(Node location) {
        this.location = location;
    }

    public Node getLocation() {
        return this.location;
    }

    public int getLasti() {
        return this.lasti;
    }

    public void setLasti(int lasti) {
        this.lasti = lasti;
    }

    public static final class Reference {
        public static final Reference EMPTY = new Reference(null);
        private PFrame pyFrame = null;
        private Node callNode = null;
        private boolean escaped = false;
        private final Reference callerInfo;

        public Reference(Reference callerInfo) {
            this.callerInfo = callerInfo;
        }

        public void setBackref(Reference backref) {
            assert (this.pyFrame != null) : "setBackref should only be called when the PFrame escaped";
            this.pyFrame.setBackref(backref);
        }

        public void markAsEscaped() {
            this.escaped = true;
        }

        public boolean isEscaped() {
            return this.escaped;
        }

        public PFrame getPyFrame() {
            return this.pyFrame;
        }

        public void setPyFrame(PFrame escapedFrame) {
            assert (this.pyFrame == null || this.pyFrame == escapedFrame) : "cannot change the escaped frame";
            this.pyFrame = escapedFrame;
        }

        public Node getCallNode() {
            return this.callNode;
        }

        public void setCallNode(Node callNode) {
            this.callNode = callNode;
        }

        public Reference getCallerInfo() {
            return this.callerInfo;
        }
    }
}

