/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.enumerate;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.enumerate.EnumerateBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.enumerate.PEnumerate;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PEnumerate})
public final class EnumerateBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return EnumerateBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object classGetItem(Object cls, Object key) {
            return this.factory().createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object reduce(PEnumerate self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile bigIntIndexProfile, @Cached GetClassNode getClassNode) {
            Object iterator = self.getDecoratedIterator();
            Object index = self.getIndex(inliningTarget, bigIntIndexProfile);
            PTuple contents = this.factory().createTuple(new Object[]{iterator, index});
            return this.factory().createTuple(new Object[]{getClassNode.execute(inliningTarget, self), contents});
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(PEnumerate self) {
            return self;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object doNext(VirtualFrame frame, PEnumerate self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile bigIntIndexProfile, @Cached GetNextNode next) {
            Object index = self.getAndIncrementIndex(inliningTarget, this.factory(), bigIntIndexProfile);
            Object nextValue = next.execute((Frame)frame, self.getDecoratedIterator());
            return this.factory().createTuple(new Object[]{index, nextValue});
        }
    }
}

