/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyMode;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.io.PrintStream;

@ExportLibrary(value=InteropLibrary.class)
public abstract class GraalHPyNativeContext
implements TruffleObject {
    protected final GraalHPyContext context;

    protected GraalHPyNativeContext(GraalHPyContext context, boolean traceUpcalls) {
        this.context = context;
    }

    protected abstract String getName();

    protected final PythonContext getContext() {
        return this.context.getContext();
    }

    protected abstract void initNativeContext() throws Exception;

    protected abstract void finalizeNativeContext();

    protected abstract Object loadExtensionLibrary(Node var1, PythonContext var2, TruffleString var3, TruffleString var4) throws LoadCExtException.ImportException, IOException;

    protected abstract GraalHPyContext.HPyABIVersion getHPyABIVersion(Object var1, String var2, String var3) throws Exception;

    protected abstract Object initHPyModule(Object var1, String var2, TruffleString var3, TruffleString var4, HPyMode var5) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, LoadCExtException.ImportException, LoadCExtException.ApiInitException;

    protected abstract GraalHPyContext.HPyUpcall[] getUpcalls();

    protected abstract int[] getUpcallCounts();

    public abstract void initHPyDebugContext() throws LoadCExtException.ApiInitException;

    public abstract void initHPyTraceContext() throws LoadCExtException.ApiInitException;

    public abstract PythonModule getHPyDebugModule() throws LoadCExtException.ImportException;

    public abstract PythonModule getHPyTraceModule() throws LoadCExtException.ImportException;

    protected abstract void setNativeCache(long var1);

    protected abstract long getWcharSize();

    protected abstract Object createArgumentsArray(Object[] var1);

    protected abstract void freeArgumentsArray(Object var1);

    public abstract GraalHPyNodes.HPyCallHelperFunctionNode createCallHelperFunctionNode();

    public abstract GraalHPyNodes.HPyCallHelperFunctionNode getUncachedCallHelperFunctionNode();

    public abstract GraalHPyNodes.HPyFromCharPointerNode createFromCharPointerNode();

    public abstract GraalHPyNodes.HPyFromCharPointerNode getUncachedFromCharPointerNode();

    protected final boolean useNativeFastPaths() {
        return this.context.useNativeFastPaths;
    }

    public final GraalHPyContext getHPyContext() {
        return this.context;
    }

    @ExportMessage
    public void toNative() {
        try {
            this.toNativeInternal();
            if (this.useNativeFastPaths()) {
                this.initNativeFastPaths();
                this.context.allocateNativeSpacePointersMirror();
            }
        }
        catch (CannotCastException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    protected abstract void toNativeInternal();

    protected abstract void initNativeFastPaths();

    @CompilerDirectives.TruffleBoundary
    public static PException checkThrowableBeforeNative(Throwable t, String where1, Object where2) {
        if (t instanceof PException) {
            PException pe = (PException)((Object)t);
            throw pe;
        }
        if (t instanceof ThreadDeath) {
            ThreadDeath td = (ThreadDeath)t;
            throw td;
        }
        if (t instanceof StackOverflowError) {
            StackOverflowError soe = (StackOverflowError)t;
            CompilerDirectives.transferToInterpreter();
            PythonContext context = PythonContext.get(null);
            context.reacquireGilAfterStackOverflow();
            PBaseException newException = context.factory().createBaseException((Object)PythonBuiltinClassType.RecursionError, ErrorMessages.MAXIMUM_RECURSION_DEPTH_EXCEEDED, PythonUtils.EMPTY_OBJECT_ARRAY);
            throw ExceptionUtils.wrapJavaException(soe, null, newException);
        }
        if (t instanceof OutOfMemoryError) {
            OutOfMemoryError oome = (OutOfMemoryError)t;
            PBaseException newException = PythonContext.get(null).factory().createBaseException((Object)PythonBuiltinClassType.MemoryError);
            throw ExceptionUtils.wrapJavaException(oome, null, newException);
        }
        CompilerDirectives.transferToInterpreter();
        PNodeWithContext.printStack();
        PrintStream out = new PrintStream(PythonContext.get(null).getEnv().err());
        out.println("while executing " + where1 + " " + where2);
        out.println("should not throw exceptions apart from PException");
        t.printStackTrace(out);
        out.flush();
        throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.SystemError, ErrorMessages.INTERNAL_EXCEPTION_OCCURED);
    }
}

