/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public abstract class PythonReplacingNativeWrapper
extends PythonNativeWrapper {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(PythonNativeWrapper.class);
    protected Object replacement;

    public PythonReplacingNativeWrapper() {
    }

    public PythonReplacingNativeWrapper(Object delegate) {
        super(delegate);
    }

    public final Object getReplacement() {
        return this.replacement;
    }

    protected final void setReplacement(Object pointer, InteropLibrary lib) {
        LOGGER.finest(() -> PythonUtils.formatJString("assigning %s with %s", this.getDelegate(), pointer));
        if (pointer instanceof Long) {
            this.replacement = CExtNodes.PCallCapiFunction.getUncached().call(NativeCAPISymbol.FUN_CONVERT_POINTER, pointer);
            CApiTransitions.firstToNative(this, (Long)pointer);
        } else {
            this.replacement = pointer;
            if (lib.isPointer(pointer)) {
                assert (pointer.getClass() == NativePointer.class || pointer.getClass().getSimpleName().contains("NFIPointer") || pointer.getClass().getSimpleName().contains("LLVMPointer"));
                try {
                    CApiTransitions.firstToNative(this, lib.asPointer(pointer));
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            } else {
                assert (pointer.getClass().getSimpleName().contains("LLVMPointer"));
                CApiTransitions.firstToNativeManaged(this.getDelegate(), pointer);
            }
        }
    }

    @ExportMessage
    boolean isPointer() {
        return this.isNative();
    }

    @ExportMessage
    long asPointer() {
        assert (this.getNativePointer() != -1L);
        return this.getNativePointer();
    }

    protected abstract Object allocateReplacememtObject();

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected void toNative(@CachedLibrary(limit="3") InteropLibrary lib) {
        if (!this.isNative()) {
            this.setRefCount(0x3FFFFFFFFFFFFFFFL);
            this.setReplacement(this.allocateReplacememtObject(), lib);
        }
    }
}

