/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.lzma;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMADecompressorBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.lzma.LZMADecompressorBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.lzma.LZMAModuleBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMANodes;
import com.oracle.graal.python.builtins.modules.lzma.LZMAObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PLZMADecompressor})
public final class LZMADecompressorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return LZMADecompressorBuiltinsFactory.getFactories();
    }

    @Builtin(name="unused_data", minNumOfPositionalArgs=1, parameterNames={"self"}, isGetter=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class UnusedDataNode
    extends PythonUnaryBuiltinNode {
        UnusedDataNode() {
        }

        @Specialization
        PBytes doUnusedData(LZMAObject.LZMADecompressor self) {
            return this.factory().createBytes(self.getUnusedData());
        }
    }

    @Builtin(name="check", minNumOfPositionalArgs=1, parameterNames={"self"}, isGetter=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class CheckNode
    extends PythonUnaryBuiltinNode {
        CheckNode() {
        }

        @Specialization
        int doCheck(LZMAObject.LZMADecompressor.Native self) {
            return self.getCheck();
        }

        @Specialization
        int doCheck(LZMAObject.LZMADecompressor.Java self) {
            throw this.raise(PythonBuiltinClassType.SystemError, LZMAModuleBuiltins.T_LZMA_JAVA_ERROR);
        }
    }

    @Builtin(name="needs_input", minNumOfPositionalArgs=1, parameterNames={"self"}, isGetter=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class NeedsInputNode
    extends PythonUnaryBuiltinNode {
        NeedsInputNode() {
        }

        @Specialization
        boolean doNeedsInput(LZMAObject.LZMADecompressor self) {
            return self.needsInput();
        }
    }

    @Builtin(name="eof", minNumOfPositionalArgs=1, parameterNames={"self"}, isGetter=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class EofNode
    extends PythonUnaryBuiltinNode {
        EofNode() {
        }

        @Specialization
        boolean doEof(LZMAObject.LZMADecompressor self) {
            return self.isEOF();
        }
    }

    @Builtin(name="decompress", minNumOfPositionalArgs=2, parameterNames={"$self", "$data", "max_length"}, needsFrame=true)
    @ArgumentClinic(name="max_length", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class DecompressNode
    extends PythonTernaryClinicBuiltinNode {
        DecompressNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return LZMADecompressorBuiltinsClinicProviders.DecompressNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!self.isEOF()"})
        PBytes doBytes(LZMAObject.LZMADecompressor self, PBytesLike data, int maxLength, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode toBytes, @Cached.Exclusive @Cached LZMANodes.DecompressNode decompress) {
            byte[] bytes = toBytes.execute(inliningTarget, data.getSequenceStorage());
            int len = data.getSequenceStorage().length();
            return this.factory().createBytes(decompress.execute(inliningTarget, self, bytes, len, maxLength));
        }

        @Specialization(guards={"!self.isEOF()"})
        PBytes doObject(VirtualFrame frame, LZMAObject.LZMADecompressor self, Object data, int maxLength, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytes, @Cached.Exclusive @Cached LZMANodes.DecompressNode decompress) {
            byte[] bytes = toBytes.execute(frame, data);
            int len = bytes.length;
            return this.factory().createBytes(decompress.execute(inliningTarget, self, bytes, len, maxLength));
        }

        @Specialization(guards={"self.isEOF()"})
        Object err(LZMAObject.LZMADecompressor self, Object data, int maxLength) {
            throw this.raise(PythonBuiltinClassType.EOFError, ErrorMessages.ALREADY_AT_END_OF_STREAM);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self", "format", "memlimit", "filters"})
    @ImportStatic(value={PGuards.class})
    @ArgumentClinic(name="format", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="LZMAModuleBuiltins.FORMAT_AUTO", useDefaultForNone=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class InitNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return LZMADecompressorBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!isRaw(format)", "validFormat(format)", "!isPNone(memlimitObj)"})
        PNone notRaw(VirtualFrame frame, LZMAObject.LZMADecompressor self, int format, Object memlimitObj, PNone filters, @Bind(value="this") Node inliningTarget, @Cached CastToJavaIntExactNode cast, @Cached.Shared(value="d") @Cached LZMANodes.LZMADecompressInit decompressInit) {
            int memlimit;
            try {
                memlimit = cast.execute(inliningTarget, memlimitObj);
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
            }
            return InitNode.doNotRaw(frame, self, format, memlimit, decompressInit);
        }

        @Specialization(guards={"!isRaw(format)", "validFormat(format)"})
        PNone notRaw(VirtualFrame frame, LZMAObject.LZMADecompressor self, int format, PNone memlimit, PNone filters, @Cached.Shared(value="d") @Cached LZMANodes.LZMADecompressInit decompressInit) {
            return InitNode.doNotRaw(frame, self, format, Integer.MAX_VALUE, decompressInit);
        }

        private static PNone doNotRaw(VirtualFrame frame, LZMAObject.LZMADecompressor self, int format, int memlimit, LZMANodes.LZMADecompressInit decompressInit) {
            self.setCheck(format == LZMAModuleBuiltins.FORMAT_ALONE ? LZMAModuleBuiltins.CHECK_NONE : LZMAModuleBuiltins.CHECK_UNKNOWN);
            self.setFormat(format);
            self.setMemlimit(memlimit);
            decompressInit.execute(frame, self, format, memlimit);
            return PNone.NONE;
        }

        @Specialization(guards={"isRaw(format)", "!isPNone(filters)"})
        PNone raw(VirtualFrame frame, LZMAObject.LZMADecompressor self, int format, PNone memlimit, Object filters, @Cached LZMANodes.LZMARawDecompressInit decompressInit) {
            self.setCheck(LZMAModuleBuiltins.CHECK_NONE);
            decompressInit.execute(frame, self, filters);
            return PNone.NONE;
        }

        @Specialization(guards={"isRaw(format)", "!isPNone(memlimit)"})
        PNone rawError(LZMAObject.LZMADecompressor self, int format, Object memlimit, Object filters) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CANNOT_SPECIFY_MEM_LIMIT);
        }

        @Specialization(guards={"isRaw(format)"})
        PNone rawFilterError(LZMAObject.LZMADecompressor self, int format, Object memlimit, PNone filters) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.MUST_SPECIFY_FILTERS);
        }

        @Specialization(guards={"!isRaw(format)", "!isPNone(filters)"})
        PNone rawFilterError(LZMAObject.LZMADecompressor self, int format, Object memlimit, Object filters) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CANNOT_SPECIFY_FILTERS);
        }

        @Specialization(guards={"!validFormat(format)"})
        PNone invalidFormat(LZMAObject.LZMADecompressor self, int format, Object memlimit, Object filters) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_CONTAINER_FORMAT, format);
        }

        protected static boolean validFormat(int format) {
            return format == LZMAModuleBuiltins.FORMAT_AUTO || format == LZMAModuleBuiltins.FORMAT_XZ || format == LZMAModuleBuiltins.FORMAT_ALONE || format == LZMAModuleBuiltins.FORMAT_RAW;
        }

        protected static boolean isRaw(int format) {
            return format == LZMAModuleBuiltins.FORMAT_RAW;
        }
    }
}

