/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.lzma;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMACompressorBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.lzma.LZMACompressorBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.lzma.LZMAModuleBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMANodes;
import com.oracle.graal.python.builtins.modules.lzma.LZMAObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PLZMACompressor})
public final class LZMACompressorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return LZMACompressorBuiltinsFactory.getFactories();
    }

    public static abstract class ExpectUINT32Node
    extends ArgumentCastNode.ArgumentCastNodeWithRaise {
        private final Object defaultValue;

        protected ExpectUINT32Node(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public abstract Object execute(VirtualFrame var1, Object var2);

        @Specialization
        Object none(PNone none) {
            return this.defaultValue;
        }

        @Specialization(guards={"!isPNone(value)"})
        Object doOthers(Object value, @Cached LZMANodes.ToUINT32Option toUINT32Option) {
            return toUINT32Option.execute(value);
        }

        protected ExpectUINT32Node createRec() {
            return LZMACompressorBuiltinsFactory.ExpectUINT32NodeGen.create(this.defaultValue);
        }

        @ClinicConverterFactory
        @NeverDefault
        public static ExpectUINT32Node create(@ClinicConverterFactory.DefaultValue Object defaultValue) {
            return LZMACompressorBuiltinsFactory.ExpectUINT32NodeGen.create(defaultValue);
        }
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class FlushNode
    extends PythonUnaryBuiltinNode {
        FlushNode() {
        }

        @Specialization(guards={"!self.isFlushed()"})
        PBytes doit(LZMAObject.LZMACompressor self, @Cached LZMANodes.CompressNode compress) {
            self.setFlushed();
            return this.factory().createBytes(compress.flush(self, PythonContext.get(this)));
        }

        @Specialization(guards={"self.isFlushed()"})
        PNone error(LZMAObject.LZMACompressor self) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.REPEATED_CALL_TO_FLUSH);
        }
    }

    @Builtin(name="compress", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class CompressNode
    extends PythonBinaryBuiltinNode {
        CompressNode() {
        }

        @Specialization(guards={"!self.isFlushed()"})
        PBytes doBytes(LZMAObject.LZMACompressor self, PBytesLike data, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode toBytes, @Cached.Shared(value="c") @Cached LZMANodes.CompressNode compress) {
            byte[] bytes = toBytes.execute(inliningTarget, data.getSequenceStorage());
            int len = data.getSequenceStorage().length();
            return this.factory().createBytes(compress.compress(self, PythonContext.get(this), bytes, len));
        }

        @Specialization(guards={"!self.isFlushed()"})
        PBytes doObject(VirtualFrame frame, LZMAObject.LZMACompressor self, Object data, @Cached BytesNodes.ToBytesNode toBytes, @Cached.Shared(value="c") @Cached LZMANodes.CompressNode compress) {
            byte[] bytes = toBytes.execute(frame, data);
            int len = bytes.length;
            return this.factory().createBytes(compress.compress(self, PythonContext.get(this), bytes, len));
        }

        @Specialization(guards={"self.isFlushed()"})
        PNone error(LZMAObject.LZMACompressor self, Object data) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.COMPRESSOR_HAS_BEEN_FLUSHED);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self", "format", "check", "preset", "filters"})
    @ArgumentsClinic(value={@ArgumentClinic(name="format", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="LZMAModuleBuiltins.FORMAT_XZ", useDefaultForNone=true), @ArgumentClinic(name="check", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="preset", conversionClass=ExpectUINT32Node.class, defaultValue="PNone.NO_VALUE")})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class InitNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return LZMACompressorBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!badIntegrity(format, check)", "!badRawFilter(format, filters)"})
        PNone init(VirtualFrame frame, LZMAObject.LZMACompressor self, int format, int check, long preset, PNone filters, @Cached.Shared(value="i") @Cached LZMANodes.LZMACompressInit compressInit) {
            self.setCheck(check == -1 && format == LZMAModuleBuiltins.FORMAT_XZ ? LZMAModuleBuiltins.CHECK_CRC64 : check);
            compressInit.execute(frame, self, format, preset, filters);
            return PNone.NONE;
        }

        @Specialization(guards={"!badIntegrity(format, check)", "!badRawFilter(format, filters)"})
        PNone init(VirtualFrame frame, LZMAObject.LZMACompressor self, int format, int check, PNone preset, Object filters, @Cached.Shared(value="i") @Cached LZMANodes.LZMACompressInit compressInit) {
            self.setCheck(check == -1 && format == LZMAModuleBuiltins.FORMAT_XZ ? LZMAModuleBuiltins.CHECK_CRC64 : check);
            compressInit.execute(frame, self, format, LZMAModuleBuiltins.PRESET_DEFAULT, filters);
            return PNone.NONE;
        }

        @Specialization(guards={"badIntegrity(format, check)"})
        PNone integrityError(LZMAObject.LZMACompressor self, long format, long check, Object preset, Object filters) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.INTEGRITY_CHECKS_ONLY_SUPPORTED_BY);
        }

        @Specialization(guards={"!badIntegrity(format, check)", "badPresetFilters(preset, filters)"})
        PNone presetError(LZMAObject.LZMACompressor self, long format, long check, Object preset, Object filters) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.CANNOT_SPECIFY_PREST_AND_FILTER_CHAIN);
        }

        @Specialization(guards={"!badIntegrity(format, check)", "!badPresetFilters(preset, filters)", "badRawFilter(format, filters)"})
        PNone rawError(LZMAObject.LZMACompressor self, long format, long check, Object preset, PNone filters) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.MUST_SPECIFY_FILTERS);
        }

        protected static boolean badIntegrity(long format, long check) {
            return format != (long)LZMAModuleBuiltins.FORMAT_XZ && check != -1L && check != (long)LZMAModuleBuiltins.CHECK_NONE;
        }

        protected static boolean badPresetFilters(Object preset, Object filters) {
            return !PGuards.isPNone(preset) && !PGuards.isPNone(filters);
        }

        protected static boolean badRawFilter(long format, Object filters) {
            return format == (long)LZMAModuleBuiltins.FORMAT_RAW && PGuards.isPNone(filters);
        }

        protected static boolean isValid(long format, long check, Object preset, Object filters) {
            return !InitNode.badIntegrity(format, check) && !InitNode.badPresetFilters(preset, filters) && !InitNode.badRawFilter(format, filters);
        }
    }
}

