/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.BytesIOBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.BytesIOBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.PBytesIO;
import com.oracle.graal.python.builtins.modules.io.PBytesIOBuffer;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyMemoryViewFromObject;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.ArrayBuilder;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBytesIO})
public final class BytesIOBuiltins
extends PythonBuiltins {
    protected static final byte[] EMPTY_BYTE_ARRAY = PythonUtils.EMPTY_BYTE_ARRAY;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BytesIOBuiltinsFactory.getFactories();
    }

    static PBytes readBytes(PBytesIO self, int size, PythonBufferAccessLibrary bufferLib, PythonObjectFactory factory) {
        if (size == 0) {
            return factory.createBytes(PythonUtils.EMPTY_BYTE_ARRAY);
        }
        assert (size <= self.getStringSize());
        PByteArray buffer = self.getBuf();
        if (self.getPos() == 0 && bufferLib.hasInternalByteArray(buffer) && self.getExports() == 0 && size > bufferLib.getBufferLength(buffer) / 2) {
            self.incPos(size);
            self.markEscaped();
            return factory.createBytes(bufferLib.getInternalByteArray(buffer), size);
        }
        PBytes output = factory.createBytes(bufferLib.getCopyOfRange(buffer, self.getPos(), self.getPos() + size));
        self.incPos(size);
        return output;
    }

    static int scanEOL(PBytesIO self, int l, PythonBufferAccessLibrary bufferLib) {
        PByteArray buffer = self.getBuf();
        byte[] buf = bufferLib.getInternalOrCopiedByteArray(buffer);
        return BytesIOBuiltins.scanEOL(self, l, buf);
    }

    private static int scanEOL(PBytesIO self, int l, byte[] buf) {
        assert (self.getPos() >= 0);
        if (self.getPos() >= self.getStringSize()) {
            return 0;
        }
        int maxlen = self.getStringSize() - self.getPos();
        int len = l;
        if (len < 0 || len > maxlen) {
            len = maxlen;
        }
        if (len > 0) {
            int n = -1;
            for (int i = self.getPos(); i < self.getPos() + len; ++i) {
                if (buf[i] != 10) continue;
                n = i;
                break;
            }
            if (n != -1) {
                len = n - self.getPos() + 1;
            }
        }
        assert (len >= 0);
        assert (self.getPos() < Integer.MAX_VALUE - len);
        return len;
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IternextNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        IternextNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        Object doit(PBytesIO self, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            int n = BytesIOBuiltins.scanEOL(self, -1, bufferLib);
            if (n == 0) {
                throw this.raiseStopIteration();
            }
            return BytesIOBuiltins.readBytes(self, n, bufferLib, this.factory());
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization
        Object close(PBytesIO self) {
            self.checkExports(this);
            self.setBuf(null);
            return PNone.NONE;
        }
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends PythonUnaryBuiltinNode {
        ClosedNode() {
        }

        @Specialization
        static boolean closed(PBytesIO self) {
            return !self.hasBuf();
        }
    }

    @Builtin(name="writable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class WritableNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        WritableNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static boolean writable(PBytesIO self) {
            return true;
        }
    }

    @Builtin(name="readable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadableNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        ReadableNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static boolean readable(PBytesIO self) {
            return true;
        }
    }

    @Builtin(name="seekable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SeekableNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        SeekableNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static boolean seekable(PBytesIO self) {
            return true;
        }
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FlushNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        FlushNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object doit(PBytesIO self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        SetStateNode() {
        }

        @Specialization
        Object doit(VirtualFrame frame, PBytesIO self, PTuple state, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached WriteNode writeNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached GetOrCreateDictNode getDict, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            self.checkExports(this);
            Object[] array = getArray.execute(inliningTarget, state.getSequenceStorage());
            if (array.length < 3) {
                return this.notTuple(self, state);
            }
            self.setStringSize(0);
            self.setPos(0);
            writeNode.execute(frame, self, array[0]);
            if (!indexCheckNode.execute(inliningTarget, array[1])) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.SECOND_ITEM_OF_STATE_MUST_BE_AN_INTEGER_NOT_P, array[1]);
            }
            int pos = asSizeNode.executeExact((Frame)frame, inliningTarget, array[1]);
            if (pos < 0) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.POSITION_VALUE_CANNOT_BE_NEGATIVE);
            }
            self.setPos(pos);
            if (!PGuards.isNone(array[2])) {
                if (!PGuards.isDict(array[2])) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.THIRD_ITEM_OF_STATE_SHOULD_BE_A_DICT_GOT_A_P, array[2]);
                }
                PDict dict = getDict.execute(inliningTarget, self);
                addAllToOtherNode.execute((Frame)frame, inliningTarget, ((PDict)array[2]).getDictStorage(), dict);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isPTuple(state)"})
        Object notTuple(PBytesIO self, Object state) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.P_SETSTATE_ARGUMENT_SHOULD_BE_D_TUPLE_GOT_P, self, 3, state);
        }
    }

    @Builtin(name="__getstate__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetStateNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        GetStateNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        Object doit(VirtualFrame frame, PBytesIO self, @Bind(value="this") Node inliningTarget, @Cached GetValueNode getValueNode, @Cached GetOrCreateDictNode getDict) {
            Object initValue = getValueNode.execute(frame, self);
            Object[] state = new Object[]{initValue, self.getPos(), getDict.execute(inliningTarget, self)};
            return this.factory().createTuple(state);
        }
    }

    @Builtin(name="getvalue", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetValueNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        GetValueNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        Object doCopy(PBytesIO self, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            if (bufferLib.hasInternalByteArray(self.getBuf()) && self.getExports() == 0) {
                self.markEscaped();
            }
            return this.factory().createBytes(bufferLib.getInternalOrCopiedByteArray(self.getBuf()), self.getStringSize());
        }
    }

    @Builtin(name="getbuffer", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetBufferNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        GetBufferNode() {
        }

        @Specialization
        Object doit(VirtualFrame frame, PBytesIO self, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Bind(value="this") Node inliningTarget, @Cached PyMemoryViewFromObject memoryViewNode, @Cached SequenceStorageNodes.SetLenNode setLenNode) {
            self.unshareIfNecessary(bufferLib, this.factory());
            setLenNode.execute(inliningTarget, self.getBuf().getSequenceStorage(), self.getStringSize());
            PBytesIOBuffer buf = this.factory().createBytesIOBuf((Object)PythonBuiltinClassType.PBytesIOBuf, self);
            return memoryViewNode.execute(frame, buf);
        }
    }

    @Builtin(name="seek", minNumOfPositionalArgs=2, parameterNames={"$self", "pos", "whence"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pos", conversion=ArgumentClinic.ClinicConversion.Index), @ArgumentClinic(name="whence", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="BufferedIOUtil.SEEK_SET", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class SeekNode
    extends PythonTernaryClinicBuiltinNode {
        SeekNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.SeekNodeClinicProviderGen.INSTANCE;
        }

        protected static boolean isSupportedWhence(int whence) {
            return whence == 0 || whence == 1 || whence == 2;
        }

        protected static boolean isLargePos(int pos, int to) {
            return pos > Integer.MAX_VALUE - to;
        }

        protected static boolean validPos(PBytesIO self, int pos, int whence) {
            return !(pos < 0 && whence == 0 || SeekNode.isLargePos(pos, self.getStringSize()) && whence == 2 || SeekNode.isLargePos(pos, self.getPos()) && whence == 1);
        }

        @Specialization(guards={"self.hasBuf()", "isSupportedWhence(whence)", "validPos(self, pos, whence)"})
        static Object seek(PBytesIO self, int pos, int whence) {
            int p = pos;
            if (whence == 1) {
                p += self.getPos();
            } else if (whence == 2) {
                p += self.getStringSize();
            }
            if (p < 0) {
                p = 0;
            }
            self.setPos(p);
            return p;
        }

        @Specialization(guards={"self.hasBuf()", "!isSupportedWhence(whence)"})
        Object whenceError(PBytesIO self, int pos, int whence) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_WHENCE_D_SHOULD_BE_0_1_OR_2, whence);
        }

        @Specialization(guards={"self.hasBuf()", "isLargePos(pos, self.getPos())", "whence == 1"})
        Object largePos1(PBytesIO self, int pos, int whence) {
            throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.NEW_POSITION_TOO_LARGE);
        }

        @Specialization(guards={"self.hasBuf()", "isLargePos(pos, self.getStringSize())", "whence == 2"})
        Object largePos2(PBytesIO self, int pos, int whence) {
            throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.NEW_POSITION_TOO_LARGE);
        }

        @Specialization(guards={"self.hasBuf()", "pos < 0", "whence == 0"})
        Object negPos(PBytesIO self, int pos, int whence) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SEEK_VALUE_D, pos);
        }

        @Specialization(guards={"!self.hasBuf()"})
        Object closedError(PBytesIO self, int pos, int whence) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="tell", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TellNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        TellNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object tell(PBytesIO self) {
            return self.getPos();
        }
    }

    @Builtin(name="isatty", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsAttyNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        IsAttyNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static boolean atty(PBytesIO self) {
            return false;
        }
    }

    @Builtin(name="writelines", minNumOfPositionalArgs=2, parameterNames={"$self", "lines"})
    @GenerateNodeFactory
    static abstract class WriteLinesNode
    extends ClosedCheckPythonBinaryBuiltinNode {
        WriteLinesNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        Object writeLines(VirtualFrame frame, PBytesIO self, Object lines, @Bind(value="this") Node inliningTarget, @Cached GetNextNode getNextNode, @Cached WriteNode writeNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PyObjectGetIter getIter) {
            self.checkExports(this);
            Object iter = getIter.execute((Frame)frame, inliningTarget, lines);
            while (true) {
                Object line;
                try {
                    line = getNextNode.execute((Frame)frame, iter);
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    break;
                }
                writeNode.execute(frame, self, line);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends ClosedCheckPythonBinaryBuiltinNode {
        WriteNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.hasBuf()"}, limit="3")
        Object doWrite(VirtualFrame frame, PBytesIO self, Object b, @CachedLibrary(value="b") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
            self.checkExports(this);
            Object buffer = acquireLib.acquireReadonly(b, frame, this);
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (len == 0) {
                    Integer n = 0;
                    return n;
                }
                int pos = self.getPos();
                int endpos = pos + len;
                self.unshareAndResize(bufferLib, this.factory(), endpos, false);
                bufferLib.readIntoBuffer(buffer, 0, self.getBuf(), pos, len, bufferLib);
                self.setPos(endpos);
                if (endpos > self.getStringSize()) {
                    self.setStringSize(endpos);
                }
                Integer n = len;
                return n;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }
    }

    @Builtin(name="truncate", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @GenerateNodeFactory
    static abstract class TruncateNode
    extends ClosedCheckPythonBinaryBuiltinNode {
        TruncateNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        Object truncate(PBytesIO self, int size, @Cached.Shared(value="lib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            self.checkExports(this);
            if (size < 0) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SIZE_VALUE_D, size);
            }
            if (size < self.getStringSize()) {
                self.unshareAndResize(bufferLib, this.factory(), size, true);
                self.setStringSize(size);
            }
            return size;
        }

        @Specialization(guards={"self.hasBuf()"})
        Object truncate(PBytesIO self, PNone size, @Cached.Shared(value="lib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            return this.truncate(self, self.getPos(), bufferLib);
        }

        @Specialization(guards={"self.hasBuf()", "!isPNone(size)"})
        Object truncate(VirtualFrame frame, PBytesIO self, Object size, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="lib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            return this.truncate(self, asSizeNode.executeExact((Frame)frame, inliningTarget, size), bufferLib);
        }
    }

    @Builtin(name="readinto", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.WritableBuffer)
    @GenerateNodeFactory
    static abstract class ReadIntoNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadIntoNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.hasBuf()"})
        Object readinto(VirtualFrame frame, PBytesIO self, Object buffer, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                int n = self.getStringSize() - self.getPos();
                if (len > n && (len = n) < 0) {
                    Integer n2 = 0;
                    return n2;
                }
                bufferLib.readIntoBuffer(self.getBuf(), self.getPos(), buffer, 0, len, bufferLib);
                assert (self.getPos() + len < Integer.MAX_VALUE);
                assert (len >= 0);
                self.incPos(len);
                Integer n3 = len;
                return n3;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.ReadIntoNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="readlines", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlinesNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadlinesNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.ReadlinesNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.hasBuf()"})
        Object readlines(PBytesIO self, int maxsize, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            int n;
            ArrayBuilder<Object> result = new ArrayBuilder<Object>();
            PByteArray buffer = self.getBuf();
            byte[] buf = bufferLib.getInternalOrCopiedByteArray(buffer);
            int cur = self.getPos();
            int size = 0;
            while ((n = BytesIOBuiltins.scanEOL(self, -1, buf)) != 0) {
                self.incPos(n);
                PBytes line = this.factory().createBytes(PythonUtils.arrayCopyOfRange(buf, cur, cur + n));
                result.add(line);
                if (maxsize > 0 && (size += n) >= maxsize) break;
                cur += n;
            }
            return this.factory().createList(result.toArray(new Object[0]));
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadlineNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.ReadlineNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.hasBuf()"})
        Object readline(PBytesIO self, int size, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            int n = BytesIOBuiltins.scanEOL(self, size, bufferLib);
            return BytesIOBuiltins.readBytes(self, n, bufferLib, this.factory());
        }
    }

    @Builtin(name="read1", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class Read1Node
    extends ReadNode {
        Read1Node() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.Read1NodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.hasBuf()"})
        Object read(PBytesIO self, int len, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            int size = len;
            int n = self.getStringSize() - self.getPos();
            if ((size < 0 || size > n) && (size = n) < 0) {
                size = 0;
            }
            return BytesIOBuiltins.readBytes(self, size, bufferLib, this.factory());
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self", "initial_bytes"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PNone init(PBytesIO self, PNone initvalue) {
            self.checkExports(this);
            self.setPos(0);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(initvalue)"})
        PNone init(VirtualFrame frame, PBytesIO self, Object initvalue, @Cached WriteNode writeNode) {
            self.setStringSize(0);
            self.setPos(0);
            self.checkExports(this);
            writeNode.execute(frame, self, initvalue);
            self.setPos(0);
            return PNone.NONE;
        }
    }

    static abstract class ClosedCheckPythonBinaryClinicBuiltinNode
    extends PythonBinaryClinicBuiltinNode {
        ClosedCheckPythonBinaryClinicBuiltinNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization(guards={"!self.hasBuf()"})
        Object closedError(PBytesIO self, Object arg) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    static abstract class ClosedCheckPythonBinaryBuiltinNode
    extends PythonBinaryBuiltinNode {
        ClosedCheckPythonBinaryBuiltinNode() {
        }

        @Specialization(guards={"!self.hasBuf()"})
        Object closedError(PBytesIO self, Object arg) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    static abstract class ClosedCheckPythonUnaryBuiltinNode
    extends PythonUnaryBuiltinNode {
        ClosedCheckPythonUnaryBuiltinNode() {
        }

        @Specialization(guards={"!self.hasBuf()"})
        Object closedError(PBytesIO self) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }
}

