/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class MultibyteDecodeBuffer {
    ByteBuffer inputBuffer;
    protected CharBuffer writer;
    protected PBaseException excobj;

    public MultibyteDecodeBuffer(byte[] inbuf) {
        this.inputBuffer = ByteBuffer.wrap(inbuf);
        this.writer = MultibyteCodecUtil.writerInit(inbuf.length);
        this.excobj = null;
    }

    protected int getInSize() {
        return this.inputBuffer.limit();
    }

    @CompilerDirectives.TruffleBoundary
    protected void incInpos(int len) {
        this.setInpos(this.getInpos() + len);
    }

    protected int getInpos() {
        return this.inputBuffer.position();
    }

    @CompilerDirectives.TruffleBoundary
    protected void setInpos(int pos) {
        this.inputBuffer.position(pos);
    }

    protected int remaining() {
        return this.inputBuffer.remaining();
    }

    @CompilerDirectives.TruffleBoundary
    protected void getRemaining(byte[] dst, int dstOff, int len) {
        this.inputBuffer.get(dst, dstOff, len);
    }

    protected boolean isFull() {
        return !this.inputBuffer.hasRemaining();
    }

    protected PBytes createPBytes(PythonObjectFactory factory) {
        return factory.createBytes(this.inputBuffer.array(), this.getInpos());
    }

    protected void replaceInbuf(byte[] inbuf) {
        this.inputBuffer = ByteBuffer.wrap(inbuf);
    }

    protected int getOutpos() {
        return this.writer.position();
    }

    @CompilerDirectives.TruffleBoundary
    protected void writeChar(char c) {
        this.writer.append(c);
    }

    @CompilerDirectives.TruffleBoundary
    protected void writeStr(String str) {
        this.writer.append(str);
    }

    @CompilerDirectives.TruffleBoundary
    protected TruffleString toTString() {
        return PythonUtils.toTruffleStringUncached(this.writer.toString());
    }

    @CompilerDirectives.TruffleBoundary
    protected void grow(PRaiseNode raiseNode) {
        int newCapacity = 2 * this.writer.capacity() + 1;
        if (newCapacity < 0) {
            throw raiseNode.raise(PythonErrorType.MemoryError);
        }
        CharBuffer newBuffer = CharBuffer.allocate(newCapacity);
        this.writer.flip();
        newBuffer.put(this.writer);
        this.writer = newBuffer;
    }
}

