/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.scriptengine;

import com.oracle.truffle.js.scriptengine.GraalJSBindings;
import com.oracle.truffle.js.scriptengine.GraalJSEngineFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Predicate;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;

public final class GraalJSScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable,
AutoCloseable {
    private static final String ID = "js";
    private static final String POLYGLOT_CONTEXT = "polyglot.context";
    private static final String OUT_SYMBOL = "$$internal.out$$";
    private static final String IN_SYMBOL = "$$internal.in$$";
    private static final String ERR_SYMBOL = "$$internal.err$$";
    private static final String JS_SYNTAX_EXTENSIONS_OPTION = "js.syntax-extensions";
    private static final String JS_SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT_OPTION = "js.script-engine-global-scope-import";
    private static final String JS_LOAD_OPTION = "js.load";
    private static final String JS_PRINT_OPTION = "js.print";
    private static final String JS_GLOBAL_ARGUMENTS_OPTION = "js.global-arguments";
    private static final String NASHORN_COMPATIBILITY_MODE_SYSTEM_PROPERTY = "polyglot.js.nashorn-compat";
    static final String MAGIC_OPTION_PREFIX = "polyglot.js.";
    private static final HostAccess NASHORN_HOST_ACCESS = HostAccess.newBuilder((HostAccess)HostAccess.ALL).targetTypeMapping(Object.class, String.class, Objects::nonNull, String::valueOf).build();
    private static final MagicBindingsOptionSetter[] MAGIC_OPTION_SETTERS = new MagicBindingsOptionSetter[]{new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowHostAccess";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowHostAccess(GraalJSScriptEngine.toBoolean(this, value) ? HostAccess.ALL : HostAccess.NONE);
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowNativeAccess";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowNativeAccess(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowCreateThread";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowCreateThread(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowIO";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowIO(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowHostClassLookup";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            if (value instanceof Boolean) {
                boolean enabled = (Boolean)value;
                return builder.allowHostClassLookup(enabled ? s -> true : null);
            }
            try {
                return builder.allowHostClassLookup((Predicate)value);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("failed to set graal-js option \"%s\": expected a boolean or Predicate<String> value, got \"%s\"", this.getOptionKey(), value));
            }
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowHostClassLoading";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowHostClassLoading(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return "polyglot.js.allowAllAccess";
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            return builder.allowAllAccess(GraalJSScriptEngine.toBoolean(this, value));
        }
    }, new MagicBindingsOptionSetter(){

        @Override
        public String getOptionKey() {
            return GraalJSScriptEngine.NASHORN_COMPATIBILITY_MODE_SYSTEM_PROPERTY;
        }

        @Override
        public Context.Builder setOption(Context.Builder builder, Object value) {
            boolean val = GraalJSScriptEngine.toBoolean(this, value);
            if (val) {
                GraalJSScriptEngine.updateForNashornCompatibilityMode(builder);
            }
            return builder.option("js.nashorn-compat", String.valueOf(val));
        }
    }};
    private static final EconomicSet<String> MAGIC_BINDINGS_OPTION_KEYS = EconomicSet.create();
    static final EconomicMap<String, MagicBindingsOptionSetter> MAGIC_BINDINGS_OPTION_MAP = EconomicMap.create();
    private static final boolean NASHORN_COMPATIBILITY_MODE = Boolean.getBoolean("polyglot.js.nashorn-compat");
    private final GraalJSEngineFactory factory;
    private final Context.Builder contextConfig;
    private volatile boolean closed;
    private boolean evalCalled;
    private static final String JRUNSCRIPT_INIT_NAME = "<system-init>";
    private static final String JSADAPTER_POLYFILL = "this.JSAdapter || Object.defineProperty(this, \"JSAdapter\", {configurable:true, writable:true, enumerable: false, value: function(t) {\n    var target = {};\n    var handler = {\n        get: function(target, name) {return typeof t.__get__ == 'function' ? t.__get__.call(target, name) : undefined;},\n        has: function(target, name) {return typeof t.__has__ == 'function' ? t.__has__.call(target, name) : false;},\n        deleteProperty: function(target, name) {return typeof t.__delete__ == 'function' ? t.__delete__.call(target, name) : true;},\n        set: function(target, name, value) {return typeof t.__put__ == 'function' ? t.__put__.call(target, name, value) : undefined;},\n        ownKeys: function(target) {return typeof t.__getIds__ == 'function' ? t.__getIds__.call(target) : [];},\n    }\n    return new Proxy(target, handler);\n}});\n";

    private static boolean toBoolean(MagicBindingsOptionSetter optionSetter, Object value) {
        if (!(value instanceof Boolean)) {
            throw GraalJSScriptEngine.magicOptionValueErrorBool(optionSetter.getOptionKey(), value);
        }
        return (Boolean)value;
    }

    GraalJSScriptEngine(GraalJSEngineFactory factory) {
        this(factory, factory.getPolyglotEngine(), null);
    }

    GraalJSScriptEngine(GraalJSEngineFactory factory, Engine engine, Context.Builder contextConfig) {
        Context.Builder contextConfigToUse;
        Engine engineToUse = engine;
        if (engineToUse == null) {
            engineToUse = Engine.newBuilder().allowExperimentalOptions(true).build();
        }
        if ((contextConfigToUse = contextConfig) == null) {
            contextConfigToUse = Context.newBuilder((String[])new String[]{ID}).allowExperimentalOptions(true);
            contextConfigToUse.option(JS_SYNTAX_EXTENSIONS_OPTION, "true");
            contextConfigToUse.option(JS_LOAD_OPTION, "true");
            contextConfigToUse.option(JS_PRINT_OPTION, "true");
            contextConfigToUse.option(JS_GLOBAL_ARGUMENTS_OPTION, "true");
            if (NASHORN_COMPATIBILITY_MODE) {
                GraalJSScriptEngine.updateForNashornCompatibilityMode(contextConfigToUse);
            }
        }
        this.factory = factory == null ? new GraalJSEngineFactory(engineToUse) : factory;
        this.contextConfig = contextConfigToUse.option(JS_SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT_OPTION, "true").engine(engineToUse);
        this.context.setBindings(new GraalJSBindings(this.contextConfig, this.context), 100);
    }

    private static void updateForNashornCompatibilityMode(Context.Builder builder) {
        builder.allowAllAccess(true);
        builder.allowHostAccess(NASHORN_HOST_ACCESS);
    }

    static Context createDefaultContext(Context.Builder builder) {
        DelegatingInputStream in = new DelegatingInputStream();
        DelegatingOutputStream out = new DelegatingOutputStream();
        DelegatingOutputStream err = new DelegatingOutputStream();
        builder.in((InputStream)in).out((OutputStream)out).err((OutputStream)err);
        Context ctx = builder.build();
        ctx.getPolyglotBindings().putMember(OUT_SYMBOL, (Object)out);
        ctx.getPolyglotBindings().putMember(ERR_SYMBOL, (Object)err);
        ctx.getPolyglotBindings().putMember(IN_SYMBOL, (Object)in);
        return ctx;
    }

    @Override
    public void close() {
        this.getPolyglotContext().close();
        this.closed = true;
    }

    public Engine getPolyglotEngine() {
        return this.factory.getPolyglotEngine();
    }

    public Context getPolyglotContext() {
        return this.getPolyglotContext(this.context);
    }

    public Context getPolyglotContext(ScriptContext ctxt) {
        return this.getOrCreateGraalJSBindings(ctxt).getContext();
    }

    static Value evalInternal(Context context, String script) {
        return context.eval(Source.newBuilder((String)ID, (CharSequence)script, (String)"internal-script").internal(true).buildLiteral());
    }

    @Override
    public Bindings createBindings() {
        return new GraalJSBindings(this.contextConfig, null);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        Bindings oldBindings;
        if (scope == 100 && (oldBindings = this.getBindings(scope)) instanceof GraalJSBindings) {
            ((GraalJSBindings)oldBindings).updateEngineScriptContext(null);
        }
        super.setBindings(bindings, scope);
        if (scope == 100 && bindings instanceof GraalJSBindings) {
            ((GraalJSBindings)bindings).updateEngineScriptContext(this.getContext());
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        return this.eval(GraalJSScriptEngine.createSource(reader, ctxt), ctxt);
    }

    private static Source createSource(Reader reader, ScriptContext ctxt) throws ScriptException {
        try {
            return Source.newBuilder((String)ID, (Reader)reader, (String)GraalJSScriptEngine.getScriptName(ctxt)).build();
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        return this.eval(GraalJSScriptEngine.createSource(script, ctxt), ctxt);
    }

    private static Source createSource(String script, ScriptContext ctxt) {
        return Source.newBuilder((String)ID, (CharSequence)script, (String)GraalJSScriptEngine.getScriptName(ctxt)).buildLiteral();
    }

    private static String getScriptName(ScriptContext ctxt) {
        Object val = ctxt.getAttribute("javax.script.filename");
        return val != null ? val.toString() : "<eval>";
    }

    private Object eval(Source source, ScriptContext scriptContext) throws ScriptException {
        GraalJSBindings engineBindings = this.getOrCreateGraalJSBindings(scriptContext);
        Context polyglotContext = engineBindings.getContext();
        ((DelegatingOutputStream)polyglotContext.getPolyglotBindings().getMember(OUT_SYMBOL).asProxyObject()).setWriter(scriptContext.getWriter());
        ((DelegatingOutputStream)polyglotContext.getPolyglotBindings().getMember(ERR_SYMBOL).asProxyObject()).setWriter(scriptContext.getErrorWriter());
        ((DelegatingInputStream)polyglotContext.getPolyglotBindings().getMember(IN_SYMBOL).asProxyObject()).setReader(scriptContext.getReader());
        try {
            if (!this.evalCalled) {
                GraalJSScriptEngine.jrunscriptInitWorkaround(source, polyglotContext);
            }
            engineBindings.importGlobalBindings(scriptContext);
            Object object = polyglotContext.eval(source).as(Object.class);
            return object;
        }
        catch (PolyglotException e) {
            throw new ScriptException((Exception)((Object)e));
        }
        finally {
            this.evalCalled = true;
        }
    }

    private GraalJSBindings getOrCreateGraalJSBindings(ScriptContext scriptContext) {
        Bindings engineB = scriptContext.getBindings(100);
        if (engineB instanceof GraalJSBindings) {
            return (GraalJSBindings)engineB;
        }
        GraalJSBindings bindings = new GraalJSBindings(this.createContext(engineB), scriptContext);
        bindings.putAll(engineB);
        return bindings;
    }

    private Context createContext(Bindings engineB) {
        Object ctx = engineB.get(POLYGLOT_CONTEXT);
        if (!(ctx instanceof Context)) {
            Context.Builder builder = this.contextConfig;
            for (MagicBindingsOptionSetter optionSetter : MAGIC_OPTION_SETTERS) {
                Object value = engineB.get(optionSetter.getOptionKey());
                if (value == null) continue;
                builder = optionSetter.setOption(builder, value);
                engineB.remove(optionSetter.getOptionKey());
            }
            ctx = GraalJSScriptEngine.createDefaultContext(builder);
            engineB.put(POLYGLOT_CONTEXT, ctx);
        }
        return (Context)ctx;
    }

    @Override
    public GraalJSEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("thiz is not a valid object.");
        }
        GraalJSBindings engineBindings = this.getOrCreateGraalJSBindings(this.context);
        engineBindings.importGlobalBindings(this.context);
        Value thisValue = engineBindings.getContext().asValue(thiz);
        if (!thisValue.canInvokeMember(name)) {
            if (!thisValue.hasMember(name)) {
                throw GraalJSScriptEngine.noSuchMethod(name);
            }
            throw GraalJSScriptEngine.notCallable(name);
        }
        try {
            return thisValue.invokeMember(name, args).as(Object.class);
        }
        catch (PolyglotException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        GraalJSBindings engineBindings = this.getOrCreateGraalJSBindings(this.context);
        engineBindings.importGlobalBindings(this.context);
        Value function = engineBindings.getContext().getBindings(ID).getMember(name);
        if (function == null) {
            throw GraalJSScriptEngine.noSuchMethod(name);
        }
        if (!function.canExecute()) {
            throw GraalJSScriptEngine.notCallable(name);
        }
        try {
            return function.execute(args).as(Object.class);
        }
        catch (PolyglotException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    private static NoSuchMethodException noSuchMethod(String name) throws NoSuchMethodException {
        throw new NoSuchMethodException(name);
    }

    private static NoSuchMethodException notCallable(String name) throws NoSuchMethodException {
        throw new NoSuchMethodException(name + " is not a function");
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        GraalJSScriptEngine.checkInterface(clasz);
        return GraalJSScriptEngine.getInterfaceInner(GraalJSScriptEngine.evalInternal(this.getPolyglotContext(), "this"), clasz);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz == null) {
            throw new IllegalArgumentException("this cannot be null");
        }
        GraalJSScriptEngine.checkInterface(clasz);
        Value thisValue = this.getPolyglotContext().asValue(thiz);
        GraalJSScriptEngine.checkThis(thisValue);
        return GraalJSScriptEngine.getInterfaceInner(thisValue, clasz);
    }

    private static void checkInterface(Class<?> clasz) {
        if (clasz == null || !clasz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected in getInterface");
        }
    }

    private static void checkThis(Value thiz) {
        if (thiz.isHostObject() || !thiz.hasMembers()) {
            throw new IllegalArgumentException("getInterface cannot be called on non-script object");
        }
    }

    private static <T> T getInterfaceInner(Value thiz, Class<T> iface) {
        if (!GraalJSScriptEngine.isInterfaceImplemented(iface, thiz)) {
            return null;
        }
        return (T)thiz.as(iface);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        if (this.closed) {
            throw new IllegalStateException("Context already closed.");
        }
        Source source = GraalJSScriptEngine.createSource(script, this.getContext());
        return this.compile(source);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        if (this.closed) {
            throw new IllegalStateException("Context already closed.");
        }
        Source source = GraalJSScriptEngine.createSource(reader, this.getContext());
        return this.compile(source);
    }

    private CompiledScript compile(final Source source) throws ScriptException {
        this.checkSyntax(source);
        return new CompiledScript(){

            @Override
            public ScriptEngine getEngine() {
                return GraalJSScriptEngine.this;
            }

            @Override
            public Object eval(ScriptContext ctx) throws ScriptException {
                return GraalJSScriptEngine.this.eval(source, ctx);
            }
        };
    }

    private void checkSyntax(Source source) throws ScriptException {
        GraalJSBindings engineBindings = this.getOrCreateGraalJSBindings(this.context);
        Context polyglotContext = engineBindings.getContext();
        Value syntaxChecker = polyglotContext.getBindings(ID).getMember("checkSyntaxForScriptEngine");
        try {
            syntaxChecker.execute(new Object[]{source.getCharacters()});
        }
        catch (PolyglotException pex) {
            throw new ScriptException((Exception)((Object)pex));
        }
    }

    public static GraalJSScriptEngine create() {
        return GraalJSScriptEngine.create(null, null);
    }

    public static GraalJSScriptEngine create(Engine engine, Context.Builder newContextConfig) {
        return new GraalJSScriptEngine(null, engine, newContextConfig);
    }

    private static boolean isInterfaceImplemented(Class<?> iface, Value obj) {
        for (Method method : iface.getMethods()) {
            if (method.getDeclaringClass() == Object.class || !Modifier.isAbstract(method.getModifiers()) || obj.canInvokeMember(method.getName())) continue;
            return false;
        }
        return true;
    }

    private static void jrunscriptInitWorkaround(Source source, Context polyglotContext) {
        String initCode;
        if (source.getName().equals(JRUNSCRIPT_INIT_NAME) && (initCode = source.getCharacters().toString()).contains("jrunscript") && initCode.contains("JSAdapter") && !polyglotContext.getBindings(ID).hasMember("JSAdapter")) {
            polyglotContext.eval(ID, (CharSequence)JSADAPTER_POLYFILL);
        }
    }

    private static IllegalArgumentException magicOptionValueErrorBool(String name, Object v) {
        return new IllegalArgumentException(String.format("failed to set graal-js option \"%s\": expected a boolean value, got \"%s\"", name, v));
    }

    static {
        for (MagicBindingsOptionSetter setter : MAGIC_OPTION_SETTERS) {
            MAGIC_BINDINGS_OPTION_KEYS.add((Object)setter.getOptionKey());
            MAGIC_BINDINGS_OPTION_MAP.put((Object)setter.getOptionKey(), (Object)setter);
        }
    }

    private static class DelegatingOutputStream
    extends OutputStream
    implements Proxy {
        private Writer writer;

        private DelegatingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.writer != null) {
                this.writer.write(b);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
        }

        void setWriter(Writer writer) {
            this.writer = writer;
        }
    }

    private static class DelegatingInputStream
    extends InputStream
    implements Proxy {
        private Reader reader;

        private DelegatingInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (this.reader != null) {
                return this.reader.read();
            }
            return 0;
        }

        void setReader(Reader reader) {
            this.reader = reader;
        }
    }

    static interface MagicBindingsOptionSetter {
        public String getOptionKey();

        public Context.Builder setOption(Context.Builder var1, Object var2);
    }
}

