/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobal;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobalObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstanceObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTableObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyValueTypes;
import com.oracle.truffle.js.runtime.builtins.wasm.WebAssemblyHostFunction;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSWebAssemblyInstance
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "Instance";
    public static final String EXPORTS = "exports";
    public static final JSWebAssemblyInstance INSTANCE = new JSWebAssemblyInstance();

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSWebAssemblyInstance(Object object) {
        return object instanceof JSWebAssemblyInstanceObject;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, prototype, constructor);
        JSObjectUtil.putAccessorProperty(ctx, prototype, EXPORTS, JSWebAssemblyInstance.createExportsGetterFunction(realm), Undefined.instance, JSAttributes.configurableEnumerableWritable());
        JSObjectUtil.putToStringTag(prototype, "WebAssembly.Instance");
        return prototype;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWebAssemblyInstancePrototype();
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static JSWebAssemblyInstanceObject create(JSContext context, JSRealm realm, Object wasmInstance, Object wasmModule) {
        JSObjectFactory factory = context.getWebAssemblyInstanceFactory();
        Object exportsObject = JSWebAssemblyInstance.createExportsObject(context, realm, wasmInstance, wasmModule);
        JSWebAssemblyInstanceObject object = new JSWebAssemblyInstanceObject(factory.getShape(realm), wasmInstance, exportsObject);
        factory.initProto(object, realm);
        return context.trackAllocation(object);
    }

    private static DynamicObject createExportsGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.WebAssemblyInstanceGetExports, c -> {
            RootCallTarget callTarget = new JavaScriptRootNode(c.getLanguage(), null, null){
                private final BranchProfile errorBranch = BranchProfile.create();

                public Object execute(VirtualFrame frame) {
                    Object thiz = JSFrameUtil.getThisObj((Frame)frame);
                    if (JSWebAssemblyInstance.isJSWebAssemblyInstance(thiz)) {
                        return ((JSWebAssemblyInstanceObject)((Object)thiz)).getExports();
                    }
                    this.errorBranch.enter();
                    throw Errors.createTypeError("WebAssembly.Instance.exports(): Receiver is not a WebAssembly.Instance", (Node)this);
                }
            }.getCallTarget();
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get exports");
        });
        return JSFunction.create(realm, getterData);
    }

    private static Object createExportsObject(JSContext context, JSRealm realm, Object wasmInstance, Object wasmModule) {
        DynamicObject exports = JSOrdinary.createWithNullPrototype(context);
        try {
            Object exportsFunction = realm.getWASMModuleExports();
            Object exportsInfo = InteropLibrary.getUncached((Object)exportsFunction).execute(exportsFunction, new Object[]{wasmModule});
            Object instanceExport = realm.getWASMInstanceExport();
            InteropLibrary exportsInterop = InteropLibrary.getUncached((Object)exportsInfo);
            long size = exportsInterop.getArraySize(exportsInfo);
            for (long i = 0L; i < size; ++i) {
                Object value;
                Object exportInfo = exportsInterop.readArrayElement(exportsInfo, i);
                InteropLibrary exportInterop = InteropLibrary.getUncached((Object)exportInfo);
                String name = JSWebAssemblyInstance.asString(exportInterop.readMember(exportInfo, "name"));
                String externtype = JSWebAssemblyInstance.asString(exportInterop.readMember(exportInfo, "kind"));
                Object externval = InteropLibrary.getUncached().execute(instanceExport, new Object[]{wasmInstance, name});
                if ("function".equals(externtype)) {
                    String typeInfo = JSWebAssemblyInstance.asString(exportInterop.readMember(exportInfo, "type"));
                    value = JSWebAssemblyInstance.exportFunction(context, realm, externval, typeInfo);
                } else if ("global".equals(externtype)) {
                    String valueType = JSWebAssemblyInstance.asString(exportInterop.readMember(exportInfo, "type"));
                    value = JSWebAssemblyGlobal.create(context, realm, externval, valueType);
                } else if ("memory".equals(externtype)) {
                    value = JSWebAssemblyMemory.create(context, realm, externval);
                } else {
                    assert ("table".equals(externtype));
                    value = JSWebAssemblyTable.create(context, realm, externval);
                }
                JSObject.set(exports, name, value);
            }
        }
        catch (InteropException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
        JSObject.setIntegrityLevel(exports, true);
        return exports;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object exportFunction(final JSContext context, JSRealm realm, final Object export, String typeInfo) {
        Object embedderData = JSWebAssembly.getEmbedderData(realm, export);
        if (embedderData instanceof JSFunctionObject) {
            return embedderData;
        }
        int idxOpen = typeInfo.indexOf(40);
        int idxClose = typeInfo.indexOf(41);
        String name = typeInfo.substring(0, idxOpen);
        String argTypes = typeInfo.substring(idxOpen + 1, idxClose);
        final String returnType = typeInfo.substring(idxClose + 1);
        final String[] paramTypes = argTypes.length() != 0 ? argTypes.split(" ") : new String[]{};
        final int argCount = paramTypes.length;
        final boolean returnTypeIsI64 = JSWebAssemblyValueTypes.isI64(returnType);
        final boolean anyArgTypeIsI64 = argTypes.contains("i64");
        RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            ToWebAssemblyValueNode toWebAssemblyValueNode;
            @Node.Child
            ToJSValueNode toJSValueNode;
            private final BranchProfile errorBranch;
            @Node.Child
            InteropLibrary exportFunctionLib;
            @CompilerDirectives.CompilationFinal(dimensions=1)
            String[] argTypesArray;
            {
                super(lang, sourceSection, frameDescriptor);
                this.toWebAssemblyValueNode = ToWebAssemblyValueNode.create();
                this.toJSValueNode = ToJSValueNode.create();
                this.errorBranch = BranchProfile.create();
                this.exportFunctionLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
                this.argTypesArray = paramTypes;
            }

            public Object execute(VirtualFrame frame) {
                if (!context.getContextOptions().isWasmBigInt() && (returnTypeIsI64 || anyArgTypeIsI64)) {
                    this.errorBranch.enter();
                    throw Errors.createTypeError("wasm function signature contains illegal type");
                }
                Object[] frameArguments = frame.getArguments();
                int userArgumentCount = JSArguments.getUserArgumentCount(frameArguments);
                Object[] wasmArgs = new Object[argCount];
                for (int i = 0; i < argCount; ++i) {
                    Object wasmArg = i < userArgumentCount ? JSArguments.getUserArgument(frameArguments, i) : Undefined.instance;
                    wasmArgs[i] = this.toWebAssemblyValueNode.execute(wasmArg, this.argTypesArray[i]);
                }
                try {
                    Object wasmResult;
                    try {
                        wasmResult = this.exportFunctionLib.execute(export, wasmArgs);
                    }
                    catch (GraalJSException jsex) {
                        this.errorBranch.enter();
                        throw jsex;
                    }
                    catch (AbstractTruffleException tex) {
                        this.errorBranch.enter();
                        ExceptionType type = InteropLibrary.getUncached((Object)((Object)tex)).getExceptionType((Object)tex);
                        if (type == ExceptionType.INTERRUPT || type == ExceptionType.EXIT) {
                            throw tex;
                        }
                        throw Errors.createRuntimeError(tex, (Node)this);
                    }
                    if (returnType.isEmpty()) {
                        return Undefined.instance;
                    }
                    return this.toJSValueNode.execute(wasmResult);
                }
                catch (InteropException ex) {
                    throw Errors.shouldNotReachHere(ex);
                }
            }
        }.getCallTarget();
        JSFunctionData functionData = JSFunctionData.createCallOnly(context, (CallTarget)callTarget, argCount, name);
        DynamicObject result = JSFunction.create(realm, functionData);
        JSObjectUtil.putHiddenProperty(result, JSWebAssembly.FUNCTION_ADDRESS, export);
        JSWebAssembly.setEmbedderData(realm, export, result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    public static Object transformImportObject(JSContext context, JSRealm realm, Object wasmModule, Object importObject) {
        try {
            DynamicObject transformedImportObject = JSOrdinary.create(context, realm);
            Object importsFn = realm.getWASMModuleImports();
            Object imports = InteropLibrary.getUncached((Object)importsFn).execute(importsFn, new Object[]{wasmModule});
            InteropLibrary importsInterop = InteropLibrary.getUncached((Object)imports);
            long size = importsInterop.getArraySize(imports);
            for (long i = 0L; i < size; ++i) {
                DynamicObject transformedModule;
                Object wasmValue;
                Object descriptor = importsInterop.readArrayElement(imports, i);
                InteropLibrary descriptorInterop = InteropLibrary.getUncached((Object)descriptor);
                String module = JSWebAssemblyInstance.asString(descriptorInterop.readMember(descriptor, "module"));
                Object moduleImportObject = JSInteropUtil.get(importObject, module);
                InteropLibrary moduleImportObjectInterop = InteropLibrary.getUncached((Object)moduleImportObject);
                if (!moduleImportObjectInterop.hasMembers(moduleImportObject)) {
                    throw Errors.createTypeErrorNotAnObject(moduleImportObject);
                }
                String name = JSWebAssemblyInstance.asString(descriptorInterop.readMember(descriptor, "name"));
                Object value = JSInteropUtil.get(moduleImportObject, name);
                String externType = JSWebAssemblyInstance.asString(descriptorInterop.readMember(descriptor, "kind"));
                if ("function".equals(externType)) {
                    if (!JSRuntime.isCallable(value)) {
                        throw Errors.createLinkError("Imported value is not callable");
                    }
                    if (JSWebAssembly.isExportedFunction(value)) {
                        wasmValue = JSWebAssembly.getExportedFunction((DynamicObject)value);
                    } else {
                        String typeInfo = JSWebAssemblyInstance.asString(descriptorInterop.readMember(descriptor, "type"));
                        wasmValue = JSWebAssemblyInstance.createHostFunction(value, typeInfo);
                    }
                } else if ("global".equals(externType)) {
                    boolean isNumber = JSRuntime.isNumber(value);
                    boolean isBigInt = JSRuntime.isBigInt(value);
                    if (isNumber || context.getContextOptions().isWasmBigInt() && isBigInt) {
                        String valueType = JSWebAssemblyInstance.asString(descriptorInterop.readMember(descriptor, "type"));
                        boolean isI64 = JSWebAssemblyValueTypes.isI64(valueType);
                        if (!context.getContextOptions().isWasmBigInt() && isI64) {
                            throw Errors.createLinkError("Can't import the value of i64 WebAssembly.Global");
                        }
                        if (isI64 && isNumber) {
                            throw Errors.createLinkError("Value of valtype i64 must be BigInt");
                        }
                        if (!isI64 && isBigInt) {
                            throw Errors.createLinkError("BigInt can only be stored in valtype i64");
                        }
                        Object webAssemblyValue = ToWebAssemblyValueNode.getUncached().execute(value, valueType);
                        try {
                            Object createGlobal = realm.getWASMGlobalAlloc();
                            wasmValue = InteropLibrary.getUncached((Object)createGlobal).execute(createGlobal, new Object[]{valueType, false, webAssemblyValue});
                        }
                        catch (InteropException ex) {
                            throw Errors.shouldNotReachHere(ex);
                        }
                    } else {
                        if (!JSWebAssemblyGlobal.isJSWebAssemblyGlobal(value)) throw Errors.createLinkError("Imported value is not WebAssembly.Global object");
                        wasmValue = ((JSWebAssemblyGlobalObject)((Object)value)).getWASMGlobal();
                    }
                } else if ("memory".equals(externType)) {
                    if (!JSWebAssemblyMemory.isJSWebAssemblyMemory(value)) throw Errors.createLinkError("Imported value is not WebAssembly.Memory object");
                    wasmValue = ((JSWebAssemblyMemoryObject)((Object)value)).getWASMMemory();
                } else {
                    assert ("table".equals(externType)) : externType;
                    if (!JSWebAssemblyTable.isJSWebAssemblyTable(value)) throw Errors.createLinkError("Imported value is not WebAssembly.Table object");
                    wasmValue = ((JSWebAssemblyTableObject)((Object)value)).getWASMTable();
                }
                if (JSObject.hasOwnProperty(transformedImportObject, module)) {
                    transformedModule = (DynamicObject)JSObject.get(transformedImportObject, module);
                } else {
                    transformedModule = JSOrdinary.create(context, realm);
                    JSObject.set(transformedImportObject, module, (Object)transformedModule);
                }
                JSObject.set(transformedModule, name, wasmValue);
            }
            return transformedImportObject;
        }
        catch (InteropException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Object createHostFunction(Object fn, String typeInfo) {
        return new WebAssemblyHostFunction(fn, typeInfo);
    }

    private static String asString(Object string) throws UnsupportedMessageException {
        if (string instanceof String) {
            return (String)string;
        }
        return InteropLibrary.getUncached((Object)string).asString(string);
    }
}

