/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.ibm.icu.util.ULocale;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.intl.LocalePrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocaleObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.Locale;

public final class JSLocale
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "Locale";
    public static final String PROTOTYPE_NAME = "Locale.prototype";
    public static final JSLocale INSTANCE = new JSLocale();

    private JSLocale() {
    }

    public static boolean isJSLocale(Object obj) {
        return obj instanceof JSLocaleObject;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject localePrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, localePrototype, ctor);
        JSObjectUtil.putToStringTag(localePrototype, "Intl.Locale");
        JSObjectUtil.putFunctionsFromContainer(realm, localePrototype, LocalePrototypeBuiltins.BUILTINS);
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "baseName");
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "calendar");
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "caseFirst");
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "collation");
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "hourCycle");
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "numeric");
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "numberingSystem");
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "language");
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "script");
        JSLocale.putLocalePropertyAccessor(realm, localePrototype, "region");
        if (ctx.getEcmaScriptVersion() >= 14) {
            JSLocale.putLocalePropertyAccessor(realm, localePrototype, "calendars");
            JSLocale.putLocalePropertyAccessor(realm, localePrototype, "collations");
            JSLocale.putLocalePropertyAccessor(realm, localePrototype, "hourCycles");
            JSLocale.putLocalePropertyAccessor(realm, localePrototype, "numberingSystems");
            JSLocale.putLocalePropertyAccessor(realm, localePrototype, "timeZones");
            JSLocale.putLocalePropertyAccessor(realm, localePrototype, "textInfo");
            JSLocale.putLocalePropertyAccessor(realm, localePrototype, "weekInfo");
        }
        return localePrototype;
    }

    private static void putLocalePropertyAccessor(JSRealm realm, DynamicObject prototype, String name) {
        JSObjectUtil.putBuiltinAccessorProperty(prototype, name, realm.lookupAccessor(LocalePrototypeBuiltins.BUILTINS, name));
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static DynamicObject create(JSContext context, JSRealm realm) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context.getLocaleFactory();
        JSLocaleObject obj = new JSLocaleObject(factory.getShape(realm), state);
        factory.initProto(obj, realm);
        assert (JSLocale.isJSLocale((Object)obj));
        return obj;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalState(InternalState state, Locale locale) {
        state.locale = locale;
        state.calendar = locale.getUnicodeLocaleType("ca");
        state.caseFirst = locale.getUnicodeLocaleType("kf");
        state.collation = locale.getUnicodeLocaleType("co");
        state.hourCycle = locale.getUnicodeLocaleType("hc");
        String kn = locale.getUnicodeLocaleType("kn");
        state.numeric = "true".equals(kn) || "".equals(kn);
        state.numberingSystem = locale.getUnicodeLocaleType("nu");
    }

    public static InternalState getInternalState(DynamicObject localeObject) {
        assert (JSLocale.isJSLocale(localeObject));
        return ((JSLocaleObject)localeObject).getInternalState();
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getLocalePrototype();
    }

    public static class InternalState {
        private Locale locale;
        String calendar;
        String caseFirst;
        String collation;
        String hourCycle;
        boolean numeric;
        String numberingSystem;

        @CompilerDirectives.TruffleBoundary
        public ULocale getULocale() {
            return ULocale.forLocale(this.locale);
        }

        @CompilerDirectives.TruffleBoundary
        public String getLocale() {
            return IntlUtil.maybeAppendMissingLanguageSubTag(this.locale.toLanguageTag());
        }

        @CompilerDirectives.TruffleBoundary
        public String getBaseName() {
            return this.locale.stripExtensions().toLanguageTag();
        }

        public String getCalendar() {
            return this.calendar;
        }

        public String getCaseFirst() {
            return this.caseFirst;
        }

        public String getCollation() {
            return this.collation;
        }

        public String getHourCycle() {
            return this.hourCycle;
        }

        public boolean getNumeric() {
            return this.numeric;
        }

        public String getNumberingSystem() {
            return this.numberingSystem;
        }

        @CompilerDirectives.TruffleBoundary
        public String getLanguage() {
            return this.locale.getLanguage();
        }

        @CompilerDirectives.TruffleBoundary
        public String getScript() {
            return this.locale.getScript();
        }

        @CompilerDirectives.TruffleBoundary
        public String getRegion() {
            return this.locale.getCountry();
        }

        @CompilerDirectives.TruffleBoundary
        public String maximize() {
            ULocale max = ULocale.addLikelySubtags(ULocale.forLocale(this.locale));
            Locale.Builder builder = new Locale.Builder().setLocale(this.locale);
            builder.setLanguage(max.getLanguage());
            builder.setScript(max.getScript());
            builder.setRegion(max.getCountry());
            return builder.build().toLanguageTag();
        }

        @CompilerDirectives.TruffleBoundary
        public String minimize() {
            ULocale max = ULocale.addLikelySubtags(ULocale.forLocale(this.locale));
            ULocale min = ULocale.minimizeSubtags(max);
            Locale.Builder builder = new Locale.Builder().setLocale(this.locale);
            builder.setLanguage(min.getLanguage());
            builder.setScript(min.getScript());
            builder.setRegion(min.getCountry());
            return builder.build().toLanguageTag();
        }
    }
}

