/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.ObjectPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantEmptyPrototypeArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBase;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import java.util.List;

public final class JSObjectPrototype
extends JSNonProxy {
    public static final String CLASS_NAME = "Object";
    public static final JSObjectPrototype INSTANCE = new JSObjectPrototype();
    public static final JSBuiltinsContainer BUILTINS = ObjectPrototypeBuiltins.BUILTINS;

    private JSObjectPrototype() {
    }

    public static DynamicObject create(JSContext context) {
        return JSObjectPrototype.create(context.makeEmptyShapeWithNullPrototype(INSTANCE));
    }

    public static boolean isJSObjectPrototype(Object obj) {
        return obj instanceof Instance;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public String toDisplayStringImpl(DynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        return this.defaultToString(obj);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        if (super.hasOwnProperty(thisObj, key)) {
            return true;
        }
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        if (JSRuntime.isArrayIndex(index)) {
            return JSObject.getArray(thisObj).hasElement(thisObj, index);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, long index) {
        ScriptArray array = JSObject.getArray(thisObj);
        if (array.hasElement(thisObj, index)) {
            return true;
        }
        return super.hasOwnProperty(thisObj, Boundaries.stringValueOf(index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index, Node encapsulatingNode) {
        ScriptArray array = JSObject.getArray(store);
        if (array.hasElement(store, index)) {
            return array.getElement(store, index);
        }
        return super.getOwnHelper(store, thisObj, Boundaries.stringValueOf(index), encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        long idx = JSRuntime.propertyKeyToArrayIndex(key);
        if (JSRuntime.isArrayIndex(idx)) {
            return this.getOwnHelper(store, thisObj, idx, encapsulatingNode);
        }
        return super.getOwnHelper(store, thisObj, key, encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        if (index >= 0L) {
            return this.delete(thisObj, index, isStrict);
        }
        return super.delete(thisObj, key, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        ScriptArray array = JSObject.getArray(thisObj);
        if (array.hasElement(thisObj, index)) {
            if (array.canDeleteElement(thisObj, index, isStrict)) {
                JSObject.setArray(thisObj, array.deleteElement(thisObj, index, isStrict));
                return true;
            }
            return false;
        }
        return JSOrdinary.INSTANCE.delete(thisObj, index, isStrict);
    }

    @Override
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        if (!strings || JSObject.getArray(thisObj).length(thisObj) == 0L) {
            return super.getOwnPropertyKeys(thisObj, strings, symbols);
        }
        return JSAbstractArray.ownPropertyKeysSlowArray(thisObj, strings, symbols);
    }

    @Override
    public boolean hasOnlyShapeProperties(DynamicObject thisObj) {
        return JSObject.getArray(thisObj).length(thisObj) == 0L;
    }

    @Override
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        return JSAbstractArray.ordinaryGetOwnPropertyArray(thisObj, key);
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }

    @Override
    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        return JSObject.getPrototype(thisObj) == newPrototype;
    }

    @Override
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        boolean result = super.set(thisObj, index, value, receiver, isStrict, encapsulatingNode);
        JSObject.getJSContext(thisObj).getArrayPrototypeNoElementsAssumption().invalidate("Array.prototype no element assumption");
        return result;
    }

    @Override
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        boolean result = super.set(thisObj, key, value, receiver, isStrict, encapsulatingNode);
        if (JSRuntime.isArrayIndex(key)) {
            JSObject.getJSContext(thisObj).getArrayPrototypeNoElementsAssumption().invalidate("Array.prototype no element assumption");
        }
        return result;
    }

    @Override
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        boolean result = super.defineOwnProperty(thisObj, key, desc, doThrow);
        if (JSRuntime.isArrayIndex(key)) {
            JSObject.getJSContext(thisObj).getArrayPrototypeNoElementsAssumption().invalidate("Array.prototype no element assumption");
        }
        return result;
    }

    public static DynamicObject create(Shape shape) {
        assert (JSShape.getJSClassNoCast(shape) == INSTANCE);
        return new Instance(shape);
    }

    public static final class Instance
    extends JSArrayBase {
        protected Instance(Shape shape) {
            super(shape, ConstantEmptyPrototypeArray.createConstantEmptyPrototypeArray(), ScriptArray.EMPTY_OBJECT_ARRAY, null, 0L, 0, 0, 0, 0);
        }
    }
}

