/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.promise.BuiltinPromiseRejectionTracker;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.Evaluator;
import com.oracle.truffle.js.runtime.ImportMetaInitializer;
import com.oracle.truffle.js.runtime.ImportModuleDynamicallyCallback;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSParserOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.MainJSAgent;
import com.oracle.truffle.js.runtime.PrepareStackTraceCallback;
import com.oracle.truffle.js.runtime.PromiseHook;
import com.oracle.truffle.js.runtime.PromiseRejectionTracker;
import com.oracle.truffle.js.runtime.RegexCompilerInterface;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.Builtin;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSDictionary;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistry;
import com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistryObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionFactory;
import com.oracle.truffle.js.runtime.builtins.JSGlobal;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.builtins.JSUncheckedProxyHandler;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.builtins.JSWeakRef;
import com.oracle.truffle.js.runtime.builtins.JSWeakSet;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollator;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNames;
import com.oracle.truffle.js.runtime.builtins.intl.JSListFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocale;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRules;
import com.oracle.truffle.js.runtime.builtins.intl.JSRelativeTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmenter;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobal;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstance;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModule;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import com.oracle.truffle.js.runtime.java.JavaImporter;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSPrototypeData;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.JSShapeData;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.CompilableBiFunction;
import com.oracle.truffle.js.runtime.util.DebugJSAgent;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import com.oracle.truffle.js.runtime.util.TimeProfiler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class JSContext {
    private final Evaluator evaluator;
    private final JavaScriptLanguage language;
    private TruffleLanguage.Env initialEnvironment;
    private final Shape emptyShape;
    private final Shape emptyShapePrototypeInObject;
    private final Shape promiseShapePrototypeInObject;
    private final Shape globalScopeShape;
    private Object embedderData;
    private final Assumption noSuchPropertyUnusedAssumption;
    private final Assumption noSuchMethodUnusedAssumption;
    private final Assumption arrayPrototypeNoElementsAssumption;
    private final Assumption fastArrayAssumption;
    private final Assumption fastArgumentsObjectAssumption;
    private final Assumption typedArrayNotDetachedAssumption;
    private final Assumption regExpStaticResultUnusedAssumption;
    private final Assumption globalObjectPristineAssumption;
    private volatile Map<String, Symbol> symbolRegistry;
    private int operatorCounter = 3;
    private final Object nodeFactory;
    private final TimeProfiler timeProfiler;
    private final JSObjectFactory.BoundProto moduleNamespaceFactory;
    @CompilerDirectives.CompilationFinal
    private Object tRegexEmptyResult;
    private final String regexOptions;
    private final String regexValidateOptions;
    private final Shape regExpGroupsEmptyShape;
    private PrepareStackTraceCallback prepareStackTraceCallback;
    private final Assumption prepareStackTraceCallbackNotUsedAssumption;
    private PromiseRejectionTracker promiseRejectionTracker;
    private final Assumption promiseRejectionTrackerNotUsedAssumption;
    private PromiseHook promiseHook;
    private final Assumption promiseHookNotUsedAssumption;
    private ImportMetaInitializer importMetaInitializer;
    private final Assumption importMetaInitializerNotUsedAssumption;
    private ImportModuleDynamicallyCallback importModuleDynamicallyCallback;
    private final Assumption importModuleDynamicallyCallbackNotUsedAssumption;
    private final CallTarget emptyFunctionCallTarget;
    private final CallTarget speciesGetterFunctionCallTarget;
    private volatile CallTarget notConstructibleCallTargetCache;
    private volatile CallTarget generatorNotConstructibleCallTargetCache;
    private volatile CallTarget boundFunctionCallTargetCache;
    private volatile CallTarget boundFunctionConstructTargetCache;
    private volatile CallTarget boundFunctionConstructNewTargetCache;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JSFunctionData[] builtinFunctionData;
    private volatile JSFunctionData boundFunctionData;
    private volatile JSFunctionData boundConstructorFunctionData;
    final JSFunctionData throwerFunctionData;
    final JSFunctionData protoGetterFunctionData;
    final JSFunctionData protoSetterFunctionData;
    private Map<Shape, JSShapeData> shapeDataMap;
    private final Assumption singleRealmAssumption;
    private final boolean isMultiContext;
    private final AtomicInteger realmInit = new AtomicInteger();
    private static final int REALM_UNINITIALIZED = 0;
    private static final int REALM_INITIALIZING = 1;
    private static final int REALM_INITIALIZED = 2;
    @CompilerDirectives.CompilationFinal
    private AllocationReporter allocationReporter;
    private final JSContextOptions contextOptions;
    private final Map<Builtin, JSFunctionData> builtinFunctionDataMap = new ConcurrentHashMap<Builtin, JSFunctionData>();
    private final JSPrototypeData nullPrototypeData = new JSPrototypeData();
    private final JSPrototypeData inObjectPrototypeData = new JSPrototypeData();
    private final JSFunctionFactory functionFactory;
    private final JSFunctionFactory constructorFactory;
    private final JSFunctionFactory strictFunctionFactory;
    private final JSFunctionFactory strictConstructorFactory;
    private final JSFunctionFactory generatorFunctionFactory;
    private final JSFunctionFactory asyncFunctionFactory;
    private final JSFunctionFactory asyncGeneratorFunctionFactory;
    private final JSFunctionFactory boundFunctionFactory;
    static final PrototypeSupplier functionPrototypeSupplier = JSRealm::getFunctionPrototype;
    static final PrototypeSupplier asyncFunctionPrototypeSupplier = JSRealm::getAsyncFunctionPrototype;
    static final PrototypeSupplier generatorFunctionPrototypeSupplier = JSRealm::getGeneratorFunctionPrototype;
    static final PrototypeSupplier asyncGeneratorFunctionPrototypeSupplier = JSRealm::getAsyncGeneratorFunctionPrototype;
    private final JSObjectFactory ordinaryObjectFactory;
    private final JSObjectFactory arrayFactory;
    private final JSObjectFactory lazyRegexArrayFactory;
    private final JSObjectFactory lazyRegexIndicesArrayFactory;
    private final JSObjectFactory booleanFactory;
    private final JSObjectFactory numberFactory;
    private final JSObjectFactory bigIntFactory;
    private final JSObjectFactory stringFactory;
    private final JSObjectFactory regExpFactory;
    private final JSObjectFactory dateFactory;
    private final JSObjectFactory nonStrictArgumentsFactory;
    private final JSObjectFactory strictArgumentsFactory;
    private final JSObjectFactory callSiteFactory;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JSObjectFactory[] errorObjectFactories;
    private final JSObjectFactory symbolFactory;
    private final JSObjectFactory mapFactory;
    private final JSObjectFactory setFactory;
    private final JSObjectFactory weakRefFactory;
    private final JSObjectFactory weakMapFactory;
    private final JSObjectFactory weakSetFactory;
    private final JSObjectFactory proxyFactory;
    private final JSObjectFactory uncheckedProxyHandlerFactory;
    private final JSObjectFactory promiseFactory;
    private final JSObjectFactory dataViewFactory;
    private final JSObjectFactory arrayBufferFactory;
    private final JSObjectFactory directArrayBufferFactory;
    private final JSObjectFactory sharedArrayBufferFactory;
    private final JSObjectFactory interopArrayBufferFactory;
    private final JSObjectFactory finalizationRegistryFactory;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JSObjectFactory[] typedArrayFactories;
    private final JSObjectFactory enumerateIteratorFactory;
    private final JSObjectFactory forInIteratorFactory;
    private final JSObjectFactory generatorObjectFactory;
    private final JSObjectFactory asyncGeneratorObjectFactory;
    private final JSObjectFactory asyncFromSyncIteratorFactory;
    private final JSObjectFactory collatorFactory;
    private final JSObjectFactory numberFormatFactory;
    private final JSObjectFactory pluralRulesFactory;
    private final JSObjectFactory dateTimeFormatFactory;
    private final JSObjectFactory listFormatFactory;
    private final JSObjectFactory relativeTimeFormatFactory;
    private final JSObjectFactory segmenterFactory;
    private final JSObjectFactory segmentsFactory;
    private final JSObjectFactory segmentIteratorFactory;
    private final JSObjectFactory displayNamesFactory;
    private final JSObjectFactory localeFactory;
    private final JSObjectFactory javaImporterFactory;
    private final JSObjectFactory javaPackageFactory;
    private final JSObjectFactory jsAdapterFactory;
    private final JSObjectFactory dictionaryObjectFactory;
    private final JSObjectFactory globalObjectFactory;
    private final JSObjectFactory webAssemblyModuleFactory;
    private final JSObjectFactory webAssemblyInstanceFactory;
    private final JSObjectFactory webAssemblyMemoryFactory;
    private final JSObjectFactory webAssemblyTableFactory;
    private final JSObjectFactory webAssemblyGlobalFactory;
    private final int factoryCount;
    @CompilerDirectives.CompilationFinal
    private Locale locale;
    private final PropertyProxy argumentsPropertyProxy;
    private final PropertyProxy callerPropertyProxy;
    private final Set<String> supportedImportAssertions;
    private static final String TYPE_IMPORT_ASSERTION = "type";
    private final SharedRootNode sharedRootNode;
    private static final String REGEX_OPTION_U180E_WHITESPACE = "U180EWhitespace";
    private static final String REGEX_OPTION_REGRESSION_TEST_MODE = "RegressionTestMode";
    private static final String REGEX_OPTION_DUMP_AUTOMATA = "DumpAutomata";
    private static final String REGEX_OPTION_STEP_EXECUTION = "StepExecution";
    private static final String REGEX_OPTION_ALWAYS_EAGER = "AlwaysEager";
    private static final String REGEX_OPTION_VALIDATE = "Validate=true";
    private DynamicObject parentPromise;

    protected JSContext(Evaluator evaluator, JSContextOptions contextOptions, JavaScriptLanguage lang, TruffleLanguage.Env env) {
        this.contextOptions = contextOptions;
        if (env != null) {
            this.setAllocationReporter(env);
            this.contextOptions.setOptionValues(env.getOptions());
        }
        this.language = lang;
        this.initialEnvironment = env;
        this.sharedRootNode = new SharedRootNode();
        this.emptyShape = this.createEmptyShape();
        this.emptyShapePrototypeInObject = this.createEmptyShapePrototypeInObject();
        this.promiseShapePrototypeInObject = this.createPromiseShapePrototypeInObject();
        this.globalScopeShape = this.createGlobalScopeShape();
        this.noSuchPropertyUnusedAssumption = Truffle.getRuntime().createAssumption("noSuchPropertyUnusedAssumption");
        this.noSuchMethodUnusedAssumption = Truffle.getRuntime().createAssumption("noSuchMethodUnusedAssumption");
        this.arrayPrototypeNoElementsAssumption = Truffle.getRuntime().createAssumption("arrayPrototypeNoElementsAssumption");
        this.typedArrayNotDetachedAssumption = Truffle.getRuntime().createAssumption("typedArrayNotDetachedAssumption");
        this.fastArrayAssumption = Truffle.getRuntime().createAssumption("fastArrayAssumption");
        this.fastArgumentsObjectAssumption = Truffle.getRuntime().createAssumption("fastArgumentsObjectAssumption");
        this.regExpStaticResultUnusedAssumption = Truffle.getRuntime().createAssumption("regExpStaticResultUnusedAssumption");
        this.globalObjectPristineAssumption = Truffle.getRuntime().createAssumption("globalObjectPristineAssumption");
        this.evaluator = evaluator;
        this.nodeFactory = evaluator.getDefaultNodeFactory();
        this.moduleNamespaceFactory = JSObjectFactory.createBound(this, Null.instance, JSModuleNamespace.makeInitialShape(this));
        this.prepareStackTraceCallbackNotUsedAssumption = Truffle.getRuntime().createAssumption("prepareStackTraceCallbackNotUsedAssumption");
        this.promiseHookNotUsedAssumption = Truffle.getRuntime().createAssumption("promiseHookNotUsedAssumption");
        this.promiseRejectionTrackerNotUsedAssumption = Truffle.getRuntime().createAssumption("promiseRejectionTrackerNotUsedAssumption");
        this.importMetaInitializerNotUsedAssumption = Truffle.getRuntime().createAssumption("importMetaInitializerNotUsedAssumption");
        this.importModuleDynamicallyCallbackNotUsedAssumption = Truffle.getRuntime().createAssumption("importModuleDynamicallyCallbackNotUsedAssumption");
        this.emptyFunctionCallTarget = JSContext.createEmptyFunctionCallTarget(lang);
        this.speciesGetterFunctionCallTarget = JSContext.createSpeciesGetterFunctionCallTarget(lang);
        this.builtinFunctionData = new JSFunctionData[BuiltinFunctionKey.values().length];
        this.timeProfiler = contextOptions.isProfileTime() ? new TimeProfiler() : null;
        this.singleRealmAssumption = Truffle.getRuntime().createAssumption("single realm");
        this.throwerFunctionData = this.throwTypeErrorFunction();
        boolean annexB = this.isOptionAnnexB();
        this.protoGetterFunctionData = annexB ? this.protoGetterFunction() : null;
        this.protoSetterFunctionData = annexB ? this.protoSetterFunction() : null;
        this.isMultiContext = lang.isMultiContext();
        JSOrdinary objectPrototypeSupplier = JSOrdinary.INSTANCE;
        CompilableBiFunction<JSContext, DynamicObject, Shape> ordinaryObjectShapeSupplier = JSOrdinary.SHAPE_SUPPLIER;
        JSObjectFactory.IntrinsicBuilder builder = new JSObjectFactory.IntrinsicBuilder(this);
        this.functionFactory = builder.function(functionPrototypeSupplier, false, false, false, false, false);
        this.constructorFactory = builder.function(functionPrototypeSupplier, false, true, false, false, false);
        this.strictFunctionFactory = builder.function(functionPrototypeSupplier, true, false, false, false, false);
        this.strictConstructorFactory = builder.function(functionPrototypeSupplier, true, true, false, false, false);
        this.asyncFunctionFactory = builder.function(asyncFunctionPrototypeSupplier, true, false, false, false, true);
        this.generatorFunctionFactory = builder.function(generatorFunctionPrototypeSupplier, true, false, true, false, false);
        this.asyncGeneratorFunctionFactory = builder.function(asyncGeneratorFunctionPrototypeSupplier, true, false, true, false, true);
        this.boundFunctionFactory = builder.function(functionPrototypeSupplier, true, false, false, true, false);
        this.ordinaryObjectFactory = builder.create(JSOrdinary.INSTANCE);
        this.arrayFactory = builder.create(JSArray.INSTANCE);
        this.lazyRegexArrayFactory = builder.create(JSArray.INSTANCE);
        this.lazyRegexIndicesArrayFactory = builder.create(JSArray.INSTANCE);
        this.booleanFactory = builder.create(JSBoolean.INSTANCE);
        this.numberFactory = builder.create(JSNumber.INSTANCE);
        this.bigIntFactory = builder.create(JSBigInt.INSTANCE);
        this.stringFactory = builder.create(JSString.INSTANCE);
        this.regExpFactory = builder.create(JSRegExp.INSTANCE);
        this.dateFactory = builder.create(JSDate.INSTANCE);
        this.symbolFactory = builder.create(JSSymbol.INSTANCE);
        this.mapFactory = builder.create(JSMap.INSTANCE);
        this.setFactory = builder.create(JSSet.INSTANCE);
        this.weakRefFactory = builder.create(JSWeakRef.INSTANCE);
        this.weakMapFactory = builder.create(JSWeakMap.INSTANCE);
        this.weakSetFactory = builder.create(JSWeakSet.INSTANCE);
        this.proxyFactory = builder.create(JSProxy.INSTANCE);
        this.uncheckedProxyHandlerFactory = builder.create(JSUncheckedProxyHandler.INSTANCE);
        this.promiseFactory = builder.create(JSPromise.INSTANCE);
        this.dataViewFactory = builder.create(JSDataView.INSTANCE);
        this.arrayBufferFactory = builder.create(JSArrayBuffer.HEAP_INSTANCE);
        this.directArrayBufferFactory = builder.create(JSArrayBuffer.DIRECT_INSTANCE);
        this.sharedArrayBufferFactory = this.isOptionSharedArrayBuffer() ? builder.create(JSSharedArrayBuffer.INSTANCE) : null;
        this.interopArrayBufferFactory = builder.create(JSArrayBuffer.INTEROP_INSTANCE);
        this.finalizationRegistryFactory = builder.create(JSFinalizationRegistry.INSTANCE);
        this.typedArrayFactories = new JSObjectFactory[TypedArray.factories(this).length];
        for (TypedArrayFactory typedArrayFactory : TypedArray.factories(this)) {
            this.typedArrayFactories[typedArrayFactory.getFactoryIndex()] = builder.create((PrototypeSupplier)typedArrayFactory, (c, p) -> JSArrayBufferView.makeInitialArrayBufferViewShape(c, p));
        }
        this.errorObjectFactories = new JSObjectFactory[JSErrorType.errorTypes().length];
        for (Enum enum_ : JSErrorType.errorTypes()) {
            this.errorObjectFactories[enum_.ordinal()] = builder.create((PrototypeSupplier)((Object)enum_), JSError.INSTANCE::makeInitialShape);
        }
        this.callSiteFactory = builder.create(JSRealm::getCallSitePrototype, JSError::makeInitialCallSiteShape);
        this.nonStrictArgumentsFactory = builder.create((PrototypeSupplier)objectPrototypeSupplier, JSArgumentsArray.INSTANCE);
        this.strictArgumentsFactory = builder.create((PrototypeSupplier)objectPrototypeSupplier, JSArgumentsArray.INSTANCE);
        this.enumerateIteratorFactory = builder.create(JSRealm::getEnumerateIteratorPrototype, JSFunction::makeInitialEnumerateIteratorShape);
        this.forInIteratorFactory = builder.create(JSRealm::getForInIteratorPrototype, JSFunction::makeInitialForInIteratorShape);
        this.generatorObjectFactory = builder.create(JSRealm::getGeneratorObjectPrototype, ordinaryObjectShapeSupplier);
        this.asyncGeneratorObjectFactory = builder.create(JSRealm::getAsyncGeneratorObjectPrototype, ordinaryObjectShapeSupplier);
        this.asyncFromSyncIteratorFactory = builder.create(JSRealm::getAsyncFromSyncIteratorPrototype, ordinaryObjectShapeSupplier);
        this.collatorFactory = builder.create(JSCollator.INSTANCE);
        this.numberFormatFactory = builder.create(JSNumberFormat.INSTANCE);
        this.dateTimeFormatFactory = builder.create(JSDateTimeFormat.INSTANCE);
        this.pluralRulesFactory = builder.create(JSPluralRules.INSTANCE);
        this.listFormatFactory = builder.create(JSListFormat.INSTANCE);
        this.relativeTimeFormatFactory = builder.create(JSRelativeTimeFormat.INSTANCE);
        this.segmenterFactory = builder.create(JSSegmenter.INSTANCE);
        this.segmentsFactory = builder.create(JSRealm::getSegmentsPrototype, JSSegmenter::makeInitialSegmentsShape);
        this.segmentIteratorFactory = builder.create(JSRealm::getSegmentIteratorPrototype, JSSegmenter::makeInitialSegmentIteratorShape);
        this.displayNamesFactory = builder.create(JSDisplayNames.INSTANCE);
        this.localeFactory = builder.create(JSLocale.INSTANCE);
        this.javaPackageFactory = builder.create((PrototypeSupplier)objectPrototypeSupplier, JavaPackage.INSTANCE::makeInitialShape);
        boolean nashornCompat = this.isOptionNashornCompatibilityMode();
        this.jsAdapterFactory = nashornCompat ? builder.create(JSAdapter.INSTANCE) : null;
        this.javaImporterFactory = nashornCompat ? builder.create(JavaImporter.instance()) : null;
        this.dictionaryObjectFactory = builder.create((PrototypeSupplier)objectPrototypeSupplier, JSDictionary::makeDictionaryShape);
        this.globalObjectFactory = builder.create((PrototypeSupplier)objectPrototypeSupplier, JSGlobal::makeGlobalObjectShape);
        this.webAssemblyModuleFactory = builder.create(JSWebAssemblyModule.INSTANCE);
        this.webAssemblyInstanceFactory = builder.create(JSWebAssemblyInstance.INSTANCE);
        this.webAssemblyMemoryFactory = builder.create(JSWebAssemblyMemory.INSTANCE);
        this.webAssemblyTableFactory = builder.create(JSWebAssemblyTable.INSTANCE);
        this.webAssemblyGlobalFactory = builder.create(JSWebAssemblyGlobal.INSTANCE);
        this.factoryCount = builder.finish();
        this.argumentsPropertyProxy = new JSFunction.ArgumentsProxyProperty(this);
        this.callerPropertyProxy = new JSFunction.CallerProxyProperty(this);
        this.regExpGroupsEmptyShape = JSRegExp.makeInitialGroupsObjectShape(this);
        this.regexOptions = JSContext.createRegexOptions(contextOptions);
        this.regexValidateOptions = this.regexOptions.isEmpty() ? REGEX_OPTION_VALIDATE : "Validate=true," + this.regexOptions;
        HashSet hashSet = this.supportedImportAssertions = contextOptions.isImportAssertions() ? new HashSet() : Collections.emptySet();
        if (contextOptions.isImportAssertions()) {
            this.supportedImportAssertions.add(TYPE_IMPORT_ASSERTION);
        }
        if (contextOptions.getUnhandledRejectionsMode() != JSContextOptions.UnhandledRejectionsTrackingMode.NONE) {
            this.setPromiseRejectionTracker(new BuiltinPromiseRejectionTracker(this, contextOptions.getUnhandledRejectionsMode()));
        }
    }

    public final Evaluator getEvaluator() {
        return this.evaluator;
    }

    public Object getNodeFactory() {
        return this.nodeFactory;
    }

    public final JSParserOptions getParserOptions() {
        return this.contextOptions.getParserOptions();
    }

    public final Object getEmbedderData() {
        return this.embedderData;
    }

    public final void setEmbedderData(Object embedderData) {
        this.embedderData = embedderData;
    }

    public final Assumption getNoSuchPropertyUnusedAssumption() {
        return this.noSuchPropertyUnusedAssumption;
    }

    public final Assumption getNoSuchMethodUnusedAssumption() {
        return this.noSuchMethodUnusedAssumption;
    }

    public final Assumption getArrayPrototypeNoElementsAssumption() {
        return this.arrayPrototypeNoElementsAssumption;
    }

    public final Assumption getFastArrayAssumption() {
        return this.fastArrayAssumption;
    }

    public final Assumption getFastArgumentsObjectAssumption() {
        return this.fastArgumentsObjectAssumption;
    }

    public final Assumption getTypedArrayNotDetachedAssumption() {
        return this.typedArrayNotDetachedAssumption;
    }

    public final Assumption getRegExpStaticResultUnusedAssumption() {
        return this.regExpStaticResultUnusedAssumption;
    }

    public final Assumption getGlobalObjectPristineAssumption() {
        return this.globalObjectPristineAssumption;
    }

    public static JSContext createContext(Evaluator evaluator, JSContextOptions contextOptions, JavaScriptLanguage lang, TruffleLanguage.Env env) {
        return new JSContext(evaluator, contextOptions, lang, env);
    }

    public JSRealm createRealm(TruffleLanguage.Env env) {
        return this.createRealm(env, null);
    }

    protected JSRealm createRealm(TruffleLanguage.Env env, JSRealm parentRealm) {
        boolean isTop = parentRealm == null;
        this.realmInit.compareAndSet(0, 1);
        if (!isTop) {
            this.singleRealmAssumption.invalidate("creating another realm");
        }
        JSRealm newRealm = new JSRealm(this, env, parentRealm);
        newRealm.setupGlobals();
        if (isTop) {
            if (this.contextOptions.isTest262Mode() || this.contextOptions.isTestV8Mode()) {
                newRealm.setAgent(new DebugJSAgent(this.contextOptions.canAgentBlock(), env.getOptions()));
            } else {
                newRealm.setAgent(new MainJSAgent(newRealm.getContext().getPromiseRejectionTracker()));
            }
            if (this.contextOptions.isV8RealmBuiltin()) {
                newRealm.initRealmList();
                newRealm.addToRealmList(newRealm);
            }
        }
        this.realmInit.set(2);
        return newRealm;
    }

    public final Shape createEmptyShape() {
        return this.makeEmptyShapeWithNullPrototype(JSOrdinary.INSTANCE);
    }

    private Shape createEmptyShapePrototypeInObject() {
        return this.makeEmptyShapeWithPrototypeInObject(JSOrdinary.INSTANCE);
    }

    private Shape createPromiseShapePrototypeInObject() {
        return this.makeEmptyShapeWithPrototypeInObject(JSPromise.INSTANCE);
    }

    public final Shape makeEmptyShapeWithNullPrototype(JSClass jsclass) {
        Shape protoChildTree = this.nullPrototypeData.getProtoChildTree(jsclass);
        if (protoChildTree != null) {
            return protoChildTree;
        }
        return this.nullPrototypeData.getOrAddProtoChildTree(jsclass, JSShape.makeEmptyRoot(jsclass, this));
    }

    public final Shape makeEmptyShapeWithPrototypeInObject(JSClass jsclass) {
        Shape protoChildTree = this.inObjectPrototypeData.getProtoChildTree(jsclass);
        if (protoChildTree != null) {
            return protoChildTree;
        }
        return this.inObjectPrototypeData.getOrAddProtoChildTree(jsclass, JSShape.makeEmptyRootWithInstanceProto(this, jsclass));
    }

    private Shape createGlobalScopeShape() {
        return JSShape.makeEmptyRoot(JSGlobal.INSTANCE, this);
    }

    public final Map<String, Symbol> getSymbolRegistry() {
        if (this.symbolRegistry == null) {
            this.createSymbolRegistry();
        }
        return this.symbolRegistry;
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void createSymbolRegistry() {
        if (this.symbolRegistry == null) {
            this.symbolRegistry = new HashMap<String, Symbol>();
        }
    }

    public int getOperatorCounter() {
        return this.operatorCounter;
    }

    public int incOperatorCounter() {
        return this.operatorCounter++;
    }

    public final void promiseEnqueueJob(JSRealm realm, DynamicObject job) {
        this.invalidatePromiseQueueNotUsedAssumption();
        realm.getAgent().enqueuePromiseJob(job);
    }

    public final void signalAsyncWaiterRecordUsage() {
        this.invalidatePromiseQueueNotUsedAssumption();
    }

    private void invalidatePromiseQueueNotUsedAssumption() {
        Assumption promiseJobsQueueEmptyAssumption = this.language.getPromiseJobsQueueEmptyAssumption();
        if (promiseJobsQueueEmptyAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            promiseJobsQueueEmptyAssumption.invalidate();
        }
    }

    public final void processAllPendingPromiseJobs(JSRealm realm) {
        if (!this.language.getPromiseJobsQueueEmptyAssumption().isValid()) {
            realm.getAgent().processAllPromises(false);
        }
    }

    public boolean addWeakRefTargetToSet(Object target) {
        this.invalidatePromiseQueueNotUsedAssumption();
        return this.getJSAgent().addWeakRefTargetToSet(target);
    }

    public void registerFinalizationRegistry(JSFinalizationRegistryObject finalizationRegistry) {
        this.invalidatePromiseQueueNotUsedAssumption();
        this.getJSAgent().registerFinalizationRegistry(finalizationRegistry);
    }

    public TimeProfiler getTimeProfiler() {
        return this.timeProfiler;
    }

    private JSRealm getRealm() {
        assert (this.realmInit.get() == 2) : "getRealm() while initializing Realm";
        JSRealm currentRealm = JSRealm.get(null);
        assert (currentRealm != null);
        return currentRealm;
    }

    public final Shape getEmptyShapeNullPrototype() {
        return this.emptyShape;
    }

    public final Shape getEmptyShapePrototypeInObject() {
        return this.emptyShapePrototypeInObject;
    }

    public final Shape getPromiseShapePrototypeInObject() {
        return this.promiseShapePrototypeInObject;
    }

    public final Shape getGlobalScopeShape() {
        return this.globalScopeShape;
    }

    public final JSObjectFactory getOrdinaryObjectFactory() {
        return this.ordinaryObjectFactory;
    }

    public final JSObjectFactory getArrayFactory() {
        return this.arrayFactory;
    }

    public final JSObjectFactory getLazyRegexArrayFactory() {
        return this.lazyRegexArrayFactory;
    }

    public final JSObjectFactory getLazyRegexIndicesArrayFactory() {
        return this.lazyRegexIndicesArrayFactory;
    }

    public final JSObjectFactory getStringFactory() {
        return this.stringFactory;
    }

    public final JSObjectFactory getBooleanFactory() {
        return this.booleanFactory;
    }

    public final JSObjectFactory getNumberFactory() {
        return this.numberFactory;
    }

    public final JSObjectFactory getBigIntFactory() {
        return this.bigIntFactory;
    }

    public final JSObjectFactory getSymbolFactory() {
        return this.symbolFactory;
    }

    public final JSObjectFactory getArrayBufferViewFactory(TypedArrayFactory factory) {
        return this.typedArrayFactories[factory.getFactoryIndex()];
    }

    public final JSObjectFactory getArrayBufferFactory() {
        return this.arrayBufferFactory;
    }

    public final JSObjectFactory getDirectArrayBufferFactory() {
        return this.directArrayBufferFactory;
    }

    public final JSObjectFactory getRegExpFactory() {
        return this.regExpFactory;
    }

    public final JSObjectFactory getDateFactory() {
        return this.dateFactory;
    }

    public final JSObjectFactory getEnumerateIteratorFactory() {
        return this.enumerateIteratorFactory;
    }

    public final JSObjectFactory getForInIteratorFactory() {
        return this.forInIteratorFactory;
    }

    public final JSObjectFactory getMapFactory() {
        return this.mapFactory;
    }

    public final JSObjectFactory getFinalizationRegistryFactory() {
        return this.finalizationRegistryFactory;
    }

    public final JSObjectFactory getWeakRefFactory() {
        return this.weakRefFactory;
    }

    public final JSObjectFactory getWeakMapFactory() {
        return this.weakMapFactory;
    }

    public final JSObjectFactory getSetFactory() {
        return this.setFactory;
    }

    public final JSObjectFactory getWeakSetFactory() {
        return this.weakSetFactory;
    }

    public final JSObjectFactory getDataViewFactory() {
        return this.dataViewFactory;
    }

    public final JSObjectFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public final JSObjectFactory getUncheckedProxyHandlerFactory() {
        return this.uncheckedProxyHandlerFactory;
    }

    public final JSObjectFactory getSharedArrayBufferFactory() {
        assert (this.isOptionSharedArrayBuffer());
        return this.sharedArrayBufferFactory;
    }

    public JSObjectFactory getInteropArrayBufferFactory() {
        return this.interopArrayBufferFactory;
    }

    public final JSObjectFactory getNonStrictArgumentsFactory() {
        return this.nonStrictArgumentsFactory;
    }

    public final JSObjectFactory getStrictArgumentsFactory() {
        return this.strictArgumentsFactory;
    }

    public final JSObjectFactory getCallSiteFactory() {
        return this.callSiteFactory;
    }

    public final JSObjectFactory getErrorFactory(JSErrorType type) {
        return this.errorObjectFactories[type.ordinal()];
    }

    public final JSObjectFactory getPromiseFactory() {
        return this.promiseFactory;
    }

    public final JSObjectFactory.BoundProto getModuleNamespaceFactory() {
        return this.moduleNamespaceFactory;
    }

    public final JSObjectFactory getGeneratorObjectFactory() {
        return this.generatorObjectFactory;
    }

    public final JSObjectFactory getAsyncGeneratorObjectFactory() {
        return this.asyncGeneratorObjectFactory;
    }

    public final JSObjectFactory getAsyncFromSyncIteratorFactory() {
        return this.asyncFromSyncIteratorFactory;
    }

    public final JSObjectFactory getCollatorFactory() {
        return this.collatorFactory;
    }

    public final JSObjectFactory getNumberFormatFactory() {
        return this.numberFormatFactory;
    }

    public final JSObjectFactory getPluralRulesFactory() {
        return this.pluralRulesFactory;
    }

    public final JSObjectFactory getListFormatFactory() {
        return this.listFormatFactory;
    }

    public final JSObjectFactory getRelativeTimeFormatFactory() {
        return this.relativeTimeFormatFactory;
    }

    public final JSObjectFactory getSegmenterFactory() {
        return this.segmenterFactory;
    }

    public final JSObjectFactory getSegmentsFactory() {
        return this.segmentsFactory;
    }

    public final JSObjectFactory getSegmentIteratorFactory() {
        return this.segmentIteratorFactory;
    }

    public final JSObjectFactory getDisplayNamesFactory() {
        return this.displayNamesFactory;
    }

    public final JSObjectFactory getLocaleFactory() {
        return this.localeFactory;
    }

    public final JSObjectFactory getDateTimeFormatFactory() {
        return this.dateTimeFormatFactory;
    }

    public final JSObjectFactory getJavaImporterFactory() {
        return this.javaImporterFactory;
    }

    public final JSObjectFactory getJSAdapterFactory() {
        return this.jsAdapterFactory;
    }

    public final JSObjectFactory getJavaPackageFactory() {
        return this.javaPackageFactory;
    }

    public JSObjectFactory getDictionaryObjectFactory() {
        return this.dictionaryObjectFactory;
    }

    public JSObjectFactory getGlobalObjectFactory() {
        return this.globalObjectFactory;
    }

    public JSObjectFactory getWebAssemblyModuleFactory() {
        return this.webAssemblyModuleFactory;
    }

    public JSObjectFactory getWebAssemblyInstanceFactory() {
        return this.webAssemblyInstanceFactory;
    }

    public JSObjectFactory getWebAssemblyMemoryFactory() {
        return this.webAssemblyMemoryFactory;
    }

    public JSObjectFactory getWebAssemblyTableFactory() {
        return this.webAssemblyTableFactory;
    }

    public JSObjectFactory getWebAssemblyGlobalFactory() {
        return this.webAssemblyGlobalFactory;
    }

    private static String createRegexOptions(JSContextOptions contextOptions) {
        StringBuilder options = new StringBuilder();
        if (contextOptions.isRegexRegressionTestMode()) {
            options.append("RegressionTestMode=true,");
        }
        if (contextOptions.isRegexDumpAutomata()) {
            options.append("DumpAutomata=true,");
        }
        if (contextOptions.isRegexStepExecution()) {
            options.append("StepExecution=true,");
        }
        if (contextOptions.isRegexAlwaysEager()) {
            options.append("AlwaysEager=true,");
        }
        return options.toString();
    }

    public String getRegexOptions() {
        return this.regexOptions;
    }

    public String getRegexValidateOptions() {
        return this.regexValidateOptions;
    }

    public Object getTRegexEmptyResult() {
        if (this.tRegexEmptyResult == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.tRegexEmptyResult = TRegexUtil.InvokeExecMethodNode.getUncached().execute(RegexCompilerInterface.compile("[]", "", this, JSRealm.get(null)), "", 0L);
            assert (!TRegexUtil.TRegexResultAccessor.getUncached().isMatch(this.tRegexEmptyResult));
        }
        return this.tRegexEmptyResult;
    }

    public Shape getRegExpGroupsEmptyShape() {
        return this.regExpGroupsEmptyShape;
    }

    public void setSymbolRegistry(Map<String, Symbol> newSymbolRegistry) {
        this.symbolRegistry = newSymbolRegistry;
    }

    public Map<Shape, JSShapeData> getShapeDataMap() {
        assert (Thread.holdsLock(this));
        Map<Shape, JSShapeData> map = this.shapeDataMap;
        if (map == null) {
            map = this.createShapeDataMap();
        }
        return map;
    }

    private Map<Shape, JSShapeData> createShapeDataMap() {
        CompilerAsserts.neverPartOfCompilation();
        WeakHashMap<Shape, JSShapeData> map = new WeakHashMap<Shape, JSShapeData>();
        this.shapeDataMap = map;
        return map;
    }

    public JavaScriptLanguage getLanguage() {
        return this.language;
    }

    private TruffleLanguage.Env getInitialEnvironment() {
        return this.initialEnvironment;
    }

    public void clearInitialEnvironment() {
        this.initialEnvironment = null;
    }

    public CallTarget getEmptyFunctionCallTarget() {
        return this.emptyFunctionCallTarget;
    }

    private static CallTarget createEmptyFunctionCallTarget(JavaScriptLanguage lang) {
        return new JavaScriptRootNode(lang, null, null){

            public Object execute(VirtualFrame frame) {
                return Undefined.instance;
            }
        }.getCallTarget();
    }

    public CallTarget getSpeciesGetterFunctionCallTarget() {
        return this.speciesGetterFunctionCallTarget;
    }

    private static CallTarget createSpeciesGetterFunctionCallTarget(JavaScriptLanguage lang) {
        return new JavaScriptRootNode(lang, null, null){

            public Object execute(VirtualFrame frame) {
                return JSFrameUtil.getThisObj((Frame)frame);
            }
        }.getCallTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public CallTarget getNotConstructibleCallTarget() {
        CallTarget result = this.notConstructibleCallTargetCache;
        if (result == null) {
            JSContext jSContext = this;
            synchronized (jSContext) {
                result = this.notConstructibleCallTargetCache;
                if (result == null) {
                    result = this.notConstructibleCallTargetCache = JSContext.createNotConstructibleCallTarget(this.getLanguage(), false, this);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public CallTarget getGeneratorNotConstructibleCallTarget() {
        CallTarget result = this.generatorNotConstructibleCallTargetCache;
        if (result == null) {
            JSContext jSContext = this;
            synchronized (jSContext) {
                result = this.generatorNotConstructibleCallTargetCache;
                if (result == null) {
                    result = this.generatorNotConstructibleCallTargetCache = JSContext.createNotConstructibleCallTarget(this.getLanguage(), true, this);
                }
            }
        }
        return result;
    }

    private static RootCallTarget createNotConstructibleCallTarget(JavaScriptLanguage lang, final boolean generator, final JSContext context) {
        return new JavaScriptRootNode(lang, null, null){

            public Object execute(VirtualFrame frame) {
                if (generator) {
                    throw Errors.createTypeError("cannot construct a generator");
                }
                throw Errors.createTypeErrorNotAConstructor(JSArguments.getFunctionObject(frame.getArguments()), context);
            }
        }.getCallTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public CallTarget getBoundFunctionCallTarget() {
        CallTarget result = this.boundFunctionCallTargetCache;
        if (result == null) {
            JSContext jSContext = this;
            synchronized (jSContext) {
                result = this.boundFunctionCallTargetCache;
                if (result == null) {
                    result = this.boundFunctionCallTargetCache = JSFunction.createBoundRootNode(this, false, false).getCallTarget();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public CallTarget getBoundFunctionConstructTarget() {
        CallTarget result = this.boundFunctionConstructTargetCache;
        if (result == null) {
            JSContext jSContext = this;
            synchronized (jSContext) {
                result = this.boundFunctionConstructTargetCache;
                if (result == null) {
                    result = this.boundFunctionConstructTargetCache = JSFunction.createBoundRootNode(this, true, false).getCallTarget();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public CallTarget getBoundFunctionConstructNewTarget() {
        CallTarget result = this.boundFunctionConstructNewTargetCache;
        if (result == null) {
            JSContext jSContext = this;
            synchronized (jSContext) {
                result = this.boundFunctionConstructNewTargetCache;
                if (result == null) {
                    result = this.boundFunctionConstructNewTargetCache = JSFunction.createBoundRootNode(this, true, true).getCallTarget();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSFunctionData getBoundFunctionData(boolean constructor) {
        JSFunctionData result;
        JSFunctionData jSFunctionData = result = constructor ? this.boundConstructorFunctionData : this.boundFunctionData;
        if (result == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            JSContext jSContext = this;
            synchronized (jSContext) {
                JSFunctionData jSFunctionData2 = result = constructor ? this.boundConstructorFunctionData : this.boundFunctionData;
                if (result == null) {
                    result = JSFunctionData.create(this, this.getBoundFunctionCallTarget(), this.getBoundFunctionConstructTarget(), this.getBoundFunctionConstructNewTarget(), 0, "bound", constructor, false, true, false, false, false, false, false, true, false, true);
                    if (constructor) {
                        this.boundConstructorFunctionData = result;
                    } else {
                        this.boundFunctionData = result;
                    }
                }
            }
        }
        return result;
    }

    private JSAgent getJSAgent() {
        return this.getRealm().getAgent();
    }

    public int getEcmaScriptVersion() {
        return this.contextOptions.getEcmaScriptVersion();
    }

    public int getPropertyCacheLimit() {
        return this.contextOptions.getPropertyCacheLimit();
    }

    public int getFunctionCacheLimit() {
        return this.contextOptions.getFunctionCacheLimit();
    }

    void setAllocationReporter(TruffleLanguage.Env env) {
        CompilerAsserts.neverPartOfCompilation();
        this.allocationReporter = (AllocationReporter)env.lookup(AllocationReporter.class);
    }

    public final AllocationReporter getAllocationReporter() {
        assert (this.realmInit.get() == 2) : "getAllocationReporter() during Realm initialization";
        return this.allocationReporter;
    }

    public final <T> T trackAllocation(T object) {
        AllocationReporter reporter = this.getAllocationReporter();
        if (reporter != null) {
            reporter.onEnter(null, 0L, Long.MIN_VALUE);
            reporter.onReturnValue(object, 0L, Long.MIN_VALUE);
        }
        return object;
    }

    public boolean isOptionAnnexB() {
        return this.contextOptions.isAnnexB();
    }

    public boolean isOptionIntl402() {
        assert (this.getInitialEnvironment() == null || !this.getInitialEnvironment().isPreInitialization()) : "Patchable option intl-402 accessed during context pre-initialization.";
        return this.contextOptions.isIntl402();
    }

    public boolean isOptionRegexpMatchIndices() {
        return this.contextOptions.isRegexpMatchIndices();
    }

    public boolean isOptionRegexpStaticResult() {
        assert (this.getInitialEnvironment() == null || !this.getInitialEnvironment().isPreInitialization()) : "Patchable option static-regex-result accessed during context pre-initialization.";
        return this.contextOptions.isRegexpStaticResult();
    }

    public boolean isOptionRegexpStaticResultInContextInit() {
        return this.contextOptions.isRegexpStaticResult();
    }

    public boolean isOptionSharedArrayBuffer() {
        return this.contextOptions.isSharedArrayBuffer();
    }

    public boolean isOptionAtomics() {
        return this.contextOptions.isAtomics();
    }

    public boolean isOptionV8CompatibilityMode() {
        assert (this.getInitialEnvironment() == null || !this.getInitialEnvironment().isPreInitialization()) : "Patchable option v8-compat accessed during context pre-initialization.";
        return this.contextOptions.isV8CompatibilityMode();
    }

    public boolean isOptionV8CompatibilityModeInContextInit() {
        return this.contextOptions.isV8CompatibilityMode();
    }

    public boolean isOptionNashornCompatibilityMode() {
        return this.contextOptions.isNashornCompatibilityMode();
    }

    public boolean isOptionDebugBuiltin() {
        return this.contextOptions.isDebugBuiltin();
    }

    public boolean isOptionMleBuiltin() {
        return this.contextOptions.isMLEMode();
    }

    public boolean isOptionDirectByteBuffer() {
        assert (this.getInitialEnvironment() == null || !this.getInitialEnvironment().isPreInitialization()) : "Patchable option direct-byte-buffer accessed during context pre-initialization.";
        return this.contextOptions.isDirectByteBuffer();
    }

    public boolean isOptionParseOnly() {
        return this.contextOptions.isParseOnly();
    }

    public boolean isOptionDisableEval() {
        return this.contextOptions.isDisableEval();
    }

    public boolean isOptionDisableWith() {
        return this.contextOptions.isDisableWith();
    }

    public boolean isOptionAsyncStackTraces() {
        return this.contextOptions.isAsyncStackTraces();
    }

    public long getTimerResolution() {
        assert (this.getInitialEnvironment() == null || !this.getInitialEnvironment().isPreInitialization()) : "Patchable option timer-resolution accessed during context pre-initialization.";
        return this.contextOptions.getTimerResolution();
    }

    public long getFunctionArgumentsLimit() {
        return this.contextOptions.getFunctionArgumentsLimit();
    }

    public int getStringLengthLimit() {
        return this.contextOptions.getStringLengthLimit();
    }

    public boolean usePromiseResolve() {
        return this.contextOptions.isAwaitOptimization();
    }

    public final void setPrepareStackTraceCallback(PrepareStackTraceCallback callback) {
        this.invalidatePrepareStackTraceCallbackNotUsedAssumption();
        this.prepareStackTraceCallback = callback;
    }

    public final PrepareStackTraceCallback getPrepareStackTraceCallback() {
        return this.prepareStackTraceCallbackNotUsedAssumption.isValid() ? null : this.prepareStackTraceCallback;
    }

    private void invalidatePrepareStackTraceCallbackNotUsedAssumption() {
        if (this.prepareStackTraceCallbackNotUsedAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.prepareStackTraceCallbackNotUsedAssumption.invalidate("prepare stack trace callback unused");
        }
    }

    public PromiseRejectionTracker getPromiseRejectionTracker() {
        return this.promiseRejectionTracker;
    }

    public final void setPromiseRejectionTracker(PromiseRejectionTracker tracker) {
        this.invalidatePromiseRejectionTrackerNotUsedAssumption();
        this.promiseRejectionTracker = tracker;
    }

    private void invalidatePromiseRejectionTrackerNotUsedAssumption() {
        if (this.promiseRejectionTrackerNotUsedAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.promiseRejectionTrackerNotUsedAssumption.invalidate("promise rejection tracker unused");
        }
    }

    public void notifyPromiseRejectionTracker(DynamicObject promise, int operation, Object value) {
        if (!this.promiseRejectionTrackerNotUsedAssumption.isValid() && this.promiseRejectionTracker != null) {
            switch (operation) {
                case 0: {
                    this.invokePromiseRejected(promise, value);
                    break;
                }
                case 1: {
                    this.invokePromiseRejectionHandled(promise);
                    break;
                }
                case 2: {
                    this.invokePromiseRejectedAfterResolved(promise, value);
                    break;
                }
                case 3: {
                    this.invokePromiseResolvedAfterResolved(promise, value);
                    break;
                }
                default: {
                    assert (false) : "Unknown operation: " + operation;
                    break;
                }
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void invokePromiseRejected(DynamicObject promise, Object value) {
        this.promiseRejectionTracker.promiseRejected(promise, value);
    }

    @CompilerDirectives.TruffleBoundary
    private void invokePromiseRejectionHandled(DynamicObject promise) {
        this.promiseRejectionTracker.promiseRejectionHandled(promise);
    }

    @CompilerDirectives.TruffleBoundary
    private void invokePromiseRejectedAfterResolved(DynamicObject promise, Object value) {
        this.promiseRejectionTracker.promiseRejectedAfterResolved(promise, value);
    }

    @CompilerDirectives.TruffleBoundary
    private void invokePromiseResolvedAfterResolved(DynamicObject promise, Object value) {
        this.promiseRejectionTracker.promiseResolvedAfterResolved(promise, value);
    }

    public final void setPromiseHook(PromiseHook promiseHook) {
        this.invalidatePromiseHookNotUsedAssumption();
        this.promiseHook = promiseHook;
    }

    private void invalidatePromiseHookNotUsedAssumption() {
        if (this.promiseHookNotUsedAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.promiseHookNotUsedAssumption.invalidate("promise hook unused");
        }
    }

    public final void notifyPromiseHook(int changeType, DynamicObject promise) {
        if (!this.promiseHookNotUsedAssumption.isValid() && this.promiseHook != null) {
            if (changeType == -1) {
                this.storeParentPromise(promise);
            } else {
                JSDynamicObject parent = changeType == 0 ? this.fetchParentPromise() : Undefined.instance;
                this.notifyPromiseHookImpl(changeType, promise, parent);
            }
        }
    }

    private void storeParentPromise(DynamicObject promise) {
        this.parentPromise = promise;
    }

    private DynamicObject fetchParentPromise() {
        DynamicObject parent = this.parentPromise;
        if (parent == null) {
            parent = Undefined.instance;
        } else {
            this.parentPromise = null;
        }
        return parent;
    }

    @CompilerDirectives.TruffleBoundary
    private void notifyPromiseHookImpl(int changeType, DynamicObject promise, DynamicObject parent) {
        this.promiseHook.promiseChanged(changeType, promise, parent);
    }

    public final void setImportMetaInitializer(ImportMetaInitializer importMetaInitializer) {
        this.importMetaInitializerNotUsedAssumption.invalidate("ImportMetaInitializer unused");
        this.importMetaInitializer = importMetaInitializer;
    }

    public final boolean hasImportMetaInitializerBeenSet() {
        return !this.importMetaInitializerNotUsedAssumption.isValid();
    }

    @CompilerDirectives.TruffleBoundary
    public final void notifyImportMetaInitializer(DynamicObject importMeta, JSModuleRecord module) {
        if (this.importMetaInitializer != null) {
            this.importMetaInitializer.initializeImportMeta(importMeta, module);
        }
    }

    public final void setImportModuleDynamicallyCallback(ImportModuleDynamicallyCallback callback) {
        this.importModuleDynamicallyCallbackNotUsedAssumption.invalidate();
        this.importModuleDynamicallyCallback = callback;
    }

    public final boolean hasImportModuleDynamicallyCallbackBeenSet() {
        return !this.importModuleDynamicallyCallbackNotUsedAssumption.isValid();
    }

    @CompilerDirectives.TruffleBoundary
    public final DynamicObject hostImportModuleDynamically(JSRealm realm, ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
        if (this.importModuleDynamicallyCallback != null) {
            return this.importModuleDynamicallyCallback.importModuleDynamically(realm, referrer, moduleRequest);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSFunctionData getOrCreateBuiltinFunctionData(BuiltinFunctionKey key, Function<JSContext, JSFunctionData> factory) {
        int index = key.ordinal();
        JSFunctionData functionData = this.builtinFunctionData[index];
        if (functionData != null) {
            return functionData;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        JSContext jSContext = this;
        synchronized (jSContext) {
            functionData = this.builtinFunctionData[index];
            if (functionData == null) {
                this.builtinFunctionData[index] = functionData = factory.apply(this);
            }
            return functionData;
        }
    }

    public final JSFunctionData getBuiltinFunctionData(Builtin key) {
        CompilerAsserts.neverPartOfCompilation();
        return this.builtinFunctionDataMap.get(key);
    }

    public final void putBuiltinFunctionData(Builtin key, JSFunctionData functionData) {
        CompilerAsserts.neverPartOfCompilation();
        this.builtinFunctionDataMap.putIfAbsent(key, functionData);
    }

    public final boolean neverCreatedChildRealms() {
        return this.singleRealmAssumption.isValid();
    }

    public final boolean isSingleRealm() {
        return !this.isMultiContext() && this.singleRealmAssumption.isValid();
    }

    public final Assumption getSingleRealmAssumption() {
        return this.singleRealmAssumption;
    }

    public JSContextOptions getContextOptions() {
        return this.contextOptions;
    }

    public final boolean isMultiContext() {
        return this.isMultiContext;
    }

    public JSFunctionFactory getFunctionFactory(JSFunctionData functionData) {
        boolean isBuiltin = functionData.isBuiltin();
        boolean strictFunctionProperties = functionData.hasStrictFunctionProperties();
        boolean isConstructor = functionData.isConstructor();
        boolean isGenerator = functionData.isGenerator();
        boolean isAsync = functionData.isAsync();
        assert (!isBuiltin || !isGenerator && !isAsync) : "built-in functions are never generator or async functions!";
        if (isAsync) {
            if (isGenerator) {
                return this.asyncGeneratorFunctionFactory;
            }
            return this.asyncFunctionFactory;
        }
        if (isGenerator) {
            return this.generatorFunctionFactory;
        }
        if (isConstructor && !isBuiltin) {
            if (strictFunctionProperties) {
                return this.strictConstructorFactory;
            }
            return this.constructorFactory;
        }
        if (strictFunctionProperties) {
            return this.strictFunctionFactory;
        }
        return this.functionFactory;
    }

    public JSFunctionFactory getBoundFunctionFactory(JSFunctionData functionData) {
        assert (functionData.isStrict());
        return this.boundFunctionFactory;
    }

    JSObjectFactory.RealmData newObjectFactoryRealmData() {
        if (this.isMultiContext()) {
            return null;
        }
        return new JSObjectFactory.RealmData(this.factoryCount);
    }

    private JSFunctionData throwTypeErrorFunction() {
        RootCallTarget throwTypeErrorCallTarget = new JavaScriptRootNode(this.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                throw Errors.createTypeError("[[ThrowTypeError]] defined by ECMAScript");
            }
        }.getCallTarget();
        return JSFunctionData.create(this, (CallTarget)throwTypeErrorCallTarget, (CallTarget)throwTypeErrorCallTarget, 0, "", false, false, false, true);
    }

    private JSFunctionData protoSetterFunction() {
        RootCallTarget callTarget = new JavaScriptRootNode(this.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                Object obj = JSRuntime.requireObjectCoercible(JSArguments.getThisObject(arguments), JSContext.this);
                if (JSArguments.getUserArgumentCount(arguments) < 1) {
                    return Undefined.instance;
                }
                Object value = JSArguments.getUserArgument(arguments, 0);
                if (!JSDynamicObject.isJSDynamicObject(value) || value == Undefined.instance) {
                    return Undefined.instance;
                }
                if (!JSDynamicObject.isJSDynamicObject(obj)) {
                    return Undefined.instance;
                }
                DynamicObject thisObj = (DynamicObject)obj;
                if (!JSObject.setPrototype(thisObj, (DynamicObject)value)) {
                    throw Errors.createTypeErrorCannotSetProto(thisObj, (DynamicObject)value);
                }
                return Undefined.instance;
            }
        }.getCallTarget();
        return JSFunctionData.createCallOnly(this, (CallTarget)callTarget, 0, "set __proto__");
    }

    private JSFunctionData protoGetterFunction() {
        RootCallTarget callTarget = new JavaScriptRootNode(this.getLanguage(), null, null){
            @Node.Child
            private JSToObjectNode toObjectNode;
            @Node.Child
            private GetPrototypeNode getPrototypeNode;
            {
                this.toObjectNode = JSToObjectNode.createToObject(JSContext.this);
                this.getPrototypeNode = GetPrototypeNode.create();
            }

            public Object execute(VirtualFrame frame) {
                Object obj = this.toObjectNode.execute(JSArguments.getThisObject(frame.getArguments()));
                if (JSDynamicObject.isJSDynamicObject(obj)) {
                    return this.getPrototypeNode.executeJSObject(obj);
                }
                return Null.instance;
            }
        }.getCallTarget();
        return JSFunctionData.createCallOnly(this, (CallTarget)callTarget, 0, "get __proto__");
    }

    public void checkEvalAllowed() {
        if (this.isOptionDisableEval()) {
            throw Errors.createEvalDisabled();
        }
    }

    public boolean isOptionLoadFromURL() {
        return this.contextOptions.isLoadFromURL();
    }

    public boolean isOptionLoadFromClasspath() {
        return this.contextOptions.isLoadFromClasspath();
    }

    public Locale getLocale() {
        Locale loc = this.locale;
        if (loc == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.locale = loc = this.getLocaleImpl();
        }
        return loc;
    }

    @CompilerDirectives.TruffleBoundary
    private Locale getLocaleImpl() {
        String name = this.getContextOptions().getLocale();
        if (name.isEmpty()) {
            return Locale.getDefault();
        }
        return Locale.forLanguageTag(name);
    }

    public PropertyProxy getArgumentsPropertyProxy() {
        return this.argumentsPropertyProxy;
    }

    public PropertyProxy getCallerPropertyProxy() {
        return this.callerPropertyProxy;
    }

    public <T extends Node> T adoptNode(T node) {
        assert (node.getParent() == null);
        this.sharedRootNode.insertAccessor(node);
        return node;
    }

    public boolean isOptionTopLevelAwait() {
        return this.getContextOptions().isTopLevelAwait();
    }

    public final Set<String> getSupportedImportAssertions() {
        return this.supportedImportAssertions;
    }

    public static String getTypeImportAssertion() {
        return TYPE_IMPORT_ASSERTION;
    }

    static final class SharedRootNode
    extends JavaScriptRootNode {
        SharedRootNode() {
        }

        public Object execute(VirtualFrame frame) {
            throw Errors.shouldNotReachHere();
        }

        void insertAccessor(Node node) {
            CompilerAsserts.neverPartOfCompilation();
            super.insert(node);
        }
    }

    public static enum BuiltinFunctionKey {
        ArrayFlattenIntoArray,
        AwaitFulfilled,
        AwaitRejected,
        AsyncGeneratorReturnFulfilled,
        AsyncGeneratorReturnRejected,
        AsyncFromSyncIteratorValueUnwrap,
        CollatorCompare,
        DateTimeFormatFormat,
        NumberFormatFormat,
        OrdinaryHasInstance,
        ProxyCall,
        ProxyRevokerFunction,
        PromiseResolveFunction,
        PromiseRejectFunction,
        PromiseGetCapabilitiesExecutor,
        PromiseResolveThenableJob,
        PromiseReactionJob,
        PromiseAllResolveElement,
        PromiseAllSettledResolveElement,
        PromiseAllSettledRejectElement,
        PromiseAnyRejectElement,
        PromiseThenFinally,
        PromiseCatchFinally,
        PromiseValueThunk,
        PromiseThrower,
        ImportModuleDynamically,
        JavaPackageToPrimitive,
        RegExpMultiLine,
        RegExpLastMatch,
        RegExpLastParen,
        RegExpLeftContext,
        RegExpRightContext,
        RegExp$1,
        RegExp$2,
        RegExp$3,
        RegExp$4,
        RegExp$5,
        RegExp$6,
        RegExp$7,
        RegExp$8,
        RegExp$9,
        SymbolGetDescription,
        MapGetSize,
        SetGetSize,
        ArrayBufferViewLength,
        ArrayBufferViewBuffer,
        ArrayBufferViewByteLength,
        ArrayBufferViewByteByteOffset,
        ArrayBufferViewToString,
        DataViewBuffer,
        DataViewByteLength,
        DataViewByteOffset,
        CollatorGetCompare,
        NumberFormatGetFormat,
        DateTimeFormatGetFormat,
        SegmenterBreakType,
        SegmenterPosition,
        FunctionAsyncIterator,
        IsGraalRuntime,
        AsyncModuleExecutionFulfilled,
        AsyncModuleExecutionRejected,
        TopLevelAwaitResolve,
        TopLevelAwaitReject,
        WebAssemblyInstanceGetExports,
        WebAssemblyMemoryGetBuffer,
        WebAssemblyTableGetLength,
        WebAssemblyGlobalGetValue,
        WebAssemblyGlobalSetValue,
        WebAssemblySourceInstantiation,
        FinishImportModuleDynamicallyReject,
        FinishImportModuleDynamicallyResolve;

    }
}

