/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.parser.env.DerivedEnvironment;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.runtime.JSContext;
import org.graalvm.collections.EconomicMap;

public final class GlobalEnvironment
extends DerivedEnvironment {
    private final EconomicMap<String, Boolean> lexicalDeclarations = EconomicMap.create();
    private final EconomicMap<String, Boolean> varDeclarations = EconomicMap.create();

    public GlobalEnvironment(Environment parent, NodeFactory factory, JSContext context) {
        super(parent, factory, context);
    }

    @Override
    public FrameSlot findBlockFrameSlot(Object name) {
        return null;
    }

    public boolean addLexicalDeclaration(String name, boolean isConst) {
        return this.lexicalDeclarations.put((Object)name, (Object)isConst) == null;
    }

    public boolean hasLexicalDeclaration(String name) {
        return this.lexicalDeclarations.containsKey((Object)name);
    }

    public boolean hasConstDeclaration(String name) {
        return (Boolean)this.lexicalDeclarations.get((Object)name, (Object)Boolean.FALSE);
    }

    public boolean addVarDeclaration(String name) {
        return this.varDeclarations.put((Object)name, (Object)Boolean.FALSE) == null;
    }

    public boolean hasVarDeclaration(String name) {
        return this.varDeclarations.containsKey((Object)name);
    }

    public static boolean isGlobalObjectConstant(String name) {
        switch (name) {
            case "undefined": 
            case "NaN": 
            case "Infinity": {
                return true;
            }
        }
        return false;
    }
}

