/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.InitializeInstanceElementsNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.CreateMethodPropertyNode;
import com.oracle.truffle.js.nodes.function.DefineMethodNode;
import com.oracle.truffle.js.nodes.function.FunctionNameHolder;
import com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.oracle.truffle.js.nodes.function.SetFunctionNameNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Null;
import java.util.Set;

public final class ClassDefinitionNode
extends JavaScriptNode
implements FunctionNameHolder {
    private final JSContext context;
    @Node.Child
    private JavaScriptNode constructorFunctionNode;
    @Node.Child
    private JavaScriptNode classHeritageNode;
    @Node.Children
    private final ObjectLiteralNode.ObjectLiteralMemberNode[] memberNodes;
    @Node.Child
    private JSWriteFrameSlotNode writeClassBindingNode;
    @Node.Child
    private PropertyGetNode getPrototypeNode;
    @Node.Child
    private CreateMethodPropertyNode setConstructorNode;
    @Node.Child
    private CreateObjectNode.CreateObjectWithPrototypeNode createPrototypeNode;
    @Node.Child
    private DefineMethodNode defineConstructorMethodNode;
    @Node.Child
    private PropertySetNode setFieldsNode;
    @Node.Child
    private InitializeInstanceElementsNode staticElementsNode;
    @Node.Child
    private PropertySetNode setPrivateBrandNode;
    @Node.Child
    private SetFunctionNameNode setFunctionName;
    @Node.Child
    private IsConstructorNode isConstructorNode;
    private final BranchProfile errorBranch = BranchProfile.create();
    private final boolean hasName;
    private final int instanceFieldCount;
    private final int staticElementCount;

    protected ClassDefinitionNode(JSContext context, JSFunctionExpressionNode constructorFunctionNode, JavaScriptNode classHeritageNode, ObjectLiteralNode.ObjectLiteralMemberNode[] memberNodes, JSWriteFrameSlotNode writeClassBindingNode, boolean hasName, int instanceFieldCount, int staticElementCount, boolean hasPrivateInstanceMethods, FrameSlot blockScopeSlot) {
        this.context = context;
        this.constructorFunctionNode = constructorFunctionNode;
        this.classHeritageNode = classHeritageNode;
        this.memberNodes = memberNodes;
        this.hasName = hasName;
        this.instanceFieldCount = instanceFieldCount;
        this.staticElementCount = staticElementCount;
        this.writeClassBindingNode = writeClassBindingNode;
        this.getPrototypeNode = PropertyGetNode.create("prototype", false, context);
        this.setConstructorNode = CreateMethodPropertyNode.create(context, "constructor");
        this.createPrototypeNode = CreateObjectNode.createOrdinaryWithPrototype(context);
        this.defineConstructorMethodNode = DefineMethodNode.create(context, constructorFunctionNode, blockScopeSlot);
        this.setFieldsNode = instanceFieldCount != 0 ? PropertySetNode.createSetHidden(JSFunction.CLASS_FIELDS_ID, context) : null;
        this.setPrivateBrandNode = hasPrivateInstanceMethods ? PropertySetNode.createSetHidden(JSFunction.PRIVATE_BRAND_ID, context) : null;
        this.setFunctionName = hasName ? null : SetFunctionNameNode.create();
        this.isConstructorNode = IsConstructorNode.create();
    }

    public static ClassDefinitionNode create(JSContext context, JSFunctionExpressionNode constructorFunction, JavaScriptNode classHeritage, ObjectLiteralNode.ObjectLiteralMemberNode[] members, JSWriteFrameSlotNode writeClassBinding, boolean hasName, int instanceFieldCount, int staticFieldCount, boolean hasPrivateInstanceMethods, FrameSlot blockScopeSlot) {
        return new ClassDefinitionNode(context, constructorFunction, classHeritage, members, writeClassBinding, hasName, instanceFieldCount, staticFieldCount, hasPrivateInstanceMethods, blockScopeSlot);
    }

    public DynamicObject execute(VirtualFrame frame) {
        return this.executeWithClassName(frame, null);
    }

    public DynamicObject executeWithClassName(VirtualFrame frame, Object className) {
        JSRealm realm = this.getRealm();
        Object protoParent = realm.getObjectPrototype();
        Object constructorParent = realm.getFunctionPrototype();
        if (this.classHeritageNode != null) {
            Object superclass = this.classHeritageNode.execute(frame);
            if (superclass == Null.instance) {
                protoParent = Null.instance;
            } else {
                if (!this.isConstructorNode.executeBoolean(superclass)) {
                    this.errorBranch.enter();
                    throw Errors.createTypeError("not a constructor", (Node)this);
                }
                if (JSRuntime.isGenerator(superclass)) {
                    this.errorBranch.enter();
                    throw Errors.createTypeError("class cannot extend a generator function", (Node)this);
                }
                protoParent = this.getPrototypeNode.getValue(superclass);
                if (protoParent != Null.instance && !JSRuntime.isObject(protoParent)) {
                    this.errorBranch.enter();
                    throw Errors.createTypeError("protoParent is neither Object nor Null", (Node)this);
                }
                constructorParent = superclass;
            }
        }
        assert (protoParent == Null.instance || JSRuntime.isObject(protoParent));
        DynamicObject proto = this.createPrototypeNode.execute(frame, (DynamicObject)protoParent);
        DynamicObject constructor = this.defineConstructorMethodNode.execute(frame, proto, (DynamicObject)constructorParent);
        JSFunction.setClassPrototype(constructor, proto);
        if (this.setFunctionName != null && className != null) {
            this.setFunctionName.execute(constructor, className);
        }
        this.setConstructorNode.executeVoid(proto, constructor);
        Object[][] instanceFields = this.instanceFieldCount == 0 ? (Object[][])null : new Object[this.instanceFieldCount][];
        Object[][] staticElements = this.staticElementCount == 0 ? (Object[][])null : new Object[this.staticElementCount][];
        this.initializeMembers(frame, proto, constructor, instanceFields, staticElements);
        if (this.writeClassBindingNode != null) {
            this.writeClassBindingNode.executeWrite(frame, constructor);
        }
        if (this.setFieldsNode != null) {
            this.setFieldsNode.setValue(constructor, instanceFields);
        }
        if (this.setPrivateBrandNode != null) {
            HiddenKey privateBrand = new HiddenKey("Brand");
            this.setPrivateBrandNode.setValue(constructor, privateBrand);
        }
        if (this.staticElementCount != 0) {
            InitializeInstanceElementsNode initializeStaticElements = this.staticElementsNode;
            if (initializeStaticElements == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.staticElementsNode = initializeStaticElements = (InitializeInstanceElementsNode)this.insert(InitializeInstanceElementsNode.create(this.context));
            }
            initializeStaticElements.executeStaticElements(constructor, staticElements);
        }
        return constructor;
    }

    @ExplodeLoop
    private void initializeMembers(VirtualFrame frame, DynamicObject proto, DynamicObject constructor, Object[][] instanceFields, Object[][] staticElements) {
        int instanceFieldIndex = 0;
        int staticElementIndex = 0;
        for (ObjectLiteralNode.ObjectLiteralMemberNode memberNode : this.memberNodes) {
            DynamicObject homeObject = memberNode.isStatic() ? constructor : proto;
            memberNode.executeVoid(frame, homeObject, this.context);
            if (!memberNode.isFieldOrStaticBlock()) continue;
            Object key = memberNode.evaluateKey(frame);
            Object value = memberNode.evaluateValue(frame, homeObject);
            Object[] field = new Object[]{key, value, memberNode.isAnonymousFunctionDefinition()};
            if (memberNode.isStatic()) {
                staticElements[staticElementIndex++] = field;
                continue;
            }
            if (instanceFields != null) {
                instanceFields[instanceFieldIndex++] = field;
                continue;
            }
            throw Errors.shouldNotReachHere();
        }
        assert (instanceFieldIndex == this.instanceFieldCount && staticElementIndex == this.staticElementCount);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == DynamicObject.class;
    }

    @Override
    public String getFunctionName() {
        return this.hasName ? ((FunctionNameHolder)((Object)this.constructorFunctionNode)).getFunctionName() : "";
    }

    @Override
    public void setFunctionName(String name) {
        ((FunctionNameHolder)((Object)this.constructorFunctionNode)).setFunctionName(name);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ClassDefinitionNode.create(this.context, (JSFunctionExpressionNode)ClassDefinitionNode.cloneUninitialized(this.constructorFunctionNode, materializedTags), ClassDefinitionNode.cloneUninitialized(this.classHeritageNode, materializedTags), ObjectLiteralNode.ObjectLiteralMemberNode.cloneUninitialized(this.memberNodes, materializedTags), ClassDefinitionNode.cloneUninitialized(this.writeClassBindingNode, materializedTags), this.hasName, this.instanceFieldCount, this.staticElementCount, this.setPrivateBrandNode != null, this.defineConstructorMethodNode.getBlockScopeSlot());
    }
}

