/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.js.nodes.CompileRegexNodeGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.RegexCompilerInterface;

@ImportStatic(value={JSConfig.class})
public abstract class CompileRegexNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private InteropLibrary isCompiledRegexNullNode;

    protected CompileRegexNode(JSContext context) {
        this.context = context;
    }

    public static CompileRegexNode create(JSContext context) {
        return CompileRegexNodeGen.create(context);
    }

    public final Object compile(String pattern) {
        return this.compile(pattern, "");
    }

    public final Object compile(CharSequence pattern, String flags) {
        return this.executeCompile(pattern, flags);
    }

    protected abstract Object executeCompile(CharSequence var1, String var2);

    @Specialization(guards={"stringEquals(pattern, cachedPattern)", "stringEquals(flags, cachedFlags)"}, limit="MaxCompiledRegexCacheLength")
    protected Object getCached(String pattern, String flags, @Cached(value="pattern") String cachedPattern, @Cached(value="flags") String cachedFlags, @Cached(value="createAssumedValue()") AssumedValue<Object> cachedCompiledRegex) {
        Object cached = cachedCompiledRegex.get();
        if (cached == null) {
            cached = this.doCompile(cachedPattern, cachedFlags);
            cachedCompiledRegex.set(cached);
        }
        return cached;
    }

    protected static boolean stringEquals(String a, String b) {
        return a.equals(b);
    }

    @Specialization(guards={"!TrimCompiledRegexCache"})
    protected Object doCompileNoTrimCache(String pattern, String flags) {
        return this.doCompile(pattern, flags);
    }

    @Specialization(replaces={"getCached"})
    @ReportPolymorphism.Megamorphic
    protected Object doCompile(String pattern, String flags) {
        return RegexCompilerInterface.compile(pattern, flags, this.context, this.getRealm(), this.getIsCompiledRegexNullNode());
    }

    private InteropLibrary getIsCompiledRegexNullNode() {
        if (this.isCompiledRegexNullNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isCompiledRegexNullNode = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(3));
        }
        return this.isCompiledRegexNullNode;
    }

    AssumedValue<Object> createAssumedValue() {
        return new AssumedValue("compiledRegex", null);
    }
}

