/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.NumberingSystem;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.LocalePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocale;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import java.util.Set;

public final class LocalePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<LocalePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new LocalePrototypeBuiltins();

    protected LocalePrototypeBuiltins() {
        super("Locale.prototype", LocalePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, LocalePrototype builtinEnum) {
        switch (builtinEnum) {
            case maximize: {
                return LocalePrototypeBuiltinsFactory.JSLocaleMaximizeNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case minimize: {
                return LocalePrototypeBuiltinsFactory.JSLocaleMinimizeNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toString: {
                return LocalePrototypeBuiltinsFactory.JSLocaleToStringNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case baseName: {
                return LocalePrototypeBuiltinsFactory.JSLocaleBaseNameAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case calendar: {
                return LocalePrototypeBuiltinsFactory.JSLocaleCalendarAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case caseFirst: {
                return LocalePrototypeBuiltinsFactory.JSLocaleCaseFirstAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case collation: {
                return LocalePrototypeBuiltinsFactory.JSLocaleCollationAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case hourCycle: {
                return LocalePrototypeBuiltinsFactory.JSLocaleHourCycleAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case numeric: {
                return LocalePrototypeBuiltinsFactory.JSLocaleNumericAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case numberingSystem: {
                return LocalePrototypeBuiltinsFactory.JSLocaleNumberingSystemAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case language: {
                return LocalePrototypeBuiltinsFactory.JSLocaleLanguageAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case script: {
                return LocalePrototypeBuiltinsFactory.JSLocaleScriptAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case region: {
                return LocalePrototypeBuiltinsFactory.JSLocaleRegionAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case calendars: {
                return LocalePrototypeBuiltinsFactory.JSLocaleCalendarsAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case collations: {
                return LocalePrototypeBuiltinsFactory.JSLocaleCollationsAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case hourCycles: {
                return LocalePrototypeBuiltinsFactory.JSLocaleHourCyclesAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case numberingSystems: {
                return LocalePrototypeBuiltinsFactory.JSLocaleNumberingSystemsAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case timeZones: {
                return LocalePrototypeBuiltinsFactory.JSLocaleTimeZonesAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case textInfo: {
                return LocalePrototypeBuiltinsFactory.JSLocaleTextInfoAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case weekInfo: {
                return LocalePrototypeBuiltinsFactory.JSLocaleWeekInfoAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSLocaleWeekInfoAccessor
    extends JSBuiltinNode {
        @Node.Child
        CreateDataPropertyNode createFirstDayNode = CreateDataPropertyNode.create(this.getContext(), "firstDay");
        @Node.Child
        CreateDataPropertyNode createWeekendNode = CreateDataPropertyNode.create(this.getContext(), "weekend");
        @Node.Child
        CreateDataPropertyNode createMinimalDaysNode = CreateDataPropertyNode.create(this.getContext(), "minimalDays");

        public JSLocaleWeekInfoAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            Calendar.WeekData weekData = JSLocaleWeekInfoAccessor.weekData(localeObject);
            int firstDay = JSLocaleWeekInfoAccessor.calendarToECMAScriptDay(weekData.firstDayOfWeek);
            int minimalDays = weekData.minimalDaysInFirstWeek;
            SimpleArrayList<Integer> weekendList = new SimpleArrayList<Integer>(7);
            int weekendCease = weekData.weekendCease;
            int day = weekData.weekendOnset;
            while (true) {
                weekendList.add(JSLocaleWeekInfoAccessor.calendarToECMAScriptDay(day), null);
                if (day == weekendCease) break;
                if (day == 7) {
                    day = 1;
                    continue;
                }
                ++day;
            }
            JSContext context = this.getContext();
            JSRealm realm = this.getRealm();
            DynamicObject weekend = JSArray.createConstantObjectArray(context, realm, weekendList.toArray());
            DynamicObject weekInfo = JSOrdinary.create(context, realm);
            this.createFirstDayNode.executeVoid(weekInfo, firstDay);
            this.createWeekendNode.executeVoid(weekInfo, weekend);
            this.createMinimalDaysNode.executeVoid(weekInfo, minimalDays);
            return weekInfo;
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }

        @CompilerDirectives.TruffleBoundary
        private static Calendar.WeekData weekData(DynamicObject localeObject) {
            ULocale locale = JSLocale.getInternalState(localeObject).getULocale();
            return Calendar.getInstance(locale).getWeekData();
        }

        private static int calendarToECMAScriptDay(int day) {
            return day == 1 ? 7 : day - 1;
        }
    }

    public static abstract class JSLocaleTextInfoAccessor
    extends JSBuiltinNode {
        @Node.Child
        CreateDataPropertyNode createDirectionNode = CreateDataPropertyNode.create(this.getContext(), "direction");

        public JSLocaleTextInfoAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            DynamicObject textInfo = JSOrdinary.create(this.getContext(), this.getRealm());
            this.createDirectionNode.executeVoid(textInfo, JSLocaleTextInfoAccessor.direction(localeObject));
            return textInfo;
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }

        @CompilerDirectives.TruffleBoundary
        private static String direction(DynamicObject localeObject) {
            ULocale locale = JSLocale.getInternalState(localeObject).getULocale();
            String orientation = locale.getCharacterOrientation();
            return "right-to-left".equals(orientation) ? "rtl" : "ltr";
        }
    }

    public static abstract class JSLocaleTimeZonesAccessor
    extends JSBuiltinNode {
        public JSLocaleTimeZonesAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            ULocale locale = JSLocale.getInternalState(localeObject).getULocale();
            String region = locale.getCountry();
            if (region.isEmpty()) {
                return Undefined.instance;
            }
            Set<String> timeZoneSet = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, region, null);
            Object[] timeZones = timeZoneSet.toArray(new Object[timeZoneSet.size()]);
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), timeZones);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleNumberingSystemsAccessor
    extends JSBuiltinNode {
        public JSLocaleNumberingSystemsAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            ULocale locale = JSLocale.getInternalState(localeObject).getULocale();
            String numberingSystem = locale.getUnicodeLocaleType("nu");
            if (numberingSystem == null) {
                numberingSystem = NumberingSystem.getInstance(locale).getName();
            }
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), new Object[]{numberingSystem});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleHourCyclesAccessor
    extends JSBuiltinNode {
        public JSLocaleHourCyclesAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            ULocale locale = JSLocale.getInternalState(localeObject).getULocale();
            String hourCycle = locale.getUnicodeLocaleType("hc");
            if (hourCycle == null) {
                DateTimePatternGenerator patternGenerator = DateTimePatternGenerator.getInstance(locale);
                hourCycle = IntlUtil.toJSHourCycle(patternGenerator.getDefaultHourCycle());
            }
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), new Object[]{hourCycle});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleCollationsAccessor
    extends JSBuiltinNode {
        public JSLocaleCollationsAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            ULocale locale = JSLocale.getInternalState(localeObject).getULocale();
            String collation = locale.getUnicodeLocaleType("co");
            Object[] collations = collation == null ? IntlUtil.availableCollations(locale, true) : new String[]{collation};
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), collations);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleCalendarsAccessor
    extends JSBuiltinNode {
        public JSLocaleCalendarsAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            ULocale locale = JSLocale.getInternalState(localeObject).getULocale();
            String calendar = locale.getUnicodeLocaleType("ca");
            Object[] calendars = calendar == null ? IntlUtil.availableCalendars(locale, true) : new String[]{calendar};
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), calendars);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleRegionAccessor
    extends JSBuiltinNode {
        public JSLocaleRegionAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            String region = JSLocale.getInternalState(localeObject).getRegion();
            return region.isEmpty() ? Undefined.instance : region;
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleScriptAccessor
    extends JSBuiltinNode {
        public JSLocaleScriptAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            String script = JSLocale.getInternalState(localeObject).getScript();
            return script.isEmpty() ? Undefined.instance : script;
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleLanguageAccessor
    extends JSBuiltinNode {
        public JSLocaleLanguageAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            String language = JSLocale.getInternalState(localeObject).getLanguage();
            return language.isEmpty() ? Undefined.instance : language;
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleNumberingSystemAccessor
    extends JSBuiltinNode {
        public JSLocaleNumberingSystemAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            return JSRuntime.nullToUndefined(JSLocale.getInternalState(localeObject).getNumberingSystem());
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleNumericAccessor
    extends JSBuiltinNode {
        public JSLocaleNumericAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public boolean doLocale(DynamicObject localeObject) {
            return JSLocale.getInternalState(localeObject).getNumeric();
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public boolean doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleHourCycleAccessor
    extends JSBuiltinNode {
        public JSLocaleHourCycleAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            return JSRuntime.nullToUndefined(JSLocale.getInternalState(localeObject).getHourCycle());
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleCollationAccessor
    extends JSBuiltinNode {
        public JSLocaleCollationAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            return JSRuntime.nullToUndefined(JSLocale.getInternalState(localeObject).getCollation());
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleCaseFirstAccessor
    extends JSBuiltinNode {
        public JSLocaleCaseFirstAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            return JSRuntime.nullToUndefined(JSLocale.getInternalState(localeObject).getCaseFirst());
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleCalendarAccessor
    extends JSBuiltinNode {
        public JSLocaleCalendarAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            return JSRuntime.nullToUndefined(JSLocale.getInternalState(localeObject).getCalendar());
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleBaseNameAccessor
    extends JSBuiltinNode {
        public JSLocaleBaseNameAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public String doLocale(DynamicObject localeObject) {
            return JSLocale.getInternalState(localeObject).getBaseName();
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public String doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleToStringNode
    extends JSBuiltinNode {
        public JSLocaleToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public String doLocale(DynamicObject localeObject) {
            return JSLocale.getInternalState(localeObject).getLocale();
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public String doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleMinimizeNode
    extends JSBuiltinNode {
        public JSLocaleMinimizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            String minimizedLocale = JSLocale.getInternalState(localeObject).minimize();
            return JSFunction.construct(this.getRealm().getLocaleConstructor(), new Object[]{minimizedLocale});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleMaximizeNode
    extends JSBuiltinNode {
        public JSLocaleMaximizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            String maximizedLocale = JSLocale.getInternalState(localeObject).maximize();
            return JSFunction.construct(this.getRealm().getLocaleConstructor(), new Object[]{maximizedLocale});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static enum LocalePrototype implements BuiltinEnum<LocalePrototype>
    {
        maximize(0),
        minimize(0),
        toString(0),
        baseName(0),
        calendar(0),
        caseFirst(0),
        collation(0),
        hourCycle(0),
        numeric(0),
        numberingSystem(0),
        language(0),
        script(0),
        region(0),
        calendars(0),
        collations(0),
        hourCycles(0),
        numberingSystems(0),
        timeZones(0),
        textInfo(0),
        weekInfo(0);

        private final int length;

        private LocalePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return baseName.ordinal() <= this.ordinal();
        }
    }
}

